/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import plugins.Library.util.Maps;

public class SortedSetMap<E, S extends SortedSet<E>>
extends AbstractMap<E, E>
implements Map<E, E>,
SortedMap<E, E> {
    protected final S bkset;
    private transient Set<Map.Entry<E, E>> entries;

    public SortedSetMap(S s) {
        this.bkset = s;
    }

    @Override
    public int size() {
        return this.bkset.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bkset.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.bkset.contains(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.bkset.contains(o);
    }

    @Override
    public void clear() {
        this.bkset.clear();
    }

    @Override
    public E put(E k, E v) {
        if (k != v) {
            throw new IllegalArgumentException("SortedMapSet: cannot accept a non-self mapping");
        }
        return this.bkset.add(k) ? null : (E)v;
    }

    @Override
    public E get(Object o) {
        return (E)(this.bkset.contains(o) ? o : null);
    }

    @Override
    public E remove(Object o) {
        return (E)(this.bkset.remove(o) ? o : null);
    }

    @Override
    public Set<Map.Entry<E, E>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet<Map.Entry<E, E>>(){

                @Override
                public int size() {
                    return SortedSetMap.this.bkset.size();
                }

                @Override
                public Iterator<Map.Entry<E, E>> iterator() {
                    return new Iterator<Map.Entry<E, E>>(){
                        final Iterator<E> it;
                        {
                            this.it = SortedSetMap.this.bkset.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public Map.Entry<E, E> next() {
                            Object e = this.it.next();
                            return Maps.$$(e, e);
                        }

                        @Override
                        public void remove() {
                            this.it.remove();
                        }
                    };
                }

                @Override
                public void clear() {
                    SortedSetMap.this.bkset.clear();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry en = (Map.Entry)o;
                    if (en.getKey() != en.getValue()) {
                        return false;
                    }
                    return SortedSetMap.this.bkset.contains(en.getKey());
                }

                @Override
                public boolean remove(Object o) {
                    boolean c = this.contains(o);
                    if (c) {
                        SortedSetMap.this.bkset.remove(((Map.Entry)o).getKey());
                    }
                    return c;
                }
            };
        }
        return this.entries;
    }

    @Override
    public SortedSet<E> keySet() {
        return this.bkset;
    }

    @Override
    public Collection<E> values() {
        return this.bkset;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.bkset.comparator();
    }

    @Override
    public E firstKey() {
        return this.bkset.first();
    }

    @Override
    public E lastKey() {
        return this.bkset.last();
    }

    @Override
    public SortedMap<E, E> headMap(E to) {
        return new SortedSetMap<E, SortedSet<E>>(this.bkset.headSet(to));
    }

    @Override
    public SortedMap<E, E> tailMap(E fr) {
        return new SortedSetMap<E, SortedSet<E>>(this.bkset.tailSet(fr));
    }

    @Override
    public SortedMap<E, E> subMap(E fr, E to) {
        return new SortedSetMap<E, SortedSet<E>>(this.bkset.subSet(fr, to));
    }
}

