/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util.event;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import plugins.Library.util.event.AbstractSweeper;

public class TrackingSweeper<T, C extends Collection<T>>
extends AbstractSweeper<T>
implements Iterable<T> {
    protected final C objs;
    protected final C objs_i;

    public TrackingSweeper(boolean autostart, boolean onceonly, C coll, C coll_immute) {
        super(autostart, onceonly);
        if (!coll.isEmpty()) {
            throw new IllegalArgumentException("TrackingSweeper: cannot use a non-empty collection");
        }
        this.objs = coll;
        this.objs_i = coll_immute == null ? coll : coll_immute;
    }

    public TrackingSweeper(boolean autostart, boolean onceonly, C coll) {
        this(autostart, onceonly, coll, TrackingSweeper.inferImmutable(coll));
    }

    public static <T, C extends Collection<T>> C inferImmutable(C coll) {
        if (coll instanceof SortedSet) {
            return (C)Collections.unmodifiableSortedSet((SortedSet)coll);
        }
        if (coll instanceof Set) {
            return (C)Collections.unmodifiableSet((Set)coll);
        }
        if (coll instanceof List) {
            return (C)Collections.unmodifiableList((List)coll);
        }
        return (C)Collections.unmodifiableCollection(coll);
    }

    public C view() {
        return this.objs_i;
    }

    @Override
    protected boolean add(T object) {
        return this.objs.add(object);
    }

    @Override
    protected boolean remove(T object) {
        return this.objs.remove(object);
    }

    @Override
    public int size() {
        return this.objs.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<T> it;
            {
                this.it = TrackingSweeper.this.objs.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                TrackingSweeper.this.releaseFrom(this.it);
            }
        };
    }
}

