/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util.exec;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import plugins.Library.util.exec.Execution;
import plugins.Library.util.exec.ExecutionAcceptor;
import plugins.Library.util.exec.ProgressParts;
import plugins.Library.util.exec.TaskAbortException;

public abstract class AbstractExecution<V>
implements Execution<V> {
    protected Date start;
    protected Date stop = null;
    protected final Set<ExecutionAcceptor<V>> accept = new HashSet<ExecutionAcceptor<V>>();
    protected final String subject;
    private TaskAbortException error;
    private V result;

    public AbstractExecution(String subj) {
        this.subject = subj;
        this.setStartDate();
    }

    protected synchronized void setStartDate() {
        if (this.start != null) {
            throw new IllegalStateException("Execution is already running");
        }
        this.start = new Date();
        for (ExecutionAcceptor<V> acc : this.accept) {
            this.offerStarted(acc);
        }
    }

    protected void offerStarted(ExecutionAcceptor<V> acc) {
        try {
            acc.acceptStarted(this);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected synchronized void setResult(V res) {
        if (this.stop != null) {
            throw new IllegalStateException("Execution has already finished.");
        }
        this.result = res;
        this.stop = new Date();
        this.notifyAll();
        for (ExecutionAcceptor<V> acc : this.accept) {
            this.offerDone(acc);
        }
    }

    protected void offerDone(ExecutionAcceptor<V> acc) {
        try {
            acc.acceptDone(this, this.result);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected synchronized void setError(TaskAbortException err) {
        if (this.stop != null) {
            throw new IllegalStateException("Execution has already finished.");
        }
        this.error = err;
        this.stop = new Date();
        this.notifyAll();
        for (ExecutionAcceptor<V> acc : this.accept) {
            this.offerAborted(acc);
        }
    }

    protected void offerAborted(ExecutionAcceptor<V> acc) {
        try {
            acc.acceptAborted(this, this.error);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public abstract String getStatus();

    @Override
    public abstract ProgressParts getParts() throws TaskAbortException;

    @Override
    public synchronized boolean isDone() throws TaskAbortException {
        if (this.error != null) {
            throw this.error;
        }
        return this.result != null;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.start != null;
    }

    @Override
    public synchronized void join() throws InterruptedException, TaskAbortException {
        while (this.stop == null) {
            this.wait();
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public Date getStartDate() {
        return this.start;
    }

    @Override
    public long getTimeElapsed() {
        return System.currentTimeMillis() - this.start.getTime();
    }

    @Override
    public long getTimeTaken() {
        if (this.stop == null) {
            return -1L;
        }
        return this.stop.getTime() - this.start.getTime();
    }

    @Override
    public V getResult() throws TaskAbortException {
        if (this.error != null) {
            throw this.error;
        }
        return this.result;
    }

    @Override
    public synchronized void addAcceptor(ExecutionAcceptor<V> acc) {
        this.accept.add(acc);
        if (this.start != null) {
            this.offerStarted(acc);
        }
        if (this.error != null) {
            this.offerDone(acc);
        }
        if (this.result != null) {
            this.offerAborted(acc);
        }
    }
}

