/*
 * Decompiled with CFR 0.152.
 */
package plugins.JSTUN;

import freenet.clients.http.PageNode;
import freenet.pluginmanager.DetectedIP;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginHTTP;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginRealVersioned;
import freenet.pluginmanager.FredPluginThreadless;
import freenet.pluginmanager.FredPluginVersioned;
import freenet.pluginmanager.PluginHTTPException;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;
import org.tanukisoftware.wrapper.WrapperManager;
import plugins.JSTUN.de.javawi.jstun.test.DiscoveryInfo;
import plugins.JSTUN.de.javawi.jstun.test.DiscoveryTest_;

public class JSTUN
implements FredPlugin,
FredPluginIPDetector,
FredPluginThreadless,
FredPluginHTTP,
FredPluginVersioned,
FredPluginRealVersioned {
    static String[] publicSTUNServers = new String[]{"stun.voipbuster.com", "stun.ekiga.net", "stun.ideasip.com", "stun.iptel.org", "stun.rixtelecom.se", "stun.schlund.de", "stun.softjoys.com", "stun.voiparound.com", "stun.voipstunt.com", "stun.voxgratia.org", "stun.xten.com", "stunserver.org"};
    private DiscoveryInfo reportedData;
    private PluginRespirator pr;
    private boolean hasRunTestBeenCalled = false;
    private final HashSet detected = new HashSet();
    private final HashSet detectors = new HashSet();

    DetectedIP[] runTest(InetAddress iaddress) {
        this.hasRunTestBeenCalled = true;
        Random r = new Random();
        Vector<String> v = new Vector<String>(publicSTUNServers.length);
        Vector<DetectedIP> out = new Vector<DetectedIP>();
        int countLikely = 0;
        int countUnlikely = 0;
        for (int i = 0; i < publicSTUNServers.length; ++i) {
            v.add(publicSTUNServers[i]);
        }
        while (!v.isEmpty()) {
            if (WrapperManager.hasShutdownHookBeenTriggered()) {
                return null;
            }
            String stunServer = (String)v.remove(r.nextInt(v.size()));
            try {
                DiscoveryTest_ test = new DiscoveryTest_(iaddress, stunServer, 3478);
                this.reportedData = test.test();
                if ((this.reportedData.isBlockedUDP() || this.reportedData.isError()) && !v.isEmpty()) {
                    Logger.error((Object)this, (String)("Server unreachable?: " + stunServer));
                    continue;
                }
                Logger.normal((Object)this, (String)("Successful STUN discovery from " + stunServer + "!:" + this.reportedData + " likely detections: " + countLikely + " unlikely detections " + countUnlikely + " remaining " + v.size()));
                System.err.println("Successful STUN discovery from " + stunServer + "!:" + this.reportedData + " likely detections: " + countLikely + " unlikely detections " + countUnlikely + " remaining " + v.size());
                DetectedIP ip = this.convert(this.reportedData);
                if (ip == null) {
                    Logger.normal((Object)this, (String)("Failed to parse reported data, skipping server " + stunServer));
                    continue;
                }
                out.add(ip);
                if (ip.natType == 8 || ip.natType == 1 || ip.natType == 6 || ip.natType == 7) {
                    ++countUnlikely;
                } else {
                    ++countLikely;
                }
                if (countUnlikely < 3 && countLikely < 2 && !v.isEmpty()) continue;
                return out.toArray(new DetectedIP[out.size()]);
            }
            catch (BindException be) {
                System.err.println(iaddress.toString() + ": " + be.getMessage());
            }
            catch (UnknownHostException e) {
                System.err.println("Could not find the STUN server " + stunServer + " : " + e + " - DNS problems? Trying another...");
            }
            catch (SocketException e) {
                System.err.println("Could not connect to the STUN server: " + stunServer + " : " + e + " - trying another...");
            }
            catch (Exception e) {
                System.err.println("Failed to run STUN to server " + stunServer + ": " + e + " - trying another, report if persistent");
                e.printStackTrace();
            }
        }
        System.err.println("STUN failed: likely detections=" + countLikely + " unlikely detections=" + countUnlikely);
        return null;
    }

    public static void main(String[] args) {
        int failures = 0;
        for (String hostname : publicSTUNServers) {
            try {
                System.out.print("Resolving " + hostname + "... ");
                InetAddress address = InetAddress.getByName(hostname);
                System.out.println(address.getHostAddress());
            }
            catch (UnknownHostException e) {
                ++failures;
                System.out.println("failed.");
            }
        }
        if (failures > 0) {
            System.out.println(failures + " hostnames failed to resolve.");
            System.exit(1);
        } else {
            System.out.println("All hostnames resolved successfully.");
        }
    }

    private DetectedIP convert(DiscoveryInfo info) {
        InetAddress addr = info.getPublicIP();
        if (addr == null || addr.isLinkLocalAddress() || addr.isSiteLocalAddress()) {
            return null;
        }
        if (info.isError()) {
            return null;
        }
        if (info.isOpenAccess()) {
            return new DetectedIP(addr, 2);
        }
        if (info.isBlockedUDP()) {
            return new DetectedIP(addr, 8);
        }
        if (info.isFullCone()) {
            return new DetectedIP(addr, 3);
        }
        if (info.isRestrictedCone()) {
            return new DetectedIP(addr, 4);
        }
        if (info.isPortRestrictedCone()) {
            return new DetectedIP(addr, 5);
        }
        if (info.isSymmetricCone()) {
            return new DetectedIP(addr, 6);
        }
        if (info.isSymmetricUDPFirewall()) {
            return new DetectedIP(addr, 7);
        }
        return new DetectedIP(addr, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetectedIP[] getAddress() {
        Enumeration<NetworkInterface> ifaces;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            System.err.println("Caught " + e1);
            e1.printStackTrace();
            return null;
        }
        while (ifaces.hasMoreElements()) {
            if (WrapperManager.hasShutdownHookBeenTriggered()) {
                return null;
            }
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
            while (iaddresses.hasMoreElements()) {
                InetAddress iaddress = iaddresses.nextElement();
                if (iaddress.isLoopbackAddress() || iaddress.isLinkLocalAddress()) continue;
                DetectorThread detector = new DetectorThread(iaddress);
                JSTUN jSTUN = this;
                synchronized (jSTUN) {
                    this.detectors.add(detector);
                }
                try {
                    detector.start();
                }
                catch (Throwable t) {
                    JSTUN jSTUN2 = this;
                    synchronized (jSTUN2) {
                        this.detectors.remove(detector);
                    }
                }
            }
        }
        JSTUN jSTUN = this;
        synchronized (jSTUN) {
            while (true) {
                if (this.detectors.isEmpty()) {
                    if (this.detected.isEmpty()) {
                        System.err.println("STUN failed to detect IP addresses");
                        return null;
                    }
                    DetectedIP[] ips = this.detected.toArray(new DetectedIP[this.detected.size()]);
                    return ips;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void terminate() {
    }

    public void runPlugin(PluginRespirator pr) {
        this.pr = pr;
    }

    public String handleHTTPGet(HTTPRequest request) throws PluginHTTPException {
        PageNode page = this.pr.getPageMaker().getPageNode("JSTUN plugin", false, null);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (this.reportedData == null) {
            if (this.hasRunTestBeenCalled) {
                HTMLNode jSTUNReportInfobox = contentNode.addChild("div", "class", "infobox infobox-warning");
                HTMLNode jSTUNReportInfoboxHeader = jSTUNReportInfobox.addChild("div", "class", "infobox-header");
                HTMLNode jSTUNReportInfoboxContent = jSTUNReportInfobox.addChild("div", "class", "infobox-content");
                jSTUNReportInfoboxHeader.addChild("#", "JSTUN detection report");
                jSTUNReportInfoboxContent.addChild("#", "The plugin hasn't managed to contact any server yet.");
            } else {
                HTMLNode jSTUNReportInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
                HTMLNode jSTUNReportInfoboxHeader = jSTUNReportInfobox.addChild("div", "class", "infobox-header");
                HTMLNode jSTUNReportInfoboxContent = jSTUNReportInfobox.addChild("div", "class", "infobox-content");
                jSTUNReportInfoboxHeader.addChild("#", "JSTUN detection report");
                jSTUNReportInfoboxContent.addChild("#", "There is no need for the plugin to determine your ip address: the node knows it.");
            }
        } else {
            HTMLNode jSTUNReportErrorInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode jSTUNReportInfoboxHeader = jSTUNReportErrorInfobox.addChild("div", "class", "infobox-header");
            HTMLNode jSTUNReportInfoboxContent = jSTUNReportErrorInfobox.addChild("div", "class", "infobox-content");
            jSTUNReportInfoboxHeader.addChild("#", "JSTUN detection report");
            jSTUNReportInfoboxContent.addChild("#", "The plugin has reported the following data to the node:");
            HTMLNode data = jSTUNReportInfoboxContent.addChild("pre");
            data.addChild("#", this.reportedData.toString());
        }
        return pageNode.generate();
    }

    public String handleHTTPPost(HTTPRequest request) throws PluginHTTPException {
        return null;
    }

    public String handleHTTPPut(HTTPRequest request) throws PluginHTTPException {
        return null;
    }

    public String getVersion() {
        return "1.4";
    }

    public long getRealVersion() {
        return 5L;
    }

    class DetectorThread
    extends Thread {
        final InetAddress startAddress;

        DetectorThread(InetAddress addr) {
            this.startAddress = addr;
            this.setDaemon(true);
            this.setName("STUN IP detector for " + addr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DetectedIP[] ip;
            try {
                ip = JSTUN.this.runTest(this.startAddress);
                NetworkInterface nif = NetworkInterface.getByInetAddress(this.startAddress);
                int mtu = -1;
                if (nif != null) {
                    try {
                        Integer iMTU;
                        Class<?> c = nif.getClass();
                        Method m = c.getDeclaredMethod("getMTU", new Class[0]);
                        if (m != null && (iMTU = (Integer)m.invoke((Object)nif, new Object[0])) != null) {
                            mtu = iMTU;
                            System.err.println("Found interface MTU: " + nif.getName() + " : " + mtu);
                        }
                    }
                    catch (Throwable t) {
                        System.err.println("Trying to access 1.6 getMTU(), caught " + t);
                    }
                }
                if (ip != null) {
                    for (int i = 0; i < ip.length; ++i) {
                        ip[i].mtu = mtu;
                    }
                }
            }
            catch (Throwable t) {
                ip = null;
                System.err.println("Caught " + t);
                t.printStackTrace();
            }
            JSTUN jSTUN = JSTUN.this;
            synchronized (jSTUN) {
                JSTUN.this.detectors.remove(this);
                if (ip != null) {
                    for (int i = 0; i < ip.length; ++i) {
                        JSTUN.this.detected.add(ip[i]);
                    }
                }
                JSTUN.this.notifyAll();
            }
        }
    }
}

