/*
 * Decompiled with CFR 0.152.
 */
package plugins.JSTUN.de.javawi.jstun.attribute;

import plugins.JSTUN.de.javawi.jstun.attribute.MessageAttribute;
import plugins.JSTUN.de.javawi.jstun.attribute.MessageAttributeInterface;
import plugins.JSTUN.de.javawi.jstun.attribute.MessageAttributeParsingException;
import plugins.JSTUN.de.javawi.jstun.util.Utility;
import plugins.JSTUN.de.javawi.jstun.util.UtilityException;

public class ChangeRequest
extends MessageAttribute {
    boolean changeIP = false;
    boolean changePort = false;

    public ChangeRequest() {
        super(MessageAttributeInterface.MessageAttributeType.ChangeRequest);
    }

    public boolean isChangeIP() {
        return this.changeIP;
    }

    public boolean isChangePort() {
        return this.changePort;
    }

    public void setChangeIP() {
        this.changeIP = true;
    }

    public void setChangePort() {
        this.changePort = true;
    }

    @Override
    public byte[] getBytes() throws UtilityException {
        byte[] result = new byte[8];
        System.arraycopy(Utility.IntegerToTwoBytes(ChangeRequest.typeToInteger(this.type)), 0, result, 0, 2);
        System.arraycopy(Utility.IntegerToTwoBytes(4), 0, result, 2, 2);
        if (this.changeIP) {
            result[7] = Utility.IntegerToOneByte(4);
        }
        if (this.changePort) {
            result[7] = Utility.IntegerToOneByte(2);
        }
        if (this.changeIP && this.changePort) {
            result[7] = Utility.IntegerToOneByte(6);
        }
        return result;
    }

    public static ChangeRequest parse(byte[] data) throws MessageAttributeParsingException {
        try {
            if (data.length < 4) {
                throw new MessageAttributeParsingException("Data array too short");
            }
            ChangeRequest cr = new ChangeRequest();
            int status = Utility.OneByteToInteger(data[3]);
            switch (status) {
                case 2: {
                    cr.setChangePort();
                    break;
                }
                case 4: {
                    cr.setChangeIP();
                    break;
                }
                case 6: {
                    cr.setChangeIP();
                    cr.setChangePort();
                    break;
                }
                default: {
                    throw new MessageAttributeParsingException("Status parsing error");
                }
            }
            return cr;
        }
        catch (UtilityException ue) {
            throw new MessageAttributeParsingException("Parsing error");
        }
    }
}

