/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.UnitConverter;

public final class AddConverter
extends UnitConverter {
    private final double _offset;
    private static final long serialVersionUID = 1L;

    public AddConverter(double offset) {
        if (offset == 0.0) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this._offset = offset;
    }

    public double getOffset() {
        return this._offset;
    }

    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof AddConverter) {
            double offset = this._offset + ((AddConverter)converter)._offset;
            return offset == 0.0 ? IDENTITY : new AddConverter(offset);
        }
        return super.concatenate(converter);
    }

    public AddConverter inverse() {
        return new AddConverter(-this._offset);
    }

    public double convert(double value) {
        return value + this._offset;
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.add(BigDecimal.valueOf(this._offset), ctx);
    }

    public final String toString() {
        return "AddConverter(" + this._offset + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddConverter)) {
            return false;
        }
        AddConverter that = (AddConverter)obj;
        return this._offset == that._offset;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this._offset);
        return (int)(bits ^ bits >>> 32);
    }
}

