/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.MutableVariantFilesMetadata;
import org.gradle.api.artifacts.VariantFileMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.DefaultVariantFileMetadata;

public class DefaultMutableVariantFilesMetadata
implements MutableVariantFilesMetadata {
    private boolean clearExistingFiles = false;
    private final List<VariantFileMetadata> files = new ArrayList<VariantFileMetadata>();

    public void removeAllFiles() {
        this.clearExistingFiles = true;
        this.files.clear();
    }

    public void addFile(String name) {
        this.addFile(name, name);
    }

    public void addFile(String name, String url) {
        for (VariantFileMetadata file : this.files) {
            if (!file.getName().equals(name)) continue;
            throw new InvalidUserDataException("Cannot add file " + name + " (url: " + url + ") because it is already defined (url: " + file.getUrl() + ")");
        }
        this.files.add(new DefaultVariantFileMetadata(name, url));
    }

    public boolean isClearExistingFiles() {
        return this.clearExistingFiles;
    }

    public List<VariantFileMetadata> getFiles() {
        return this.files;
    }
}

