/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.util.MindMapUtils;

public class CommentsUtils {
    private CommentsUtils() {
    }

    public static void collectTopicsWithComments(ITopic topic, List<ITopic> result) {
        if (topic.getOwnedWorkbook().getCommentManager().hasComments(topic.getId())) {
            result.add(topic);
        }
        Iterator childIt = topic.getAllChildrenIterator();
        while (childIt.hasNext()) {
            CommentsUtils.collectTopicsWithComments((ITopic)childIt.next(), result);
        }
    }

    public static void insertTopic(List<ITopic> topics, ITopic topic) {
        if (topics == null || topics.size() == 0 || topics.contains(topic)) {
            return;
        }
        List<ITopic> allTopics = MindMapUtils.getAllTopics(topic.getOwnedSheet(), true, true);
        int index = allTopics.indexOf(topic);
        int i = index + 1;
        while (i < allTopics.size()) {
            ITopic t = allTopics.get(i);
            if (topics.contains(t)) {
                topics.add(topics.indexOf(t), topic);
                return;
            }
            ++i;
        }
        topics.add(topic);
    }

    public static void addRecursiveMouseListener(Control c, MouseListener ml, Control excludeControl) {
        if (c == null || c.isDisposed() || ml == null || c == excludeControl) {
            return;
        }
        c.addMouseListener(ml);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cc = controlArray[n2];
                CommentsUtils.addRecursiveMouseListener(cc, ml, excludeControl);
                ++n2;
            }
        }
    }

    public static void removeRecursiveMouseListener(Control c, MouseListener ml, Control excludeControl) {
        if (c == null || c.isDisposed() || ml == null || c == excludeControl) {
            return;
        }
        c.removeMouseListener(ml);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cc = controlArray[n2];
                CommentsUtils.removeRecursiveMouseListener(cc, ml, excludeControl);
                ++n2;
            }
        }
    }

    public static void reveal(IGraphicalEditor editor, Object target) {
        ISelectionProvider selectionProvider;
        if (editor == null) {
            return;
        }
        editor.getSite().getPage().activate((IWorkbenchPart)editor);
        if ((target instanceof ITopic || target instanceof ISheet) && (selectionProvider = editor.getSite().getSelectionProvider()) != null) {
            selectionProvider.setSelection((ISelection)new StructuredSelection(target));
        }
    }
}

