/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;
import org.xmind.core.marker.IMarker;
import org.xmind.gef.IDecorator;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.ui.internal.decorators.LegendItemDecorator;
import org.xmind.ui.internal.figures.LegendItemFigure;
import org.xmind.ui.internal.mindmap.LegendItem;
import org.xmind.ui.internal.mindmap.LegendPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.svgsupport.SVGImageData;
import org.xmind.ui.internal.svgsupport.SVGReference;
import org.xmind.ui.mindmap.ILegendItemPart;
import org.xmind.ui.mindmap.ILegendPart;
import org.xmind.ui.util.MarkerImageDescriptor;

public class LegendItemPart
extends MindMapPartBase
implements ILegendItemPart,
PropertyChangeListener {
    private ImageDescriptor icon = null;
    private Image image = null;
    private SVGReference svgRef = null;
    private boolean deactivated = false;
    private LocalResourceManager resourceManager;

    public LegendItemPart() {
        this.setDecorator((IDecorator)LegendItemDecorator.getInstance());
    }

    protected IFigure createFigure() {
        boolean useAdvancedRenderer = this.getSite().getViewer().getProperties().getBoolean("renderTextAsPath", false);
        return new LegendItemFigure(useAdvancedRenderer ? 1 : 0, this.svgRef != null ? this.getResourceManager() : null);
    }

    public void setParent(IPart parent) {
        LegendPart legend;
        if (this.getParent() instanceof LegendPart) {
            legend = (LegendPart)this.getParent();
            legend.removeItem(this);
        }
        super.setParent(parent);
        if (this.getParent() instanceof LegendPart) {
            legend = (LegendPart)this.getParent();
            legend.addItem(this);
        }
    }

    @Override
    public ILegendPart getOwnedLegend() {
        if (this.getParent() instanceof ILegendPart) {
            return (ILegendPart)this.getParent();
        }
        return null;
    }

    public LegendItem getItem() {
        return (LegendItem)super.getModel();
    }

    @Override
    public String getMarkerId() {
        return this.getItem().getMarkerId();
    }

    @Override
    public String getDescription() {
        return this.getItem().getDescription();
    }

    @Override
    public Image getIconImage() {
        if (this.image == null && !this.deactivated) {
            this.image = this.createImage();
        }
        return this.image;
    }

    private Image createImage() {
        if (this.icon == null) {
            IMarker marker = this.getItem().getMarker();
            if (marker == null) {
                return null;
            }
            this.icon = MarkerImageDescriptor.createFromMarker(marker);
        }
        if (this.icon == null) {
            return null;
        }
        return this.icon.createImage(false);
    }

    @Override
    public SVGImageData getSVGData() {
        if (this.deactivated) {
            return null;
        }
        return this.svgRef == null ? null : this.svgRef.getSVGData();
    }

    @Override
    protected void onActivated() {
        super.onActivated();
        this.getSite().getViewer().getProperties().addPropertyChangeListener("renderTextAsPath", (PropertyChangeListener)this);
    }

    @Override
    protected void onDeactivated() {
        this.getSite().getViewer().getProperties().removePropertyChangeListener("renderTextAsPath", (PropertyChangeListener)this);
        this.deactivated = true;
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.svgRef != null) {
            this.svgRef = null;
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.onDeactivated();
    }

    public void setModel(Object model) {
        super.setModel(model);
        if (model instanceof LegendItem) {
            String svgPath;
            LegendItem item = (LegendItem)model;
            IMarker marker = item.getMarker();
            String string = svgPath = marker != null ? marker.getSVGPath() : null;
            if (svgPath != null && !"".equals(svgPath)) {
                this.svgRef = this.createSVGReference();
            }
        }
    }

    private SVGReference createSVGReference() {
        String resourcePath = "platform:/plugin/org.xmind.ui.resources/markers/" + this.getItem().getMarker().getSVGPath();
        SVGReference ref = new SVGReference(resourcePath);
        return ref;
    }

    public LocalResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("movable role", "org.xmind.ui.editPolicy.legendMovable");
        reqHandler.installEditPolicy("editable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("modifiable role", "org.xmind.ui.editPolicy.legendItemModifiable");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean useAdvancedRenderer = this.getSite().getViewer().getProperties().getBoolean("renderTextAsPath", false);
        ((LegendItemFigure)this.getFigure()).setTextRenderStyle(useAdvancedRenderer ? 1 : 0);
    }
}

