/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.evernote.signin;

import com.evernote.auth.EvernoteAuth;
import com.evernote.auth.EvernoteService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.EvernoteApi;
import org.scribe.exceptions.OAuthConnectionException;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.xmind.ui.evernote.EvernotePlugin;
import org.xmind.ui.internal.evernote.ErrorStatusDialog;
import org.xmind.ui.internal.evernote.EvernoteMessages;

public class SignInDialog
extends Dialog
implements IJobChangeListener {
    private boolean DEBUGGING = EvernotePlugin.getDefault().isDebugging("/debug");
    private static final String CONSUMER_KEY = "xmind";
    private static final String CONSUMER_SECRET = "ee87a7c738511e29";
    private static final String CALLBACK_URL = "Home.action";
    private static final String LANGUAGE = Platform.getNL();
    private static final String NL_CN = "zh_CN";
    private static final String KEY_CONNECTING_AREA = "org.xmind.ui.evernote.SignInDialog.connectingArea";
    private static final String KEY_BROWSER = "org,xmind.ui.evernote.SignInDialog.browser";
    private Shell currentShell;
    private Job signInJob;
    private Properties data;
    private TabFolder tabFolder;
    private int returnCode;

    public SignInDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(66800);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.currentShell = newShell;
    }

    protected Point getInitialSize() {
        return new Point(780, 550);
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new FillLayout());
        this.createTabFolder(composite);
        return composite;
    }

    private void createTabFolder(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        final TabItem evernoteItem = new TabItem(this.tabFolder, 0);
        evernoteItem.setText(EvernoteMessages.EvernoteSignInDialog_EvernoteTab_text);
        this.createContentsForTabItem(evernoteItem);
        final TabItem yinxiangItem = new TabItem(this.tabFolder, 0);
        yinxiangItem.setText(EvernoteMessages.EvernoteSignInDialog_YinxiangTab_text);
        this.createContentsForTabItem(yinxiangItem);
        EvernoteService service = this.getEvernoteService();
        this.updateContents(this.getEvernoteService());
        this.tabFolder.setSelection(service == EvernoteService.PRODUCTION ? evernoteItem : yinxiangItem);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SignInDialog.this.tabFolder.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                TabItem item = SignInDialog.this.tabFolder.getItem(index);
                if (item == evernoteItem) {
                    SignInDialog.this.updateContents(EvernoteService.PRODUCTION);
                } else if (item == yinxiangItem) {
                    SignInDialog.this.updateContents(EvernoteService.YINXIANG);
                }
            }
        });
    }

    private void createContentsForTabItem(TabItem item) {
        Composite parent = new Composite((Composite)item.getParent(), 0);
        StackLayout layout = new StackLayout();
        parent.setLayout((Layout)layout);
        Control connectingArea = this.createConnectingArea(parent);
        Browser browser = new Browser(parent, 0);
        layout.topControl = connectingArea;
        item.setControl((Control)parent);
        item.setData(KEY_CONNECTING_AREA, (Object)connectingArea);
        item.setData(KEY_BROWSER, (Object)browser);
    }

    private Browser getCurrentBrowser() {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return null;
        }
        int index = this.tabFolder.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return (Browser)this.tabFolder.getItem(index).getData(KEY_BROWSER);
    }

    private Control createConnectingArea(Composite parent) {
        Composite connectingArea = new Composite(parent, 0);
        connectingArea.setLayout((Layout)new GridLayout(1, false));
        Label messageLabel = new Label(connectingArea, 0);
        messageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        messageLabel.setText(EvernoteMessages.EvernoteSignInDialog_Connecting_label);
        return connectingArea;
    }

    private void updateOAuthArea(boolean showBrowser) {
        int index = this.tabFolder.getSelectionIndex();
        if (index < 0) {
            return;
        }
        TabItem item = this.tabFolder.getItem(index);
        Control connectingArea = (Control)item.getData(KEY_CONNECTING_AREA);
        StackLayout stack = (StackLayout)connectingArea.getParent().getLayout();
        stack.topControl = showBrowser ? (Control)item.getData(KEY_BROWSER) : connectingArea;
        connectingArea.getParent().layout(true, true);
    }

    private void updateContents(EvernoteService service) {
        if (service == EvernoteService.PRODUCTION) {
            this.currentShell.setText(EvernoteMessages.EvernoteSignInDialog_Evernote_title);
        } else if (service == EvernoteService.YINXIANG) {
            this.currentShell.setText(EvernoteMessages.EvernoteSignInDialog_Yinxiang_title);
        }
        this.startJob(service);
    }

    private void startJob(EvernoteService service) {
        this.stopJob();
        OAuthJob job = new OAuthJob(this, service);
        job.addJobChangeListener(this);
        job.setSystem(false);
        job.setUser(true);
        job.schedule();
        this.signInJob = job;
    }

    private void stopJob() {
        Job job = this.signInJob;
        if (job != null) {
            job.cancel();
            job = null;
        }
    }

    private void gotoURL(final LocationListener listener, final String url) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Browser browser = SignInDialog.this.getCurrentBrowser();
                SignInDialog.this.gotoURL(browser, url);
                browser.addLocationListener(listener);
            }
        });
    }

    private void gotoURL(final Browser browser, final String url) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (browser != null && !browser.isDisposed()) {
                    SignInDialog.this.updateOAuthArea(true);
                    browser.setUrl(url);
                    if (Util.isMac()) {
                        browser.refresh();
                    }
                    browser.setFocus();
                }
            }
        });
    }

    private EvernoteService getEvernoteService() {
        if (NL_CN.equals(LANGUAGE)) {
            return EvernoteService.YINXIANG;
        }
        return EvernoteService.PRODUCTION;
    }

    public void done(IJobChangeEvent event) {
        Job job = event.getJob();
        job.removeJobChangeListener((IJobChangeListener)this);
        if (job != this.signInJob) {
            return;
        }
        this.signInJob = null;
        final IStatus result = event.getResult();
        if (result.getSeverity() != 0 && result.getMessage() != null) {
            final Shell shell = this.getParentShell();
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorStatusDialog errorDialog = new ErrorStatusDialog(shell, result.getMessage());
                    int code = errorDialog.open();
                    if (code == 0 || code == 1) {
                        errorDialog.close();
                        SignInDialog.this.doClose();
                    }
                }
            });
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private boolean doClose() {
        boolean closed = super.close();
        if (closed) {
            this.stopJob();
        }
        return closed;
    }

    public Properties getData() {
        return this.data;
    }

    public int getCode() {
        return this.returnCode;
    }

    private class OAuthJob
    extends Job
    implements LocationListener {
        private static final String OAUTH_VERIFIER_NAME = "oauth_verifier=";
        private static final int OAUTH_VERIFIER_LENGTH = 32;
        private OAuthService oauthService;
        private EvernoteService evernoteService;
        private Token requestToken;

        public OAuthJob(SignInDialog dialog, EvernoteService evernoteService) {
            super(EvernoteMessages.EvernoteOAuthJob_title);
            this.evernoteService = evernoteService;
            if (SignInDialog.this.DEBUGGING) {
                System.out.println("EvernoteService:" + evernoteService.name());
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.oauthService = this.createOAuthService(this.getEvernoteAPI());
            try {
                this.requestToken = this.oauthService.getRequestToken();
            }
            catch (OAuthConnectionException e) {
                return new Status(2, "org.xmind.ui.evernote", NLS.bind((String)EvernoteMessages.EvernoteExportJob_OtherException_message_withErrorMessage, (Object)e.getMessage()), (Throwable)e);
            }
            String url = this.oauthService.getAuthorizationUrl(this.requestToken);
            if (SignInDialog.this.DEBUGGING) {
                System.out.println("OAuthUrl:" + url);
            }
            SignInDialog.this.gotoURL(this, url);
            return Status.OK_STATUS;
        }

        private Class<? extends EvernoteApi> getEvernoteAPI() {
            return this.evernoteService == EvernoteService.PRODUCTION ? EvernoteApi.class : EvernoteApi.Yinxiang.class;
        }

        private OAuthService createOAuthService(Class<? extends EvernoteApi> provider) {
            return new ServiceBuilder().provider(provider).apiKey(SignInDialog.CONSUMER_KEY).apiSecret(SignInDialog.CONSUMER_SECRET).callback(SignInDialog.CALLBACK_URL).build();
        }

        public void changed(LocationEvent event) {
            String query = this.getQuery(event);
            if (query == null) {
                return;
            }
            String verifier = this.getOAuthVerifier(query);
            if (verifier != null && !"".equals(verifier)) {
                if (SignInDialog.this.DEBUGGING) {
                    System.out.println("verifier:" + verifier);
                }
                this.removeBrowserListener();
                this.loadUserInfo(this.evernoteService, this.getAccessToken(verifier));
            }
        }

        private String getOAuthVerifier(String url) {
            if (!url.contains(OAUTH_VERIFIER_NAME)) {
                return null;
            }
            int beginIndex = url.indexOf(OAUTH_VERIFIER_NAME) + OAUTH_VERIFIER_NAME.length();
            int endIndex = beginIndex + 32;
            if (url.length() > endIndex) {
                return url.substring(beginIndex, endIndex);
            }
            return url.substring(beginIndex);
        }

        private String getQuery(LocationEvent event) {
            String query = null;
            try {
                URL url = new URL(event.location);
                query = url.getQuery();
            }
            catch (MalformedURLException malformedURLException) {}
            return query;
        }

        private void removeBrowserListener() {
            Browser browser = SignInDialog.this.getCurrentBrowser();
            if (browser != null && !browser.isDisposed()) {
                browser.stop();
                browser.removeLocationListener((LocationListener)this);
            }
        }

        private Token getAccessToken(String verifier) {
            return this.oauthService.getAccessToken(this.requestToken, new Verifier(verifier));
        }

        private void loadUserInfo(EvernoteService evernoteService, Token token) {
            this.setUserInfo(token);
            SignInDialog.this.setReturnCode(0);
            SignInDialog.this.returnCode = 0;
            SignInDialog.this.doClose();
        }

        private void setUserInfo(Token token) {
            EvernoteAuth evernoteAuth = EvernoteAuth.parseOAuthResponse((EvernoteService)this.evernoteService, (String)token.getRawResponse());
            SignInDialog.this.data = new Properties();
            SignInDialog.this.data.setProperty("token", evernoteAuth.getToken());
            SignInDialog.this.data.setProperty("serviceType", this.evernoteService.name());
            if (SignInDialog.this.DEBUGGING) {
                System.out.println("Token:" + evernoteAuth.getToken());
            }
        }

        public void changing(LocationEvent event) {
        }
    }
}

