/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.edam.limits;

import java.util.HashSet;
import java.util.Set;

public class Constants {
    public static final int EDAM_ATTRIBUTE_LEN_MIN = 1;
    public static final int EDAM_ATTRIBUTE_LEN_MAX = 4096;
    public static final String EDAM_ATTRIBUTE_REGEX = "^[^\\p{Cc}\\p{Zl}\\p{Zp}]{1,4096}$";
    public static final int EDAM_ATTRIBUTE_LIST_MAX = 100;
    public static final int EDAM_ATTRIBUTE_MAP_MAX = 100;
    public static final int EDAM_GUID_LEN_MIN = 36;
    public static final int EDAM_GUID_LEN_MAX = 36;
    public static final String EDAM_GUID_REGEX = "^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$";
    public static final int EDAM_EMAIL_LEN_MIN = 6;
    public static final int EDAM_EMAIL_LEN_MAX = 255;
    public static final String EDAM_EMAIL_LOCAL_REGEX = "^[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+)*$";
    public static final String EDAM_EMAIL_DOMAIN_REGEX = "^[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*\\.([A-Za-z]{2,})$";
    public static final String EDAM_EMAIL_REGEX = "^[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*\\.([A-Za-z]{2,})$";
    public static final String EDAM_VAT_REGEX = "^((AT)?U[0-9]{8}|(BE)?0?[0-9]{9}|(BG)?[0-9]{9,10}|(CY)?[0-9]{8}L|(CZ)?[0-9]{8,10}|(DE)?[0-9]{9}|(DK)?[0-9]{8}|(EE)?[0-9]{9}|(EL|GR)?[0-9]{9}|(ES)?[0-9A-Z][0-9]{7}[0-9A-Z]|(FI)?[0-9]{8}|(FR)?[0-9A-Z]{2}[0-9]{9}|(GB)?([0-9]{9}([0-9]{3})?|[A-Z]{2}[0-9]{3})|(HU)?[0-9]{8}|(IE)?[0-9]S[0-9]{5}L|(IT)?[0-9]{11}|(LT)?([0-9]{9}|[0-9]{12})|(LU)?[0-9]{8}|(LV)?[0-9]{11}|(MT)?[0-9]{8}|(NL)?[0-9]{9}B[0-9]{2}|(PL)?[0-9]{10}|(PT)?[0-9]{9}|(RO)?[0-9]{2,10}|(SE)?[0-9]{12}|(SI)?[0-9]{8}|(SK)?[0-9]{10})|[0-9]{9}MVA|[0-9]{6}|CHE[0-9]{9}(TVA|MWST|IVA)$";
    public static final int EDAM_TIMEZONE_LEN_MIN = 1;
    public static final int EDAM_TIMEZONE_LEN_MAX = 32;
    public static final String EDAM_TIMEZONE_REGEX = "^([A-Za-z_-]+(/[A-Za-z_-]+)*)|(GMT(-|\\+)[0-9]{1,2}(:[0-9]{2})?)$";
    public static final int EDAM_MIME_LEN_MIN = 3;
    public static final int EDAM_MIME_LEN_MAX = 255;
    public static final String EDAM_MIME_REGEX = "^[A-Za-z]+/[A-Za-z0-9._+-]+$";
    public static final String EDAM_MIME_TYPE_GIF = "image/gif";
    public static final String EDAM_MIME_TYPE_JPEG = "image/jpeg";
    public static final String EDAM_MIME_TYPE_PNG = "image/png";
    public static final String EDAM_MIME_TYPE_WAV = "audio/wav";
    public static final String EDAM_MIME_TYPE_MP3 = "audio/mpeg";
    public static final String EDAM_MIME_TYPE_AMR = "audio/amr";
    public static final String EDAM_MIME_TYPE_AAC = "audio/aac";
    public static final String EDAM_MIME_TYPE_M4A = "audio/mp4";
    public static final String EDAM_MIME_TYPE_MP4_VIDEO = "video/mp4";
    public static final String EDAM_MIME_TYPE_INK = "application/vnd.evernote.ink";
    public static final String EDAM_MIME_TYPE_PDF = "application/pdf";
    public static final String EDAM_MIME_TYPE_DEFAULT = "application/octet-stream";
    public static final Set<String> EDAM_MIME_TYPES = new HashSet<String>();
    public static final Set<String> EDAM_INDEXABLE_RESOURCE_MIME_TYPES;
    public static final int EDAM_SEARCH_QUERY_LEN_MIN = 0;
    public static final int EDAM_SEARCH_QUERY_LEN_MAX = 1024;
    public static final String EDAM_SEARCH_QUERY_REGEX = "^[^\\p{Cc}\\p{Zl}\\p{Zp}]{0,1024}$";
    public static final int EDAM_HASH_LEN = 16;
    public static final int EDAM_USER_USERNAME_LEN_MIN = 1;
    public static final int EDAM_USER_USERNAME_LEN_MAX = 64;
    public static final String EDAM_USER_USERNAME_REGEX = "^[a-z0-9]([a-z0-9_-]{0,62}[a-z0-9])?$";
    public static final int EDAM_USER_NAME_LEN_MIN = 1;
    public static final int EDAM_USER_NAME_LEN_MAX = 255;
    public static final String EDAM_USER_NAME_REGEX = "^[^\\p{Cc}\\p{Zl}\\p{Zp}]{1,255}$";
    public static final int EDAM_TAG_NAME_LEN_MIN = 1;
    public static final int EDAM_TAG_NAME_LEN_MAX = 100;
    public static final String EDAM_TAG_NAME_REGEX = "^[^,\\p{Cc}\\p{Z}]([^,\\p{Cc}\\p{Zl}\\p{Zp}]{0,98}[^,\\p{Cc}\\p{Z}])?$";
    public static final int EDAM_NOTE_TITLE_LEN_MIN = 1;
    public static final int EDAM_NOTE_TITLE_LEN_MAX = 255;
    public static final String EDAM_NOTE_TITLE_REGEX = "^[^\\p{Cc}\\p{Z}]([^\\p{Cc}\\p{Zl}\\p{Zp}]{0,253}[^\\p{Cc}\\p{Z}])?$";
    public static final int EDAM_NOTE_CONTENT_LEN_MIN = 0;
    public static final int EDAM_NOTE_CONTENT_LEN_MAX = 0x500000;
    public static final int EDAM_APPLICATIONDATA_NAME_LEN_MIN = 3;
    public static final int EDAM_APPLICATIONDATA_NAME_LEN_MAX = 32;
    public static final int EDAM_APPLICATIONDATA_VALUE_LEN_MIN = 0;
    public static final int EDAM_APPLICATIONDATA_VALUE_LEN_MAX = 4092;
    public static final int EDAM_APPLICATIONDATA_ENTRY_LEN_MAX = 4095;
    public static final String EDAM_APPLICATIONDATA_NAME_REGEX = "^[A-Za-z0-9_.-]{3,32}$";
    public static final String EDAM_APPLICATIONDATA_VALUE_REGEX = "^[^\\p{Cc}]{0,4092}$";
    public static final int EDAM_NOTEBOOK_NAME_LEN_MIN = 1;
    public static final int EDAM_NOTEBOOK_NAME_LEN_MAX = 100;
    public static final String EDAM_NOTEBOOK_NAME_REGEX = "^[^\\p{Cc}\\p{Z}]([^\\p{Cc}\\p{Zl}\\p{Zp}]{0,98}[^\\p{Cc}\\p{Z}])?$";
    public static final int EDAM_NOTEBOOK_STACK_LEN_MIN = 1;
    public static final int EDAM_NOTEBOOK_STACK_LEN_MAX = 100;
    public static final String EDAM_NOTEBOOK_STACK_REGEX = "^[^\\p{Cc}\\p{Z}]([^\\p{Cc}\\p{Zl}\\p{Zp}]{0,98}[^\\p{Cc}\\p{Z}])?$";
    public static final int EDAM_PUBLISHING_URI_LEN_MIN = 1;
    public static final int EDAM_PUBLISHING_URI_LEN_MAX = 255;
    public static final String EDAM_PUBLISHING_URI_REGEX = "^[a-zA-Z0-9.~_+-]{1,255}$";
    public static final Set<String> EDAM_PUBLISHING_URI_PROHIBITED;
    public static final int EDAM_PUBLISHING_DESCRIPTION_LEN_MIN = 1;
    public static final int EDAM_PUBLISHING_DESCRIPTION_LEN_MAX = 200;
    public static final String EDAM_PUBLISHING_DESCRIPTION_REGEX = "^[^\\p{Cc}\\p{Z}]([^\\p{Cc}\\p{Zl}\\p{Zp}]{0,198}[^\\p{Cc}\\p{Z}])?$";
    public static final int EDAM_SAVED_SEARCH_NAME_LEN_MIN = 1;
    public static final int EDAM_SAVED_SEARCH_NAME_LEN_MAX = 100;
    public static final String EDAM_SAVED_SEARCH_NAME_REGEX = "^[^\\p{Cc}\\p{Z}]([^\\p{Cc}\\p{Zl}\\p{Zp}]{0,98}[^\\p{Cc}\\p{Z}])?$";
    public static final int EDAM_USER_PASSWORD_LEN_MIN = 6;
    public static final int EDAM_USER_PASSWORD_LEN_MAX = 64;
    public static final String EDAM_USER_PASSWORD_REGEX = "^[A-Za-z0-9!#$%&'()*+,./:;<=>?@^_`{|}~\\[\\]\\\\-]{6,64}$";
    public static final int EDAM_BUSINESS_URI_LEN_MAX = 32;
    public static final int EDAM_NOTE_TAGS_MAX = 100;
    public static final int EDAM_NOTE_RESOURCES_MAX = 1000;
    public static final int EDAM_USER_TAGS_MAX = 100000;
    public static final int EDAM_BUSINESS_TAGS_MAX = 100000;
    public static final int EDAM_USER_SAVED_SEARCHES_MAX = 100;
    public static final int EDAM_USER_NOTES_MAX = 100000;
    public static final int EDAM_BUSINESS_NOTES_MAX = 500000;
    public static final int EDAM_USER_NOTEBOOKS_MAX = 250;
    public static final int EDAM_BUSINESS_NOTEBOOKS_MAX = 5000;
    public static final int EDAM_USER_RECENT_MAILED_ADDRESSES_MAX = 10;
    public static final int EDAM_USER_MAIL_LIMIT_DAILY_FREE = 50;
    public static final int EDAM_USER_MAIL_LIMIT_DAILY_PREMIUM = 200;
    public static final long EDAM_USER_UPLOAD_LIMIT_FREE = 0x3C00000L;
    public static final long EDAM_USER_UPLOAD_LIMIT_PREMIUM = 0x40000000L;
    public static final long EDAM_USER_UPLOAD_LIMIT_BUSINESS = Integer.MAX_VALUE;
    public static final int EDAM_NOTE_SIZE_MAX_FREE = 0x1900000;
    public static final int EDAM_NOTE_SIZE_MAX_PREMIUM = 0x6400000;
    public static final int EDAM_RESOURCE_SIZE_MAX_FREE = 0x1900000;
    public static final int EDAM_RESOURCE_SIZE_MAX_PREMIUM = 0x6400000;
    public static final int EDAM_USER_LINKED_NOTEBOOK_MAX = 100;
    public static final int EDAM_USER_LINKED_NOTEBOOK_MAX_PREMIUM = 250;
    public static final int EDAM_NOTEBOOK_SHARED_NOTEBOOK_MAX = 250;
    public static final int EDAM_NOTE_CONTENT_CLASS_LEN_MIN = 3;
    public static final int EDAM_NOTE_CONTENT_CLASS_LEN_MAX = 32;
    public static final String EDAM_NOTE_CONTENT_CLASS_REGEX = "^[A-Za-z0-9_.-]{3,32}$";
    public static final String EDAM_HELLO_APP_CONTENT_CLASS_PREFIX = "evernote.hello.";
    public static final String EDAM_FOOD_APP_CONTENT_CLASS_PREFIX = "evernote.food.";
    public static final String EDAM_CONTENT_CLASS_HELLO_ENCOUNTER = "evernote.hello.encounter";
    public static final String EDAM_CONTENT_CLASS_HELLO_PROFILE = "evernote.hello.profile";
    public static final String EDAM_CONTENT_CLASS_FOOD_MEAL = "evernote.food.meal";
    public static final String EDAM_CONTENT_CLASS_SKITCH_PREFIX = "evernote.skitch";
    public static final String EDAM_CONTENT_CLASS_SKITCH = "evernote.skitch";
    public static final String EDAM_CONTENT_CLASS_SKITCH_PDF = "evernote.skitch.pdf";
    public static final String EDAM_CONTENT_CLASS_PENULTIMATE_PREFIX = "evernote.penultimate.";
    public static final String EDAM_CONTENT_CLASS_PENULTIMATE_NOTEBOOK = "evernote.penultimate.notebook";
    public static final int EDAM_RELATED_PLAINTEXT_LEN_MIN = 1;
    public static final int EDAM_RELATED_PLAINTEXT_LEN_MAX = 131072;
    public static final int EDAM_RELATED_MAX_NOTES = 25;
    public static final int EDAM_RELATED_MAX_NOTEBOOKS = 1;
    public static final int EDAM_RELATED_MAX_TAGS = 25;
    public static final int EDAM_BUSINESS_NOTEBOOK_DESCRIPTION_LEN_MIN = 1;
    public static final int EDAM_BUSINESS_NOTEBOOK_DESCRIPTION_LEN_MAX = 200;
    public static final String EDAM_BUSINESS_NOTEBOOK_DESCRIPTION_REGEX = "^[^\\p{Cc}\\p{Z}]([^\\p{Cc}\\p{Zl}\\p{Zp}]{0,198}[^\\p{Cc}\\p{Z}])?$";
    public static final int EDAM_BUSINESS_PHONE_NUMBER_LEN_MAX = 20;
    public static final int EDAM_PREFERENCE_NAME_LEN_MIN = 3;
    public static final int EDAM_PREFERENCE_NAME_LEN_MAX = 32;
    public static final int EDAM_PREFERENCE_VALUE_LEN_MIN = 1;
    public static final int EDAM_PREFERENCE_VALUE_LEN_MAX = 1024;
    public static final int EDAM_MAX_PREFERENCES = 100;
    public static final int EDAM_MAX_VALUES_PER_PREFERENCE = 256;
    public static final String EDAM_PREFERENCE_NAME_REGEX = "^[A-Za-z0-9_.-]{3,32}$";
    public static final String EDAM_PREFERENCE_VALUE_REGEX = "^[^\\p{Cc}]{1,1024}$";
    public static final String EDAM_PREFERENCE_SHORTCUTS = "evernote.shortcuts";
    public static final int EDAM_PREFERENCE_SHORTCUTS_MAX_VALUES = 250;
    public static final int EDAM_DEVICE_ID_LEN_MAX = 32;
    public static final String EDAM_DEVICE_ID_REGEX = "^[^\\p{Cc}]{1,32}$";
    public static final int EDAM_DEVICE_DESCRIPTION_LEN_MAX = 64;
    public static final String EDAM_DEVICE_DESCRIPTION_REGEX = "^[^\\p{Cc}]{1,64}$";
    public static final int EDAM_SEARCH_SUGGESTIONS_MAX = 10;
    public static final int EDAM_SEARCH_SUGGESTIONS_PREFIX_LEN_MAX = 1024;
    public static final int EDAM_SEARCH_SUGGESTIONS_PREFIX_LEN_MIN = 2;

    static {
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_GIF);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_JPEG);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_PNG);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_WAV);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_MP3);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_AMR);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_INK);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_PDF);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_MP4_VIDEO);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_AAC);
        EDAM_MIME_TYPES.add(EDAM_MIME_TYPE_M4A);
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES = new HashSet<String>();
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/msword");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/mspowerpoint");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/excel");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/vnd.ms-word");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/vnd.ms-powerpoint");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/vnd.ms-excel");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/vnd.apple.pages");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/vnd.apple.numbers");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/vnd.apple.keynote");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/x-iwork-pages-sffpages");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/x-iwork-numbers-sffnumbers");
        EDAM_INDEXABLE_RESOURCE_MIME_TYPES.add("application/x-iwork-keynote-sffkey");
        EDAM_PUBLISHING_URI_PROHIBITED = new HashSet<String>();
        EDAM_PUBLISHING_URI_PROHIBITED.add("..");
    }
}

