/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.File;
import java.io.FileFilter;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.DirectoryOutputTarget;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;

public class DirectoryStorage
implements IStorage {
    private File dir;
    private FileFilter filter;

    public DirectoryStorage(File dir) {
        this(dir, null);
    }

    public DirectoryStorage(File dir, FileFilter filter) {
        this.dir = dir;
        this.filter = filter;
    }

    public String getFullPath() {
        return this.dir.getAbsolutePath();
    }

    public IInputSource getInputSource() {
        return new DirectoryInputSource(this.dir, this.filter);
    }

    public String getName() {
        return this.dir.getName();
    }

    public IOutputTarget getOutputTarget() {
        return new DirectoryOutputTarget(this.dir);
    }

    public void clear() {
        FileUtils.delete(this.dir);
    }

    public void deleteEntry(String entryName) {
        File f = new File(this.dir, entryName);
        while (f != null && !f.equals(this.dir)) {
            if (f.isFile() || f.isDirectory() && f.list().length == 0) {
                f.delete();
            }
            f = f.getParentFile();
        }
        this.dir.delete();
    }

    public void renameEntry(String entryName, String newName) {
        File targetFile = new File(this.dir, newName);
        File targetParent = targetFile.getParentFile();
        if (targetParent != null) {
            targetParent.mkdirs();
        }
        new File(this.dir, entryName).renameTo(targetFile);
        this.deleteEntry(entryName);
    }

    public String toString() {
        return this.dir.toString();
    }

    public int hashCode() {
        return this.dir.hashCode() ^ (this.filter == null ? 37 : this.filter.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof DirectoryStorage)) {
            return false;
        }
        DirectoryStorage that = (DirectoryStorage)obj;
        return this.dir.equals(that.dir) && (this.filter == that.filter || this.filter != null && this.filter.equals(that.filter));
    }
}

