/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.nio.ByteBuffer;
import nxt.Constants;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.EffectiveBalanceLeasingAttachment;
import nxt.blockchain.Fee;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import org.json.simple.JSONObject;

public abstract class AccountControlFxtTransactionType
extends FxtTransactionType {
    public static final TransactionType EFFECTIVE_BALANCE_LEASING = new AccountControlFxtTransactionType(){

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return new Fee.ConstantFee(10000000L);
        }

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ACCOUNT_CONTROL_EFFECTIVE_BALANCE_LEASING;
        }

        @Override
        public String getName() {
            return "EffectiveBalanceLeasing";
        }

        @Override
        public EffectiveBalanceLeasingAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new EffectiveBalanceLeasingAttachment(byteBuffer);
        }

        @Override
        public EffectiveBalanceLeasingAttachment parseAttachment(JSONObject jSONObject) {
            return new EffectiveBalanceLeasingAttachment(jSONObject);
        }

        @Override
        protected void applyAttachment(FxtTransactionImpl fxtTransactionImpl, Account account, Account account2) {
            EffectiveBalanceLeasingAttachment effectiveBalanceLeasingAttachment = (EffectiveBalanceLeasingAttachment)fxtTransactionImpl.getAttachment();
            Account.getAccount(fxtTransactionImpl.getSenderId()).leaseEffectiveBalance(fxtTransactionImpl.getRecipientId(), effectiveBalanceLeasingAttachment.getPeriod());
        }

        @Override
        protected void validateAttachment(FxtTransactionImpl fxtTransactionImpl) throws NxtException.ValidationException {
            EffectiveBalanceLeasingAttachment effectiveBalanceLeasingAttachment = (EffectiveBalanceLeasingAttachment)fxtTransactionImpl.getAttachment();
            if (fxtTransactionImpl.getSenderId() == fxtTransactionImpl.getRecipientId()) {
                throw new NxtException.NotValidException("Account cannot lease balance to itself");
            }
            if (fxtTransactionImpl.getAmount() != 0L) {
                throw new NxtException.NotValidException("Transaction amount must be 0 for effective balance leasing");
            }
            if (effectiveBalanceLeasingAttachment.getPeriod() < Constants.LEASING_DELAY || effectiveBalanceLeasingAttachment.getPeriod() > 65535) {
                throw new NxtException.NotValidException("Invalid effective balance leasing period: " + effectiveBalanceLeasingAttachment.getPeriod());
            }
            byte[] byArray = Account.getPublicKey(fxtTransactionImpl.getRecipientId());
            if (byArray == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid effective balance leasing:  recipient account " + Long.toUnsignedString(fxtTransactionImpl.getRecipientId()) + " not found or no public key published");
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }
    };

    private AccountControlFxtTransactionType() {
    }

    @Override
    public final byte getType() {
        return -3;
    }

    @Override
    protected final boolean applyAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
        return true;
    }

    @Override
    protected final void undoAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
    }
}

