/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.account.AccountPropertyTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.StringRw;
import org.json.simple.JSONObject;

public final class AccountInfoAttachment
extends Attachment.AbstractAttachment {
    public static final StringRw NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 100);
    public static final StringRw DESCRIPTION_RW = new StringRw(LengthRwPrimitiveType.SHORT, 1000);
    private final String name;
    private final String description;

    AccountInfoAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.name = NAME_RW.readFromBuffer(byteBuffer);
        this.description = DESCRIPTION_RW.readFromBuffer(byteBuffer);
    }

    AccountInfoAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.name = Convert.nullToEmpty((String)jSONObject.get((Object)"name"));
        this.description = Convert.nullToEmpty((String)jSONObject.get((Object)"description"));
    }

    public AccountInfoAttachment(String string, String string2) {
        this.name = string;
        this.description = string2;
    }

    @Override
    protected int getMySize() {
        return NAME_RW.getSize(this.name) + DESCRIPTION_RW.getSize(this.description);
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        NAME_RW.writeToBuffer(this.name, byteBuffer);
        DESCRIPTION_RW.writeToBuffer(this.description, byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"name", (Object)this.name);
        jSONObject.put((Object)"description", (Object)this.description);
    }

    @Override
    public TransactionType getTransactionType() {
        return AccountPropertyTransactionType.ACCOUNT_INFO;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

