/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.ae.Asset;
import nxt.blockchain.Chain;
import nxt.ms.Currency;
import nxt.util.security.BlockchainPermission;

public enum HoldingType {
    COIN(0){

        @Override
        public int getDecimals(long l) {
            return Chain.getChain(Math.toIntExact(l)).getDecimals();
        }

        @Override
        public long getBalance(Account account, long l) {
            return Chain.getChain(Math.toIntExact(l)).getBalanceHome().getBalance(account.getId()).getBalance();
        }

        @Override
        public long getUnconfirmedBalance(Account account, long l) {
            return Chain.getChain(Math.toIntExact(l)).getBalanceHome().getBalance(account.getId()).getUnconfirmedBalance();
        }

        @Override
        public void addToBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            account.addToBalance(Chain.getChain(Math.toIntExact(l)), ledgerEvent, ledgerEventId, l2);
        }

        @Override
        public void addToUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            account.addToUnconfirmedBalance(Chain.getChain(Math.toIntExact(l)), ledgerEvent, ledgerEventId, l2);
        }

        @Override
        public void addToBalanceAndUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            account.addToBalanceAndUnconfirmedBalance(Chain.getChain(Math.toIntExact(l)), ledgerEvent, ledgerEventId, l2);
        }
    }
    ,
    ASSET(1){

        @Override
        public int getDecimals(long l) {
            return Asset.getAsset(l).getDecimals();
        }

        @Override
        public long getBalance(Account account, long l) {
            return account.getAssetBalanceQNT(l);
        }

        @Override
        public long getUnconfirmedBalance(Account account, long l) {
            return account.getUnconfirmedAssetBalanceQNT(l);
        }

        @Override
        public void addToBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            account.addToAssetBalanceQNT(ledgerEvent, ledgerEventId, l, l2);
        }

        @Override
        public void addToUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            account.addToUnconfirmedAssetBalanceQNT(ledgerEvent, ledgerEventId, l, l2);
        }

        @Override
        public void addToBalanceAndUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            account.addToAssetAndUnconfirmedAssetBalanceQNT(ledgerEvent, ledgerEventId, l, l2);
        }
    }
    ,
    CURRENCY(2){

        @Override
        public int getDecimals(long l) {
            return Currency.getCurrency(l, true).getDecimals();
        }

        @Override
        public long getBalance(Account account, long l) {
            return account.getCurrencyUnits(l);
        }

        @Override
        public long getUnconfirmedBalance(Account account, long l) {
            return account.getUnconfirmedCurrencyUnits(l);
        }

        @Override
        public void addToBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            account.addToCurrencyUnits(ledgerEvent, ledgerEventId, l, l2);
        }

        @Override
        public void addToUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            account.addToUnconfirmedCurrencyUnits(ledgerEvent, ledgerEventId, l, l2);
        }

        @Override
        public void addToBalanceAndUnconfirmedBalance(Account account, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
            account.addToCurrencyAndUnconfirmedCurrencyUnits(ledgerEvent, ledgerEventId, l, l2);
        }
    };

    private final byte code;

    public static HoldingType get(byte by) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("holding"));
        }
        for (HoldingType holdingType : HoldingType.values()) {
            if (holdingType.getCode() != by) continue;
            return holdingType;
        }
        throw new IllegalArgumentException("Invalid holdingType code: " + by);
    }

    private HoldingType(byte by) {
        this.code = by;
    }

    public byte getCode() {
        return this.code;
    }

    public abstract int getDecimals(long var1);

    public abstract long getBalance(Account var1, long var2);

    public abstract long getUnconfirmedBalance(Account var1, long var2);

    public abstract void addToBalance(Account var1, AccountLedger.LedgerEvent var2, AccountLedger.LedgerEventId var3, long var4, long var6);

    public abstract void addToUnconfirmedBalance(Account var1, AccountLedger.LedgerEvent var2, AccountLedger.LedgerEventId var3, long var4, long var6);

    public abstract void addToBalanceAndUnconfirmedBalance(Account var1, AccountLedger.LedgerEvent var2, AccountLedger.LedgerEventId var3, long var4, long var6);
}

