/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.nio.ByteBuffer;
import java.util.Arrays;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Appendix;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class PublicKeyAnnouncementAppendix
extends Appendix.AbstractAppendix {
    public static final int appendixType = 32;
    public static final String appendixName = "PublicKeyAnnouncement";
    public static final Appendix.Parser appendixParser = new Appendix.Parser(){

        @Override
        public Appendix.AbstractAppendix parse(ByteBuffer byteBuffer) {
            return new PublicKeyAnnouncementAppendix(byteBuffer);
        }

        @Override
        public Appendix.AbstractAppendix parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(PublicKeyAnnouncementAppendix.appendixName, jSONObject)) {
                return null;
            }
            return new PublicKeyAnnouncementAppendix(jSONObject);
        }
    };
    private final byte[] publicKey;

    private PublicKeyAnnouncementAppendix(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.publicKey = new byte[32];
        byteBuffer.get(this.publicKey);
    }

    private PublicKeyAnnouncementAppendix(JSONObject jSONObject) {
        super(jSONObject);
        this.publicKey = Convert.parseHexString((String)jSONObject.get((Object)"recipientPublicKey"));
    }

    public PublicKeyAnnouncementAppendix(byte[] byArray) {
        this.publicKey = byArray;
    }

    @Override
    public int getAppendixType() {
        return 32;
    }

    @Override
    public String getAppendixName() {
        return appendixName;
    }

    @Override
    protected int getMySize() {
        return 32;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put(this.publicKey);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"recipientPublicKey", (Object)Convert.toHexString(this.publicKey));
    }

    @Override
    public void validate(Transaction transaction) throws NxtException.ValidationException {
        if (transaction.getRecipientId() == 0L) {
            throw new NxtException.NotValidException("PublicKeyAnnouncement cannot be attached to transactions with no recipient");
        }
        if (!Crypto.isCanonicalPublicKey(this.publicKey)) {
            throw new NxtException.NotValidException("Invalid recipient public key: " + Convert.toHexString(this.publicKey));
        }
        long l = transaction.getRecipientId();
        if (Account.getId(this.publicKey) != l) {
            throw new NxtException.NotValidException("Announced public key does not match recipient accountId");
        }
        byte[] byArray = Account.getPublicKey(l);
        if (byArray != null && !Arrays.equals(this.publicKey, byArray)) {
            throw new NxtException.NotCurrentlyValidException("A different public key for this account has already been announced");
        }
    }

    @Override
    public void apply(Transaction transaction, Account account, Account account2) {
        if (Account.setOrVerify(account2.getId(), this.publicKey)) {
            account2.apply(this.publicKey);
        }
    }

    @Override
    public boolean isPhasable() {
        return false;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Override
    public boolean isAllowed(Chain chain) {
        return chain instanceof ChildChain;
    }
}

