/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.util.Arrays;
import nxt.addons.AbstractContractContext;
import nxt.addons.ChainWrapper;
import nxt.addons.ContractRunnerConfig;
import nxt.addons.JO;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.TransactionType;
import nxt.http.responses.TransactionResponse;
import nxt.util.Convert;
import nxt.util.Logger;

public abstract class AbstractOperationContext
extends AbstractContractContext {
    protected final byte[] fullHash;
    protected final int chain;
    protected final long blockId;
    private JO runtimeParams;
    private final String seed;

    public AbstractOperationContext(byte[] byArray, int n, long l, ContractRunnerConfig contractRunnerConfig, JO jO, String string, String string2) {
        super(contractRunnerConfig, string);
        this.runtimeParams = jO;
        this.seed = string2;
        this.fullHash = byArray;
        this.chain = n;
        this.blockId = l;
    }

    protected abstract JO getTransactionJson();

    public abstract TransactionResponse getTransaction();

    @Override
    public JO getRuntimeParams() {
        return this.runtimeParams;
    }

    public long getAmountNQT() {
        return this.getTransaction().getAmount();
    }

    private long getEntityId(String string) {
        return this.getTransactionJson().getEntityId(string);
    }

    public long getSenderId() {
        return this.getEntityId("sender");
    }

    public long getRecipientId() {
        return this.getEntityId("recipient");
    }

    public ChainWrapper getChainOfTransaction() {
        return (ChainWrapper)chainById.get(this.getTransaction().getChainId());
    }

    @Deprecated
    public boolean isSameRecipient() {
        return this.validateSameAccount("recipient");
    }

    public boolean notSameRecipient() {
        return !this.validateSameAccount("recipient");
    }

    public boolean isSameSender() {
        return this.validateSameAccount("sender");
    }

    public boolean notSameSender() {
        return !this.isSameSender();
    }

    public boolean validateSameAccount(String string) {
        String string2 = this.getTransactionJson().getString(string);
        if (string2.equals(this.config.getAccount())) {
            return true;
        }
        this.generateInternalErrorResponse(1011, "Transaction %s %s differs from contract account %s", string, Convert.rsAccount(Long.parseUnsignedLong(string2)), this.config.getAccountRs());
        return false;
    }

    private boolean isExpectedTransactionType(TransactionType ... transactionTypeArray) {
        TransactionType transactionType = this.getTransaction().getTransactionType();
        for (TransactionType transactionType2 : transactionTypeArray) {
            if (!transactionType.equals(transactionType2)) continue;
            return true;
        }
        this.generateInternalErrorResponse(1012, "Transaction type %s differs from expected type %s", transactionType, Arrays.toString(transactionTypeArray));
        return false;
    }

    private boolean notExpectedTransactionType(TransactionType ... transactionTypeArray) {
        return !this.isExpectedTransactionType(transactionTypeArray);
    }

    public boolean notPaymentTransaction() {
        return this.notExpectedTransactionType(ChildTransactionType.findTransactionType((byte)0, (byte)0), FxtTransactionType.findTransactionType((byte)-2, (byte)0));
    }

    public boolean isSameChain(int n) {
        int n2 = this.getTransaction().getChainId();
        if (n2 == n) {
            return true;
        }
        this.generateInternalErrorResponse(1013, "Transaction chain %d differs from expected chain %d", n2, n);
        return false;
    }

    public boolean notSameChain(int n) {
        return !this.isSameChain(n);
    }

    public long getRandomSeed() {
        if (this.seed == null) {
            Logger.logWarningMessage("Transaction random seed not specified, seed is predictable");
            return this.getTransaction().getTransactionId();
        }
        byte[] byArray = Convert.parseHexString(this.seed);
        return Convert.bytesToLong(byArray);
    }

    @Override
    protected JO getPhasingAttachment() {
        if (!this.getTransaction().isPhased()) {
            return null;
        }
        return this.getTransaction().getAttachmentJson();
    }
}

