/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.Account;
import nxt.addons.AbstractContractContext;
import nxt.addons.AbstractOperationContext;
import nxt.addons.ActiveContractRunnerConfig;
import nxt.addons.AddOn;
import nxt.addons.BlockContext;
import nxt.addons.Contract;
import nxt.addons.ContractAndSetupParameters;
import nxt.addons.ContractLoader;
import nxt.addons.ContractProvider;
import nxt.addons.ContractRunnerAPIs;
import nxt.addons.ContractRunnerConfig;
import nxt.addons.ContractRunnerEncryptedConfig;
import nxt.addons.ContractRunnerPermission;
import nxt.addons.JO;
import nxt.addons.NullContractRunnerConfig;
import nxt.addons.RequestContext;
import nxt.addons.TransactionContext;
import nxt.addons.ValidateChain;
import nxt.addons.ValidateContractRunnerIsRecipient;
import nxt.addons.ValidateContractRunnerIsSender;
import nxt.addons.ValidateTransactionType;
import nxt.addons.VoucherContext;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildBlockFxtTransactionType;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionProcessor;
import nxt.blockchain.TransactionType;
import nxt.configuration.SubSystem;
import nxt.db.DbIterator;
import nxt.http.APICall;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.callers.ApproveTransactionCall;
import nxt.http.callers.BroadcastTransactionCall;
import nxt.http.callers.GetAllWaitingTransactionsCall;
import nxt.http.callers.GetUnconfirmedTransactionsCall;
import nxt.http.callers.SignTransactionCall;
import nxt.http.responses.TransactionResponse;
import nxt.lightcontracts.ContractReference;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.ResourceLookup;
import nxt.voting.PhasingAppendix;
import nxt.voting.PhasingPollHome;
import nxt.voting.VoteWeighting;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.json.simple.JSONStreamAware;

public final class ContractRunner
implements AddOn,
ContractProvider {
    private static final StatisticalSummary NULL_STATISTICAL_SUMMARY = new StatisticalSummary(){

        public double getMean() {
            return 0.0;
        }

        public double getVariance() {
            return 0.0;
        }

        public double getStandardDeviation() {
            return 0.0;
        }

        public double getMax() {
            return 0.0;
        }

        public double getMin() {
            return 0.0;
        }

        public long getN() {
            return 0L;
        }

        public double getSum() {
            return 0.0;
        }
    };
    static final String CONFIG_PROPERTY_PREFIX = "addon.contractRunner.";
    private static final String CONFIG_FILE_PROPERTY = "addon.contractRunner.configFile";
    private volatile ContractRunnerConfig config = new NullContractRunnerConfig("Not initialized");
    private Map<String, ContractAndSetupParameters> supportedContracts = new HashMap<String, ContractAndSetupParameters>();
    private Map<String, ContractReference> supportedContractReferences = new HashMap<String, ContractReference>();
    private Map<String, APIServlet.APIRequestHandler> apiRequests;
    private Map<String, ContractReference> addedContractReferences = new HashMap<String, ContractReference>();
    private Map<String, ContractReference> deletedContractReferences = new HashMap<String, ContractReference>();

    @Override
    public void init() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ContractRunnerPermission("init"));
        }
        this.apiRequests = new HashMap<String, APIServlet.APIRequestHandler>();
        this.apiRequests.put("getSupportedContracts", new ContractRunnerAPIs.GetSupportedContractsAPI(this, new APITag[]{APITag.ADDONS}));
        this.apiRequests.put("triggerContractByTransaction", new ContractRunnerAPIs.TriggerContractByTransactionAPI(this, new APITag[]{APITag.ADDONS}, "triggerFullHash", "apply", "validate", "adminPassword"));
        this.apiRequests.put("triggerContractByHeight", new ContractRunnerAPIs.TriggerContractByHeightAPI(this, new APITag[]{APITag.ADDONS}, "contractName", "height", "apply", "adminPassword"));
        this.apiRequests.put("triggerContractByRequest", new ContractRunnerAPIs.TriggerContractByRequestAPI(this, new APITag[]{APITag.ADDONS}, "contractName", "setupParams", "adminPassword"));
        this.apiRequests.put("triggerContractByVoucher", new ContractRunnerAPIs.TriggerContractByVoucherAPI(this, "voucher", new APITag[]{APITag.ADDONS}, "contractName"));
        this.apiRequests.put("uploadContractRunnerConfiguration", new ContractRunnerAPIs.UploadContractRunnerConfigurationAPI(this, "config", new APITag[]{APITag.ADDONS}, "adminPassword"));
        if (!Nxt.getServerStatus().isDatabaseReady() || !Nxt.isEnabled(SubSystem.ADDONS)) {
            return;
        }
        this.loadConfig(Nxt.getStringProperty(CONFIG_FILE_PROPERTY));
        ContractRunnerEncryptedConfig contractRunnerEncryptedConfig = new ContractRunnerEncryptedConfig(this);
        contractRunnerEncryptedConfig.init();
        this.apiRequests.putAll(contractRunnerEncryptedConfig.getAPIRequests());
        Nxt.getBlockchainProcessor().addListener(this::processBlock, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        Nxt.getTransactionProcessor().addListener(this::processConfirmed, TransactionProcessor.Event.ADDED_CONFIRMED_TRANSACTIONS);
        Nxt.getTransactionProcessor().addListener(this::processReleasedPhased, TransactionProcessor.Event.RELEASE_PHASED_TRANSACTION);
        ContractReference.addListener(this::contractAdded, ContractReference.Event.SET_CONTRACT_REFERENCE);
        ContractReference.addListener(this::contractDeleted, ContractReference.Event.DELETE_CONTRACT_REFERENCE);
        Logger.logInfoMessage("ContractRunner Started");
    }

    private void loadConfig(String string) {
        JO jO;
        if (string != null) {
            jO = AccessController.doPrivileged(() -> ResourceLookup.loadJsonResource(string));
            if (jO == null) {
                Logger.logInfoMessage("Cannot load contract runner config from " + string);
                jO = new JO();
            }
        } else {
            jO = new JO();
        }
        this.loadConfig(jO);
    }

    boolean loadConfig(JO jO) {
        ActiveContractRunnerConfig activeContractRunnerConfig = new ActiveContractRunnerConfig(this);
        try {
            activeContractRunnerConfig.init(jO);
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage("ContractRunner configuration loading error", throwable);
            this.config = new NullContractRunnerConfig("Not yet configured: " + throwable.getMessage());
            return false;
        }
        if (this.config.getAccountId() != 0L && this.config.getAccountId() != activeContractRunnerConfig.getAccountId()) {
            Logger.logErrorMessage("Cannot switch contract runner account from %s to %s during runtime", Convert.rsAccount(this.config.getAccountId()), Convert.rsAccount(activeContractRunnerConfig.getAccountId()));
            return false;
        }
        this.config = activeContractRunnerConfig;
        try (DbIterator<ContractReference> dbIterator = ContractReference.getContractReferences(this.config.getAccountId(), null, 0, Integer.MAX_VALUE);){
            while (dbIterator.hasNext()) {
                this.loadContract(dbIterator.next());
            }
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage("Error retrieving contract references for account " + this.config.getAccountRs(), throwable);
        }
        return true;
    }

    private void loadContract(ContractReference contractReference) {
        try {
            ContractLoader.loadContract(contractReference, this.supportedContracts, this.supportedContractReferences);
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage(String.format("Error loading contract %s", contractReference.getContractName()), throwable);
        }
    }

    JSONStreamAware parseConfig(Reader reader) {
        boolean bl = this.loadConfig(JO.parse(reader));
        JO jO = new JO();
        jO.put("configLoaded", (Object)bl);
        return jO.toJSONObject();
    }

    <T extends AbstractContractContext> JO process(ContractAndSetupParameters contractAndSetupParameters, T t, INVOCATION_TYPE iNVOCATION_TYPE) {
        if (Constants.isAutomatedTest) {
            return AccessController.doPrivileged(() -> this.processImpl(contractAndSetupParameters, t, iNVOCATION_TYPE));
        }
        return this.processImpl(contractAndSetupParameters, t, iNVOCATION_TYPE);
    }

    private <T extends AbstractContractContext> JO processImpl(ContractAndSetupParameters contractAndSetupParameters, T t, INVOCATION_TYPE iNVOCATION_TYPE) {
        Annotation[] annotationArray;
        Method method;
        Contract contract = contractAndSetupParameters.getContract();
        try {
            method = contract.getClass().getDeclaredMethod(iNVOCATION_TYPE.getMethodName(), iNVOCATION_TYPE.getContextClass());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        t.setContractSetupParameters(contractAndSetupParameters.getParams());
        if (iNVOCATION_TYPE == INVOCATION_TYPE.BLOCK || iNVOCATION_TYPE == INVOCATION_TYPE.REQUEST) {
            return this.invokeContract(contract, method, iNVOCATION_TYPE, t);
        }
        AbstractOperationContext abstractOperationContext = (AbstractOperationContext)t.getContext();
        for (Annotation annotation : annotationArray = method.getDeclaredAnnotations()) {
            boolean bl;
            boolean bl2;
            Annotation annotation2;
            if (annotation.annotationType().equals(ValidateContractRunnerIsRecipient.class)) {
                if (!abstractOperationContext.notSameRecipient()) continue;
                return t.generateErrorResponse(11001, "The trigger %s %s recipient %s differs from contract runner account %s", new Object[]{iNVOCATION_TYPE, Convert.toHexString(abstractOperationContext.getTransaction().getFullHash()), abstractOperationContext.getTransaction().getRecipientRs(), this.config.getAccountRs()});
            }
            if (annotation.annotationType().equals(ValidateContractRunnerIsSender.class)) {
                if (!abstractOperationContext.notSameSender()) continue;
                return t.generateErrorResponse(11004, "The trigger %s %s sender %s differs from contract runner account %s", new Object[]{iNVOCATION_TYPE, Convert.toHexString(abstractOperationContext.getTransaction().getFullHash()), abstractOperationContext.getTransaction().getSenderRs(), this.config.getAccountRs()});
            }
            if (annotation.annotationType().equals(ValidateChain.class)) {
                annotation2 = (ValidateChain)annotation;
                int n = abstractOperationContext.getTransaction().getChainId();
                bl2 = annotation2.accept().length == 0 || IntStream.of(annotation2.accept()).anyMatch(n2 -> n2 == n);
                boolean bl3 = bl = annotation2.reject().length != 0 && IntStream.of(annotation2.reject()).anyMatch(n2 -> n2 == n);
                if (bl2 && !bl) continue;
                return t.generateErrorResponse(11002, "The trigger %s %s chain %s is not accepted by contract type %s", new Object[]{iNVOCATION_TYPE, Convert.toHexString(abstractOperationContext.getTransaction().getFullHash()), n, contract.getClass().getName()});
            }
            if (!annotation.annotationType().equals(ValidateTransactionType.class)) continue;
            annotation2 = (ValidateTransactionType)annotation;
            TransactionType transactionType = abstractOperationContext.getTransaction().getTransactionType();
            bl2 = annotation2.accept().length == 0 || Arrays.stream(annotation2.accept()).anyMatch(transactionTypeEnum -> transactionTypeEnum.getTransactionType() == transactionType);
            boolean bl4 = bl = annotation2.reject().length != 0 && Arrays.stream(annotation2.reject()).anyMatch(transactionTypeEnum -> transactionTypeEnum.getTransactionType() == transactionType);
            if (bl2 && !bl) continue;
            return t.generateErrorResponse(11003, "The trigger %s %s is not an accepted transaction type of contract %s", new Object[]{iNVOCATION_TYPE, abstractOperationContext.getTransaction().getFullHash(), contract.getClass().getName()});
        }
        return this.invokeContract(contract, method, iNVOCATION_TYPE, t);
    }

    private <T extends AbstractContractContext> JO invokeContract(Contract contract, Method method, INVOCATION_TYPE iNVOCATION_TYPE, T t) {
        Logger.logInfoMessage("Invoking %s on contract %s", method.getName(), contract.getClass().getCanonicalName());
        long l = System.nanoTime();
        try {
            JO jO = (JO)method.invoke((Object)contract, t);
            long l2 = System.nanoTime() - l;
            iNVOCATION_TYPE.addMeasurementNormal(contract.getClass().getCanonicalName(), l2);
            return jO;
        }
        catch (Throwable throwable) {
            long l3 = System.nanoTime() - l;
            iNVOCATION_TYPE.addMeasurementErr(contract.getClass().getCanonicalName(), l3);
            Logger.logInfoMessage("Error running contract " + contract.getClass().getName(), throwable);
            return t.generateErrorResponse(11002, throwable.toString(), new Object[0]);
        }
    }

    private void processConfirmed(List<? extends Transaction> list) {
        if (this.isSuspendContractRunnerExecution()) {
            return;
        }
        for (Transaction transaction : list) {
            Object object;
            if (transaction.getType() == ChildBlockFxtTransactionType.INSTANCE) continue;
            if (transaction.isPhased() && !this.config.isValidator()) {
                object = ((ChildTransaction)transaction).getPhasing();
                if (((PhasingAppendix)object).getParams().getVoteWeighting().getVotingModel() != VoteWeighting.VotingModel.HASH) continue;
                if (((PhasingAppendix)object).getFinishHeight() < transaction.getHeight() + 200) {
                    Logger.logInfoMessage("ContractRunner won't process phased transaction %s, phasing finish height less than 200 blocks ahead", Convert.toHexString(transaction.getFullHash()));
                    continue;
                }
            }
            try {
                object = this.processTransaction(transaction, true, this.config.isValidator());
                if (object == null) continue;
                Logger.logInfoMessage("ContractRunner response: " + ((JO)object).toJSONString());
            }
            catch (Exception exception) {
                ChainTransactionId chainTransactionId = new ChainTransactionId(transaction.getChain().getId(), transaction.getFullHash());
                Logger.logErrorMessage("ContractRunner error for transaction " + chainTransactionId + ": " + exception.getMessage(), exception);
            }
        }
    }

    private void processReleasedPhased(List<? extends Transaction> list) {
        if (this.isSuspendContractRunnerExecution()) {
            return;
        }
        for (Transaction transaction : list) {
            PhasingAppendix phasingAppendix = ((ChildTransaction)transaction).getPhasing();
            if (phasingAppendix.getParams().getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.HASH) continue;
            try {
                JO jO = this.processTransaction(transaction, true, this.config.isValidator());
                if (jO == null) continue;
                Logger.logInfoMessage("ContractRunner response: " + jO.toJSONString());
            }
            catch (Exception exception) {
                ChainTransactionId chainTransactionId = new ChainTransactionId(transaction.getChain().getId(), transaction.getFullHash());
                Logger.logErrorMessage("ContractRunner error for phased transaction " + chainTransactionId + ": " + exception.getMessage(), exception);
            }
        }
    }

    private void contractAdded(ContractReference contractReference) {
        if (contractReference.getAccountId() == this.config.getAccountId()) {
            this.addedContractReferences.put(contractReference.getContractName(), contractReference);
        }
    }

    private void contractDeleted(ContractReference contractReference) {
        if (contractReference.getAccountId() == this.config.getAccountId()) {
            this.deletedContractReferences.put(contractReference.getContractName(), contractReference);
        }
    }

    private void processBlock(Block block) {
        try {
            this.addedContractReferences.forEach((string, contractReference) -> ContractLoader.loadContract(contractReference, this.supportedContracts, this.supportedContractReferences));
            this.deletedContractReferences.forEach((string, contractReference) -> {
                this.supportedContracts.remove(string);
                this.supportedContractReferences.remove(string);
            });
            this.addedContractReferences.clear();
            this.deletedContractReferences.clear();
            if (this.isSuspendContractRunnerExecution()) {
                return;
            }
            this.supportedContracts.keySet().forEach(string -> {
                try {
                    this.processBlockContract(block, (String)string, true, false, null);
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException("Contract " + string, throwable);
                }
            });
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage("ContractRunner error: " + throwable.getMessage(), throwable);
        }
    }

    JO processBlockContract(Block block, String string, boolean bl, boolean bl2, Transaction transaction) {
        ContractAndSetupParameters contractAndSetupParameters = this.supportedContracts.get(string);
        if (contractAndSetupParameters == null) {
            return this.generateErrorResponse(1003, "Contract is not supported %s", string);
        }
        BlockContext blockContext = new BlockContext(block, this.config, string);
        JO jO = this.process(contractAndSetupParameters, blockContext, INVOCATION_TYPE.BLOCK);
        if (jO == null) {
            return null;
        }
        Logger.logInfoMessage("ContractRunner processBlock at height " + block.getHeight() + " response: " + jO.toJSONString());
        if (!bl) {
            String string2 = "Contract simulator does not submit transactions";
            Logger.logInfoMessage(string2);
            jO.put("status", string2);
            return jO;
        }
        if (!jO.isExist("transactions")) {
            return null;
        }
        List<JO> list = jO.getJoList("transactions");
        if (!bl2) {
            return this.submitContractTransactions(contractAndSetupParameters.getContract(), list);
        }
        return this.approveTransaction(contractAndSetupParameters.getContract(), transaction, list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JO processTransaction(Transaction transaction, boolean bl, boolean bl2) {
        Object object;
        boolean bl3;
        Transaction transaction2;
        Logger.logInfoMessage(String.format("ContractRunner Process transaction %d:%s", transaction.getChain().getId(), Convert.toHexString(transaction.getFullHash())));
        JO jO = this.parsePrunableMessage(transaction);
        if (jO.get("errorDescription") != null) {
            return jO;
        }
        String string = jO.getString("contract");
        AbstractContractContext.EventSource eventSource = jO.isExist("source") ? AbstractContractContext.EventSource.valueOf(jO.getString("source")) : AbstractContractContext.EventSource.NONE;
        String string2 = jO.getString("seed");
        ChainTransactionId chainTransactionId = null;
        if (transaction instanceof ChildTransaction) {
            chainTransactionId = ((ChildTransaction)transaction).getReferencedTransactionId();
        }
        if (chainTransactionId != null && eventSource.isTransaction() && bl2) {
            transaction2 = Nxt.getBlockchain().getTransaction(chainTransactionId.getChain(), chainTransactionId.getFullHash());
            jO = this.parsePrunableMessage(transaction2);
            string = jO.get("contract") != null ? (String)jO.get("contract") : null;
            string2 = jO.get("seed") != null ? (String)jO.get("seed") : null;
            bl3 = true;
        } else if (eventSource.isTransaction() && bl2) {
            object = ChainTransactionId.fromStringId((String)jO.get("trigger"));
            if (object == null) {
                return this.generateErrorResponse(1000, "Cannot parse trigger transaction %s", jO.toJSONString());
            }
            transaction2 = Nxt.getBlockchain().getTransaction(((ChainTransactionId)object).getChain(), ((ChainTransactionId)object).getFullHash());
            jO = this.parsePrunableMessage(transaction2);
            string = jO.get("contract") != null ? (String)jO.get("contract") : null;
            bl3 = true;
        } else {
            if (eventSource.isBlock() && bl2) {
                int n;
                Object object2;
                if (transaction.isPhased()) {
                    object2 = PhasingPollHome.getResult(transaction);
                    if (object2 == null) return this.generateErrorResponse(1000, "Validation failed - phased transaction submitted by contract not executed yet %s", Convert.toHexString(transaction.getFullHash()));
                    if (!((PhasingPollHome.PhasingPollResult)object2).isApproved()) {
                        return this.generateErrorResponse(1000, "Validation failed - phased transaction submitted by contract wss not approved %s", Convert.toHexString(transaction.getFullHash()));
                    }
                    n = ((PhasingPollHome.PhasingPollResult)object2).getHeight();
                } else {
                    n = transaction.getECBlockHeight();
                }
                object2 = Nxt.getBlockchain().getBlockAtHeight(n);
                String string3 = string = jO.get("submittedBy") != null ? (String)jO.get("submittedBy") : null;
                if (string != null) return this.processBlockContract((Block)object2, string, true, true, transaction);
                return this.generateErrorResponse(1000, "Cannot trigger contract, contract id not specified %s", jO.toJSONString());
            }
            transaction2 = transaction;
            bl3 = false;
        }
        if (string == null) {
            return this.generateErrorResponse(1000, "ContractRunner trigger %s did not specify contract name", Convert.toHexString(transaction2.getFullHash()));
        }
        object = this.supportedContracts.get(string);
        if (object == null) {
            return this.generateErrorResponse(1000, "Contract %s is not supported", string);
        }
        JO jO2 = jO.get("params") != null ? new JO(jO.get("params")) : new JO();
        Logger.logInfoMessage(String.format("Executing contract name %s class %s", string, object.getClass().getCanonicalName()));
        TransactionContext transactionContext = new TransactionContext(transaction2, this.config, jO2, string, string2);
        JO jO3 = this.process((ContractAndSetupParameters)object, transactionContext, INVOCATION_TYPE.TRANSACTION);
        if (jO3 == null) {
            jO3 = new JO();
        }
        if (!bl) {
            String string4 = "Contract simulator does not submit transactions";
            Logger.logInfoMessage(string4);
            jO3.put("status", string4);
            return jO3;
        }
        if (!jO3.isExist("transactions")) {
            Logger.logInfoMessage("Contract %s did not submitted any transaction", string);
            return jO3;
        }
        List<JO> list = jO3.getJoList("transactions");
        if (list.size() > this.config.getMaxSubmittedTransactionsPerInvocation()) {
            Logger.logInfoMessage("Contract cannot submit more than %d transactions in a single invocation, it generated %d transactions, consider increasing maxSubmittedTransactionsPerInvocation", this.config.getMaxSubmittedTransactionsPerInvocation(), list.size());
            return jO3;
        }
        if (!bl3) {
            return this.submitContractTransactions(((ContractAndSetupParameters)object).getContract(), list);
        }
        jO3 = new JO(this.approveTransaction(((ContractAndSetupParameters)object).getContract(), transaction, list));
        jO3.put("status", "Approval transaction submitted");
        return jO3;
    }

    private JO approveTransaction(Contract contract, Transaction transaction, List<JO> list) {
        JO jO = new JO(JSONData.unconfirmedTransaction(transaction));
        TransactionResponse transactionResponse = TransactionResponse.create(jO);
        for (JO jO2 : list) {
            JO jO3 = jO2.getJo("transactionJSON");
            TransactionResponse transactionResponse2 = TransactionResponse.create(jO3);
            if (this.isDuplicate(contract, transactionResponse2)) continue;
            if (transactionResponse2.similar(transactionResponse)) {
                if (transaction.getChain() == FxtChain.FXT) {
                    return this.generateErrorResponse(1000, "Found a match but cannot submit approval to a parent chain transaction", new Object[0]);
                }
                String string = this.config.getValidatorSecretPhrase();
                if (string == null) {
                    return this.generateErrorResponse(1000, "Cannot approve transaction, validatorSecretPhrase not specified", new Object[0]);
                }
                jO = new JO(JSONData.unconfirmedTransaction(transaction));
                int n = (Integer)jO.get("chain");
                Object t = ((ApproveTransactionCall)ApproveTransactionCall.create(n).param("phasedTransaction", n + ":" + jO.getString("fullHash"))).secretPhrase(string);
                if (Chain.getChain(n) instanceof ChildChain) {
                    ((APICall.Builder)t).param("feeRateNQTPerFXT", this.config.getCurrentFeeRateNQTPerFXT(n));
                }
                return new JO(((APICall.Builder)t).build().invoke());
            }
            Logger.logInfoMessage("Transactions differ");
            Logger.logInfoMessage("Expected Transaction " + jO.toJSONString());
            Logger.logInfoMessage("Actual   Transaction " + jO3.toJSONString());
        }
        return this.generateErrorResponse(1000, "Cannot approve contract %s transaction %s chain %s", contract.getClass().getCanonicalName(), jO.get("fullHash"), jO.get("chain"));
    }

    JO submitContractTransactions(Contract contract, List<JO> list) {
        String string = this.config.getSecretPhrase();
        if (string == null) {
            return this.generateErrorResponse(1000, "Cannot submit transactions, contract runner secret phrase not specified", new Object[0]);
        }
        int n = 0;
        int n2 = 0;
        for (JO jO : list) {
            JO jO2;
            APICall aPICall;
            APICall.Builder builder;
            if (!jO.isExist("transactionJSON")) {
                Logger.logErrorMessage(String.format("Error %s %s in transaction submitted by contract", jO.get("errorCode"), jO.get("errorDescription")));
                ++n2;
                continue;
            }
            JO jO3 = jO.getJo("transactionJSON");
            if (this.isDuplicate(contract, TransactionResponse.create(jO3))) continue;
            if (!jO3.isExist("signature")) {
                builder = ((SignTransactionCall)SignTransactionCall.create().secretPhrase(string)).unsignedTransactionJSON(jO3.toJSONString()).validate(true);
                aPICall = builder.build();
                jO2 = new JO(aPICall.invoke());
                if (jO2.isExist("errorCode")) {
                    Logger.logErrorMessage(String.format("Error signing transaction %s chain %d message %s", jO3.getString("fullHash"), jO3.getLong("chain"), jO2.getString("errorDescription")));
                    ++n2;
                    continue;
                }
                jO3 = new JO(jO2.get("transactionJSON"));
            }
            if ((jO2 = new JO((aPICall = (builder = BroadcastTransactionCall.create().transactionJSON(jO3.toJSONString())).build()).invoke())).get("errorCode") != null) {
                Logger.logErrorMessage(String.format("Error broadcasting transaction %s chain %d message %s", jO3.getString("fullHash"), jO3.getLong("chain"), jO2.getString("errorDescription")));
                ++n2;
                continue;
            }
            ++n;
        }
        return this.generateInfoResponse("contract %s submitted %d transactions with %d errors", contract.getClass().getCanonicalName(), n, n2);
    }

    private boolean isDuplicate(Contract contract, TransactionResponse transactionResponse) {
        JO jO = GetUnconfirmedTransactionsCall.create(transactionResponse.getChainId()).account(transactionResponse.getSenderId()).call();
        JO jO2 = GetAllWaitingTransactionsCall.create().call();
        ArrayList<JO> arrayList = new ArrayList<JO>(jO.getJoList("unconfirmedTransactions"));
        arrayList.addAll(jO2.getJoList("transactions"));
        return contract.isDuplicate(transactionResponse, arrayList.stream().map(TransactionResponse::create).collect(Collectors.toList()));
    }

    private boolean isSuspendContractRunnerExecution() {
        if (this.config instanceof NullContractRunnerConfig) {
            return true;
        }
        if (FxtChain.FXT.getBalanceHome().getBalance(this.config.getAccountId()).getUnconfirmedBalance() < 1000000000L) {
            Logger.logErrorMessage(String.format("contract runner account %s must have enough %s to pay the unconfirmed pool deposit of %d FQT", Convert.rsAccount(this.config.getAccountId()), "ARDR", 1000000000L));
            return true;
        }
        return Nxt.getBlockchain().getLastBlockTimestamp() < Nxt.getEpochTime() - this.config.getCatchUpInterval();
    }

    JO generateErrorResponse(int n, String string, Object ... objectArray) {
        string = String.format(string, objectArray);
        Logger.logInfoMessage(string);
        JO jO = new JO();
        jO.put("errorCode", (Object)n);
        jO.put("errorDescription", string);
        return jO;
    }

    public JO generateInfoResponse(String string, Object ... objectArray) {
        string = String.format(string, objectArray);
        Logger.logInfoMessage(string, objectArray);
        JO jO = new JO();
        jO.put("info", string);
        return jO;
    }

    private JO parsePrunableMessage(Transaction transaction) {
        String string;
        PrunablePlainMessageAppendix prunablePlainMessageAppendix = transaction.getAppendages().stream().filter(appendix -> appendix instanceof PrunablePlainMessageAppendix).findFirst().orElse(null);
        PrunableEncryptedMessageAppendix prunableEncryptedMessageAppendix = transaction.getAppendages().stream().filter(appendix -> appendix instanceof PrunableEncryptedMessageAppendix).findFirst().orElse(null);
        if (prunablePlainMessageAppendix != null) {
            string = Convert.toString(prunablePlainMessageAppendix.getMessage(), prunablePlainMessageAppendix.isText());
        } else if (prunableEncryptedMessageAppendix != null) {
            if (transaction.getRecipientId() != this.config.getAccountId()) {
                return this.generateErrorResponse(1000, "Cannot decrypt attached message, contract account %s is not the recipient %s of attached message", this.config.getAccountRs(), Convert.rsAccount(transaction.getRecipientId()));
            }
            if (this.config.getSecretPhrase() == null) {
                return this.generateErrorResponse(1000, "Cannot decrypt attached message, contract runner secret phrase not specified for account %s", this.config.getAccountRs());
            }
            if (this.config.isValidator()) {
                return this.generateErrorResponse(1000, "Cannot decrypt attached message, validator cannot decrypt encrypted trigger message", new Object[0]);
            }
            string = Convert.toString(Account.decryptFrom(transaction.getSenderPublicKey(), prunableEncryptedMessageAppendix.getEncryptedData(), this.config.getSecretPhrase(), prunableEncryptedMessageAppendix.isCompressed()), prunableEncryptedMessageAppendix.isText());
        } else {
            return this.generateErrorResponse(1000, "Transaction %s of chain %s does not trigger a contract", Convert.toHexString(transaction.getFullHash()), transaction.getChain());
        }
        try {
            return JO.parse(string);
        }
        catch (Exception exception) {
            return this.generateErrorResponse(1000, "cannot parse attached message " + string + ", probably not a trigger transaction " + exception, new Object[0]);
        }
    }

    @Override
    public void shutdown() {
        Logger.logInfoMessage("ContractRunner shutdown");
    }

    public void reset() {
        this.supportedContracts.clear();
        this.supportedContractReferences.clear();
    }

    @Override
    public Map<String, APIServlet.APIRequestHandler> getAPIRequests() {
        return this.apiRequests;
    }

    @Override
    public ContractAndSetupParameters getContract(String string) {
        return this.supportedContracts.get(string);
    }

    ContractRunnerConfig getConfig() {
        return this.config;
    }

    Set<String> getSupportedContractNames() {
        return Collections.unmodifiableSet(this.supportedContracts.keySet());
    }

    ContractReference getSupportedContractReference(String string) {
        return this.supportedContractReferences.get(string);
    }

    public static enum INVOCATION_TYPE {
        TRANSACTION("processTransaction", TransactionContext.class),
        BLOCK("processBlock", BlockContext.class),
        REQUEST("processRequest", RequestContext.class),
        VOUCHER("processVoucher", VoucherContext.class);

        private final String methodName;
        private final Class contextClass;
        Map<String, SummaryStatistics> normalMeasurements = new HashMap<String, SummaryStatistics>();
        Map<String, SummaryStatistics> errorMeasurements = new HashMap<String, SummaryStatistics>();

        private INVOCATION_TYPE(String string2, Class clazz) {
            this.methodName = string2;
            this.contextClass = clazz;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class getContextClass() {
            return this.contextClass;
        }

        void addMeasurementErr(String string2, long l) {
            this.errorMeasurements.computeIfAbsent(string2, string -> new SummaryStatistics()).addValue((double)l);
        }

        void addMeasurementNormal(String string2, long l) {
            this.normalMeasurements.computeIfAbsent(string2, string -> new SummaryStatistics()).addValue((double)l);
        }

        public StatisticalSummary getStatErr(String string) {
            SummaryStatistics summaryStatistics = this.errorMeasurements.get(string);
            return summaryStatistics != null ? summaryStatistics : NULL_STATISTICAL_SUMMARY;
        }

        public StatisticalSummary getStatNormal(String string) {
            SummaryStatistics summaryStatistics = this.normalMeasurements.get(string);
            return summaryStatistics != null ? summaryStatistics : NULL_STATISTICAL_SUMMARY;
        }

        public static Optional<INVOCATION_TYPE> getByMethodName(String string) {
            return Arrays.stream(INVOCATION_TYPE.values()).filter(iNVOCATION_TYPE -> iNVOCATION_TYPE.getMethodName().equals(string)).findFirst();
        }
    }
}

