/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import nxt.addons.BlockchainEntity;
import nxt.addons.ContractInvocationParameter;
import nxt.addons.ContractRunnerParameter;
import nxt.addons.ContractSetupParameter;
import nxt.addons.JA;
import nxt.addons.JO;
import nxt.util.Logger;

class ParamInvocationHandler
implements InvocationHandler {
    private final Map<Class<? extends Annotation>, JO> annotationToParameters = new LinkedHashMap<Class<? extends Annotation>, JO>();

    ParamInvocationHandler(JO jO, JO jO2, JO jO3) {
        this.annotationToParameters.put(ContractInvocationParameter.class, jO3);
        this.annotationToParameters.put(ContractSetupParameter.class, jO2);
        this.annotationToParameters.put(ContractRunnerParameter.class, jO);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        return AccessController.doPrivileged(() -> {
            try {
                return this.getValueFromParameters(object, method, objectArray);
            }
            catch (ValueNotSet valueNotSet) {
                return this.getDefaultValue(object, method, objectArray);
            }
        });
    }

    private Object getDefaultValue(Object object, Method method, Object[] objectArray) throws ReflectiveOperationException {
        if (method.isDefault()) {
            Class<?> clazz = method.getDeclaringClass();
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            try {
                return ((MethodHandles.Lookup)constructor.newInstance(clazz)).in(clazz).unreflectSpecial(method, clazz).bindTo(object).invokeWithArguments(objectArray);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(throwable);
            }
        }
        return this.typeDefault(method.getReturnType());
    }

    private Object typeDefault(Class<?> clazz) {
        if (clazz.isAssignableFrom(Boolean.TYPE)) {
            return false;
        }
        if (clazz.isAssignableFrom(Integer.TYPE)) {
            return 0;
        }
        if (clazz.isAssignableFrom(Long.TYPE)) {
            return 0L;
        }
        return null;
    }

    private Object getValueFromParameters(Object object, Method method, Object[] objectArray) throws ValueNotSet {
        for (Class<? extends Annotation> clazz : this.annotationToParameters.keySet()) {
            String string;
            JO jO;
            if (method.getAnnotation(clazz) == null || !(jO = this.annotationToParameters.get(clazz)).containsKey(string = method.getName())) continue;
            Class<?> clazz2 = method.getReturnType();
            BiFunction<JO, String, Object> biFunction = this.getValueGetter(method, clazz2);
            if (biFunction == null) {
                Logger.logWarningMessage(String.format("Param %s of type %s is not of one of the supported parameter types", string, clazz2.getName()));
                break;
            }
            return biFunction.apply(jO, string);
        }
        throw new ValueNotSet();
    }

    private BiFunction<JO, String, Object> getValueGetter(Method method, Class<?> clazz) {
        if (clazz.isAssignableFrom(Boolean.TYPE)) {
            return JO::getBoolean;
        }
        if (clazz.isAssignableFrom(Integer.TYPE)) {
            return JO::getInt;
        }
        if (clazz.isAssignableFrom(Long.TYPE)) {
            if (method.getDeclaredAnnotation(BlockchainEntity.class) == null) {
                return JO::getLong;
            }
            return JO::getEntityId;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return JO::getString;
        }
        if (clazz.isAssignableFrom(JO.class)) {
            return JO::getJo;
        }
        if (clazz.isAssignableFrom(JA.class)) {
            return JO::getArray;
        }
        return null;
    }

    static <Params> Params getParams(Class<Params> clazz, JO jO, JO jO2, JO jO3) {
        return (Params)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ParamInvocationHandler(jO, jO2, jO3));
    }

    private static class ValueNotSet
    extends Exception {
        private ValueNotSet() {
        }
    }
}

