/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.util.Iterator;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.HoldingType;
import nxt.ae.Asset;
import nxt.ae.OrderHome;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.dbschema.Db;
import nxt.freeze.AbstractFreezeBlockHandler;
import nxt.freeze.FreezeMonitor;
import nxt.util.Listener;
import nxt.util.Logger;

public class AssetFreezeMonitor {
    private static final FreezeMonitor freezeMonitor = new FreezeMonitor(HoldingType.ASSET);

    public static void init() {
        Nxt.getBlockchainProcessor().addListener(new CancelOrdersBlockHandler(), BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        Asset.addListener(new AssetPropertyEventHandler(), Asset.Event.SET_PROPERTY);
    }

    static void checkLiquid(long l) throws NxtException.NotCurrentlyValidException {
        if (freezeMonitor.isFrozen(l)) {
            throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(l) + " is frozen, no transaction is possible.");
        }
    }

    public static void enableFreeze(long l, int n, int n2) {
        freezeMonitor.enableFreeze(l, n, n2);
    }

    private static class AssetPropertyEventHandler
    implements Listener<Asset.AssetProperty> {
        private AssetPropertyEventHandler() {
        }

        @Override
        public void notify(Asset.AssetProperty assetProperty) {
            int n;
            if (!"Freeze".equals(assetProperty.getProperty())) {
                return;
            }
            try {
                n = Integer.parseInt(assetProperty.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                Logger.logDebugMessage("Invalid height value", numberFormatException);
                return;
            }
            long l = assetProperty.getAssetId();
            Asset asset = Asset.getAsset(l);
            if (asset.getAccountId() != assetProperty.getSetterId()) {
                return;
            }
            freezeMonitor.scheduleFreeze(assetProperty.getAssetId(), n);
        }
    }

    private static class CancelOrdersBlockHandler
    extends AbstractFreezeBlockHandler {
        private CancelOrdersBlockHandler() {
            super(HoldingType.ASSET);
        }

        @Override
        protected void handleFreeze(long l) {
            for (ChildChain childChain : ChildChain.getAll()) {
                CancelOrdersBlockHandler.cancelOrders(childChain, l);
            }
        }

        private static void cancelOrders(ChildChain childChain, long l) {
            CancelOrdersBlockHandler.cancelOrders(childChain.getOrderHome(), l);
        }

        private static void cancelOrders(OrderHome orderHome, long l) {
            int n;
            try (DbIterator<OrderHome.Order> dbIterator = orderHome.getAskOrdersByAsset(l, 0, -1);){
                n = CancelOrdersBlockHandler.cancelOrders(dbIterator);
                Logger.logDebugMessage("Cancelled " + n + " ask orders for asset " + Long.toUnsignedString(l));
            }
            dbIterator = orderHome.getBidOrdersByAsset(l, 0, -1);
            var4_3 = null;
            try {
                n = CancelOrdersBlockHandler.cancelOrders(dbIterator);
                Logger.logDebugMessage("Cancelled " + n + " bid orders for asset " + Long.toUnsignedString(l));
            }
            catch (Throwable throwable) {
                var4_3 = throwable;
                throw throwable;
            }
            finally {
                if (dbIterator != null) {
                    if (var4_3 != null) {
                        try {
                            dbIterator.close();
                        }
                        catch (Throwable throwable) {
                            var4_3.addSuppressed(throwable);
                        }
                    } else {
                        dbIterator.close();
                    }
                }
            }
        }

        private static int cancelOrders(Iterator<? extends OrderHome.Order> iterator) {
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next().cancelOrder(null);
                if (++n % Constants.BATCH_COMMIT_SIZE != 0) continue;
                Db.db.commitTransaction();
            }
            return n;
        }
    }
}

