/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class OrderCancellationAttachment
extends Attachment.AbstractAttachment {
    private final long orderId;
    private final byte[] orderHash;

    OrderCancellationAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.orderHash = new byte[32];
        byteBuffer.get(this.orderHash);
        this.orderId = Convert.fullHashToId(this.orderHash);
    }

    OrderCancellationAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.orderHash = Convert.parseHexString((String)jSONObject.get((Object)"orderHash"));
        this.orderId = Convert.fullHashToId(this.orderHash);
    }

    OrderCancellationAttachment(byte[] byArray) {
        this.orderHash = byArray;
        this.orderId = Convert.fullHashToId(this.orderHash);
    }

    @Override
    protected int getMySize() {
        return 32;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put(this.orderHash);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"orderHash", (Object)Convert.toHexString(this.orderHash));
    }

    public byte[] getOrderHash() {
        return this.orderHash;
    }

    public long getOrderId() {
        return this.orderId;
    }
}

