/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class OrderPlacementAttachment
extends Attachment.AbstractAttachment {
    private final long assetId;
    private final long quantityQNT;
    private final long priceNQT;

    OrderPlacementAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.assetId = byteBuffer.getLong();
        this.quantityQNT = byteBuffer.getLong();
        this.priceNQT = byteBuffer.getLong();
    }

    OrderPlacementAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.assetId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"asset"));
        this.quantityQNT = Convert.parseLong(jSONObject.get((Object)"quantityQNT"));
        this.priceNQT = Convert.parseLong(jSONObject.get((Object)"priceNQTPerShare"));
    }

    OrderPlacementAttachment(long l, long l2, long l3) {
        this.assetId = l;
        this.quantityQNT = l2;
        this.priceNQT = l3;
    }

    @Override
    protected int getMySize() {
        return 24;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.assetId);
        byteBuffer.putLong(this.quantityQNT);
        byteBuffer.putLong(this.priceNQT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(this.assetId));
        jSONObject.put((Object)"quantityQNT", (Object)this.quantityQNT);
        jSONObject.put((Object)"priceNQTPerShare", (Object)this.priceNQT);
    }

    public long getAssetId() {
        return this.assetId;
    }

    public long getQuantityQNT() {
        return this.quantityQNT;
    }

    public long getPriceNQT() {
        return this.priceNQT;
    }
}

