/*
 * Decompiled with CFR 0.152.
 */
package nxt.aliases;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.aliases.AliasAssignmentAttachment;
import nxt.aliases.AliasTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class AliasBuyAttachment
extends Attachment.AbstractAttachment {
    private final String aliasName;

    AliasBuyAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.aliasName = AliasAssignmentAttachment.ALIAS_NAME_RW.readFromBuffer(byteBuffer);
    }

    AliasBuyAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.aliasName = Convert.nullToEmpty((String)jSONObject.get((Object)"alias"));
    }

    public AliasBuyAttachment(String string) {
        this.aliasName = string;
    }

    @Override
    public TransactionType getTransactionType() {
        return AliasTransactionType.ALIAS_BUY;
    }

    @Override
    protected int getMySize() {
        return AliasAssignmentAttachment.ALIAS_NAME_RW.getSize(this.aliasName);
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        AliasAssignmentAttachment.ALIAS_NAME_RW.writeToBuffer(this.aliasName, byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"alias", (Object)this.aliasName);
    }

    public String getAliasName() {
        return this.aliasName;
    }
}

