/*
 * Decompiled with CFR 0.152.
 */
package nxt.aliases;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.aliases.AliasAssignmentAttachment;
import nxt.aliases.AliasTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class AliasDeleteAttachment
extends Attachment.AbstractAttachment {
    private final String aliasName;

    AliasDeleteAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.aliasName = AliasAssignmentAttachment.ALIAS_NAME_RW.readFromBuffer(byteBuffer);
    }

    AliasDeleteAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.aliasName = Convert.nullToEmpty((String)jSONObject.get((Object)"alias"));
    }

    public AliasDeleteAttachment(String string) {
        this.aliasName = string;
    }

    @Override
    public TransactionType getTransactionType() {
        return AliasTransactionType.ALIAS_DELETE;
    }

    @Override
    protected int getMySize() {
        return AliasAssignmentAttachment.ALIAS_NAME_RW.getSize(this.aliasName);
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        AliasAssignmentAttachment.ALIAS_NAME_RW.writeToBuffer(this.aliasName, byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"alias", (Object)this.aliasName);
    }

    public String getAliasName() {
        return this.aliasName;
    }
}

