/*
 * Decompiled with CFR 0.152.
 */
package nxt.authentication;

import java.nio.ByteBuffer;
import nxt.Constants;
import nxt.authentication.SecurityToken;
import nxt.util.security.BlockchainPermission;

public abstract class SecurityTokenFactory {
    private static final SecurityTokenFactory securityTokenFactory;

    public static SecurityTokenFactory getSecurityTokenFactory() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("authentication"));
        }
        return securityTokenFactory;
    }

    public abstract SecurityToken getSecurityToken(byte[] var1);

    public abstract SecurityToken getSecurityToken(ByteBuffer var1);

    static {
        if (Constants.isPermissioned) {
            try {
                Class<?> clazz = Class.forName("com.jelurida.blockchain.authentication.BlockchainSecurityTokenFactory");
                securityTokenFactory = (SecurityTokenFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new ExceptionInInitializerError(reflectiveOperationException);
            }
        } else {
            securityTokenFactory = null;
        }
    }
}

