/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import org.json.simple.JSONObject;

public interface Appendix {
    public int getAppendixType();

    public int getSize();

    public int getFullSize();

    public void putBytes(ByteBuffer var1);

    public JSONObject getJSONObject();

    public byte getVersion();

    public int getBaselineFeeHeight();

    public Fee getBaselineFee(Transaction var1);

    public int getNextFeeHeight();

    public Fee getNextFee(Transaction var1);

    public Fee getFee(Transaction var1, int var2);

    public boolean isPhased(Transaction var1);

    public boolean isAllowed(Chain var1);

    public static boolean hasAppendix(String string, JSONObject jSONObject) {
        return jSONObject.get((Object)("version." + string)) != null;
    }

    public static abstract class AbstractAppendix
    implements Appendix {
        private final byte version;

        protected AbstractAppendix(JSONObject jSONObject) {
            this.version = ((Long)jSONObject.get((Object)("version." + this.getAppendixName()))).byteValue();
        }

        protected AbstractAppendix(ByteBuffer byteBuffer) {
            this.version = byteBuffer.get();
        }

        protected AbstractAppendix(int n) {
            this.version = (byte)n;
        }

        protected AbstractAppendix() {
            this.version = 1;
        }

        public abstract String getAppendixName();

        @Override
        public final int getSize() {
            return this.getMySize() + (this.version > 0 ? 1 : 0);
        }

        @Override
        public final int getFullSize() {
            if (this instanceof Prunable && ((Prunable)((Object)this)).hasPrunableData()) {
                return ((Prunable)((Object)this)).getMyFullSize() + 1;
            }
            return this.getSize();
        }

        protected abstract int getMySize();

        @Override
        public final void putBytes(ByteBuffer byteBuffer) {
            if (this.version > 0) {
                byteBuffer.put(this.version);
            }
            this.putMyBytes(byteBuffer);
        }

        protected abstract void putMyBytes(ByteBuffer var1);

        final void putPrunableBytes(ByteBuffer byteBuffer) {
            if (this instanceof Prunable && ((Prunable)((Object)this)).hasPrunableData()) {
                byteBuffer.put(this.version);
                ((Prunable)((Object)this)).putMyPrunableBytes(byteBuffer);
            } else {
                this.putBytes(byteBuffer);
            }
        }

        @Override
        public final JSONObject getJSONObject() {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)("version." + this.getAppendixName()), (Object)this.version);
            this.putMyJSON(jSONObject);
            return jSONObject;
        }

        protected abstract void putMyJSON(JSONObject var1);

        @Override
        public final byte getVersion() {
            return this.version;
        }

        public boolean verifyVersion() {
            return this.version == 1;
        }

        @Override
        public int getBaselineFeeHeight() {
            return 0;
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return Fee.NONE;
        }

        @Override
        public int getNextFeeHeight() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Fee getNextFee(Transaction transaction) {
            return this.getBaselineFee(transaction);
        }

        @Override
        public final Fee getFee(Transaction transaction, int n) {
            return n >= this.getNextFeeHeight() ? this.getNextFee(transaction) : this.getBaselineFee(transaction);
        }

        public abstract void validate(Transaction var1) throws NxtException.ValidationException;

        public void validateId(Transaction transaction) throws NxtException.ValidationException {
        }

        public void validateAtFinish(Transaction transaction) throws NxtException.ValidationException {
            if (!this.isPhased(transaction)) {
                return;
            }
            this.validate(transaction);
        }

        public abstract void apply(Transaction var1, Account var2, Account var3);

        public final void loadPrunable(Transaction transaction) {
            this.loadPrunable(transaction, false);
        }

        public void loadPrunable(Transaction transaction, boolean bl) {
        }

        public abstract boolean isPhasable();

        @Override
        public final boolean isPhased(Transaction transaction) {
            return this.isPhasable() && transaction instanceof ChildTransaction && ((ChildTransaction)transaction).getPhasing() != null;
        }
    }

    public static interface Parser {
        public AbstractAppendix parse(ByteBuffer var1) throws NxtException.NotValidException;

        public AbstractAppendix parse(JSONObject var1) throws NxtException.NotValidException;
    }

    public static interface Encryptable {
        public void encrypt(String var1);
    }

    public static interface Prunable {
        public byte[] getHash();

        public boolean hasPrunableData();

        public void restorePrunableData(Transaction var1, int var2, int var3);

        default public boolean shouldLoadPrunable(Transaction transaction, boolean bl) {
            return Nxt.getEpochTime() - transaction.getTimestamp() < (bl && Constants.INCLUDE_EXPIRED_PRUNABLE ? Constants.MAX_PRUNABLE_LIFETIME : Constants.MIN_PRUNABLE_LIFETIME);
        }

        public void putMyPrunableBytes(ByteBuffer var1);

        public int getMyFullSize();
    }
}

