/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import nxt.account.PublicKeyAnnouncementAppendix;
import nxt.blockchain.Appendix;
import nxt.blockchain.ChildBlockAttachment;
import nxt.messaging.EncryptToSelfMessageAppendix;
import nxt.messaging.EncryptedMessageAppendix;
import nxt.messaging.MessageAppendix;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.shuffling.ShufflingProcessingAttachment;
import nxt.taggeddata.TaggedDataAttachment;
import nxt.voting.PhasingAppendix;

public final class AppendixParsers {
    private static final SortedMap<Integer, Appendix.Parser> parsersMap;
    private static final List<Appendix.Parser> prunableParsers;

    public static Collection<Appendix.Parser> getParsers() {
        return parsersMap.values();
    }

    public static Appendix.Parser getParser(int n) {
        return (Appendix.Parser)parsersMap.get(n);
    }

    public static Collection<Appendix.Parser> getPrunableParsers() {
        return prunableParsers;
    }

    private AppendixParsers() {
    }

    static {
        Cloneable cloneable = new TreeMap<Integer, Appendix.Parser>();
        cloneable.put(1, MessageAppendix.appendixParser);
        cloneable.put(2, EncryptedMessageAppendix.appendixParser);
        cloneable.put(4, EncryptToSelfMessageAppendix.appendixParser);
        cloneable.put(8, PrunablePlainMessageAppendix.appendixParser);
        cloneable.put(16, PrunableEncryptedMessageAppendix.appendixParser);
        cloneable.put(32, PublicKeyAnnouncementAppendix.appendixParser);
        cloneable.put(64, PhasingAppendix.appendixParser);
        parsersMap = Collections.unmodifiableSortedMap(cloneable);
        cloneable = new ArrayList();
        cloneable.add(PrunablePlainMessageAppendix.appendixParser);
        cloneable.add(PrunableEncryptedMessageAppendix.appendixParser);
        cloneable.add(ShufflingProcessingAttachment.appendixParser);
        cloneable.add(TaggedDataAttachment.appendixParser);
        cloneable.add(ChildBlockAttachment.appendixParser);
        prunableParsers = Collections.unmodifiableList(cloneable);
    }
}

