/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nxt.Constants;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Block;
import nxt.blockchain.BlockDb;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.Generator;
import nxt.blockchain.TransactionHome;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public final class BlockImpl
implements Block {
    private final int version;
    private final int timestamp;
    private final long previousBlockId;
    private volatile byte[] generatorPublicKey;
    private final byte[] previousBlockHash;
    private final long totalFeeFQT;
    private final byte[] generationSignature;
    private final byte[] payloadHash;
    private volatile List<FxtTransactionImpl> blockTransactions;
    private byte[] blockSignature;
    private BigInteger cumulativeDifficulty = BigInteger.ZERO;
    private long baseTarget = Constants.INITIAL_BASE_TARGET;
    private volatile long nextBlockId;
    private int height = -1;
    private volatile long id;
    private volatile String stringId = null;
    private volatile long generatorId;
    private volatile byte[] bytes = null;
    private volatile boolean hasValidSignature = false;
    private static final BigInteger CUMULATIVE_DIFFICULTY_MULTIPLIER = Convert.two64.multiply(BigInteger.valueOf(60L));

    private BlockImpl(int n, int n2, long l, long l2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, List<FxtTransactionImpl> list) {
        this.version = n;
        this.timestamp = n2;
        this.previousBlockId = l;
        this.totalFeeFQT = l2;
        this.payloadHash = byArray;
        this.generatorPublicKey = byArray2;
        this.generationSignature = byArray3;
        this.blockSignature = byArray4;
        this.previousBlockHash = byArray5;
        if (list != null) {
            this.blockTransactions = Collections.unmodifiableList(list);
        }
    }

    BlockImpl(byte[] byArray) {
        this(-1, 0, 0L, 0L, new byte[32], new byte[32], byArray, new byte[64], new byte[32], Collections.emptyList());
        this.height = 0;
        if (Constants.isTestnet) {
            this.baseTarget = Constants.INITIAL_BASE_TARGET * 10L;
        }
    }

    BlockImpl(int n, int n2, long l, long l2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, List<FxtTransactionImpl> list, String string) {
        this(n, n2, l, l2, byArray, byArray2, byArray3, null, byArray4, list);
        this.blockSignature = Crypto.sign(this.bytes(), string);
        this.bytes = null;
    }

    BlockImpl(int n, int n2, long l, long l2, byte[] byArray, long l3, byte[] byArray2, byte[] byArray3, byte[] byArray4, BigInteger bigInteger, long l4, long l5, int n3, long l6, List<FxtTransactionImpl> list) {
        this(n, n2, l, l2, byArray, null, byArray2, byArray3, byArray4, list);
        this.cumulativeDifficulty = bigInteger;
        this.baseTarget = l4;
        this.nextBlockId = l5;
        this.height = n3;
        this.id = l6;
        this.generatorId = l3;
    }

    private BlockImpl(byte[] byArray, List<? extends FxtTransaction> list) throws NxtException.NotValidException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.version = byteBuffer.getInt();
        this.timestamp = byteBuffer.getInt();
        this.previousBlockId = byteBuffer.getLong();
        int n = byteBuffer.getInt();
        this.totalFeeFQT = byteBuffer.getLong();
        this.payloadHash = new byte[32];
        byteBuffer.get(this.payloadHash);
        this.generatorPublicKey = new byte[32];
        byteBuffer.get(this.generatorPublicKey);
        this.generationSignature = new byte[32];
        byteBuffer.get(this.generationSignature);
        this.previousBlockHash = new byte[32];
        byteBuffer.get(this.previousBlockHash);
        if (byteBuffer.remaining() >= 64) {
            this.blockSignature = new byte[64];
            byteBuffer.get(this.blockSignature);
        }
        if (n != list.size()) {
            throw new NxtException.NotValidException("Block transaction count " + n + " is incorrect");
        }
        ArrayList arrayList = new ArrayList(n);
        list.forEach(fxtTransaction -> arrayList.add((FxtTransactionImpl)fxtTransaction));
        this.blockTransactions = Collections.unmodifiableList(arrayList);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getPreviousBlockId() {
        return this.previousBlockId;
    }

    @Override
    public byte[] getGeneratorPublicKey() {
        if (this.generatorPublicKey == null) {
            this.generatorPublicKey = this.generatorId != 0L ? Account.getPublicKey(this.generatorId) : new byte[32];
        }
        return this.generatorPublicKey;
    }

    @Override
    public byte[] getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    @Override
    public long getTotalFeeFQT() {
        return this.totalFeeFQT;
    }

    @Override
    public byte[] getPayloadHash() {
        return this.payloadHash;
    }

    @Override
    public byte[] getGenerationSignature() {
        return this.generationSignature;
    }

    @Override
    public byte[] getBlockSignature() {
        return this.blockSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FxtTransactionImpl> getFxtTransactions() {
        if (this.blockTransactions == null) {
            BlockchainImpl.getInstance().writeLock();
            try {
                List<FxtTransactionImpl> list = Collections.unmodifiableList(TransactionHome.findBlockTransactions(this.getId()));
                for (FxtTransactionImpl fxtTransactionImpl : list) {
                    fxtTransactionImpl.setBlock(this);
                }
                this.blockTransactions = list;
            }
            finally {
                BlockchainImpl.getInstance().writeUnlock();
            }
        }
        return this.blockTransactions;
    }

    @Override
    public long getBaseTarget() {
        return this.baseTarget;
    }

    @Override
    public BigInteger getCumulativeDifficulty() {
        return this.cumulativeDifficulty;
    }

    @Override
    public long getNextBlockId() {
        return this.nextBlockId;
    }

    void setNextBlockId(long l) {
        this.nextBlockId = l;
    }

    @Override
    public int getHeight() {
        if (this.height == -1) {
            throw new IllegalStateException("Block height not yet set");
        }
        return this.height;
    }

    @Override
    public long getId() {
        if (this.id == 0L) {
            if (this.blockSignature == null) {
                throw new IllegalStateException("Block is not signed yet");
            }
            byte[] byArray = Crypto.sha256().digest(this.bytes());
            BigInteger bigInteger = new BigInteger(1, new byte[]{byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]});
            this.id = bigInteger.longValue();
            this.stringId = bigInteger.toString();
        }
        return this.id;
    }

    @Override
    public String getStringId() {
        if (this.stringId == null) {
            this.getId();
            if (this.stringId == null) {
                this.stringId = Long.toUnsignedString(this.id);
            }
        }
        return this.stringId;
    }

    @Override
    public long getGeneratorId() {
        if (this.generatorId == 0L && this.height != 0) {
            this.generatorId = Account.getId(this.getGeneratorPublicKey());
        }
        return this.generatorId;
    }

    public boolean equals(Object object) {
        return object instanceof BlockImpl && this.getId() == ((BlockImpl)object).getId();
    }

    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"version", (Object)this.version);
        jSONObject.put((Object)"timestamp", (Object)this.timestamp);
        jSONObject.put((Object)"previousBlock", (Object)Long.toUnsignedString(this.previousBlockId));
        jSONObject.put((Object)"totalFeeFQT", (Object)this.totalFeeFQT);
        jSONObject.put((Object)"payloadHash", (Object)Convert.toHexString(this.payloadHash));
        jSONObject.put((Object)"generatorPublicKey", (Object)Convert.toHexString(this.getGeneratorPublicKey()));
        jSONObject.put((Object)"generationSignature", (Object)Convert.toHexString(this.generationSignature));
        jSONObject.put((Object)"previousBlockHash", (Object)Convert.toHexString(this.previousBlockHash));
        jSONObject.put((Object)"blockSignature", (Object)Convert.toHexString(this.blockSignature));
        JSONArray jSONArray = new JSONArray();
        this.getFxtTransactions().forEach(fxtTransactionImpl -> jSONArray.add((Object)fxtTransactionImpl.getJSONObject()));
        jSONObject.put((Object)"transactions", (Object)jSONArray);
        return JSON.toJSONString((JSONAware)jSONObject);
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes(), this.bytes.length);
    }

    byte[] bytes() {
        if (this.bytes == null) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(156 + (this.blockSignature != null ? 64 : 0));
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(this.version);
            byteBuffer.putInt(this.timestamp);
            byteBuffer.putLong(this.previousBlockId);
            byteBuffer.putInt(this.getFxtTransactions().size());
            byteBuffer.putLong(this.totalFeeFQT);
            byteBuffer.put(this.payloadHash);
            byteBuffer.put(this.getGeneratorPublicKey());
            byteBuffer.put(this.generationSignature);
            byteBuffer.put(this.previousBlockHash);
            if (this.blockSignature != null) {
                byteBuffer.put(this.blockSignature);
            }
            this.bytes = byteBuffer.array();
        }
        return this.bytes;
    }

    public static BlockImpl parseBlock(byte[] byArray, List<? extends FxtTransaction> list) throws NxtException.NotValidException {
        BlockImpl blockImpl = new BlockImpl(byArray, list);
        if (!blockImpl.checkSignature()) {
            throw new NxtException.NotValidException("Invalid block signature");
        }
        return blockImpl;
    }

    boolean verifyBlockSignature() {
        return this.checkSignature() && Account.setOrVerify(this.getGeneratorId(), this.getGeneratorPublicKey());
    }

    private boolean checkSignature() {
        if (!this.hasValidSignature) {
            byte[] byArray = Arrays.copyOf(this.bytes(), this.bytes.length - 64);
            this.hasValidSignature = this.blockSignature != null && Crypto.verify(this.blockSignature, byArray, this.getGeneratorPublicKey());
        }
        return this.hasValidSignature;
    }

    boolean verifyGenerationSignature() throws BlockchainProcessor.BlockOutOfOrderException {
        try {
            long l;
            BlockImpl blockImpl = BlockchainImpl.getInstance().getBlock(this.getPreviousBlockId());
            if (blockImpl == null) {
                throw new BlockchainProcessor.BlockOutOfOrderException("Can't verify signature because previous block is missing", this);
            }
            Account account = Account.getAccount(this.getGeneratorId());
            long l2 = l = account == null ? 0L : account.getEffectiveBalanceFXT();
            if (l <= 0L) {
                return false;
            }
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update(blockImpl.generationSignature);
            byte[] byArray = messageDigest.digest(this.getGeneratorPublicKey());
            if (!Arrays.equals(this.generationSignature, byArray)) {
                return false;
            }
            BigInteger bigInteger = new BigInteger(1, new byte[]{byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]});
            return Generator.verifyHit(bigInteger, BigInteger.valueOf(l), blockImpl, this.timestamp);
        }
        catch (RuntimeException runtimeException) {
            Logger.logMessage("Error verifying block generation signature", runtimeException);
            return false;
        }
    }

    void apply() {
        Account account = Account.addOrGetAccount(this.getGeneratorId());
        account.apply(this.getGeneratorPublicKey());
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(this);
        long l = 0L;
        if (this.height > 3) {
            long[] lArray = new long[3];
            for (FxtTransactionImpl object : this.getFxtTransactions()) {
                long[] lArray2 = object.getBackFees();
                for (int i = 0; i < lArray2.length; ++i) {
                    int n = i;
                    lArray[n] = lArray[n] + lArray2[i];
                }
            }
            for (int i = 0; i < lArray.length && lArray[i] != 0L; ++i) {
                l += lArray[i];
                Account account2 = Account.getAccount(BlockDb.findBlockAtHeight(this.height - i - 1).getGeneratorId());
                account2.addToBalanceAndUnconfirmedBalance(FxtChain.FXT, AccountLedger.LedgerEvent.BLOCK_GENERATED, ledgerEventId, lArray[i]);
                account2.addToForgedBalanceFQT(lArray[i]);
            }
        }
        account.addToBalanceAndUnconfirmedBalance(FxtChain.FXT, AccountLedger.LedgerEvent.BLOCK_GENERATED, ledgerEventId, this.totalFeeFQT - l);
        account.addToForgedBalanceFQT(this.totalFeeFQT - l);
    }

    void setPrevious(BlockImpl blockImpl) {
        if (blockImpl != null) {
            if (blockImpl.getId() != this.getPreviousBlockId()) {
                throw new IllegalStateException("Previous block id doesn't match");
            }
            this.height = blockImpl.getHeight() + 1;
            this.calculateBaseTarget(blockImpl);
        } else {
            this.height = 0;
        }
        int n = 0;
        for (FxtTransactionImpl fxtTransactionImpl : this.getFxtTransactions()) {
            int n2 = n;
            n = (short)(n + 1);
            fxtTransactionImpl.setIndex(n2);
            fxtTransactionImpl.setBlock(this);
            n = (short)(n + fxtTransactionImpl.getChildTransactions().size());
        }
    }

    void loadTransactions() {
        for (FxtTransactionImpl fxtTransactionImpl : this.getFxtTransactions()) {
            fxtTransactionImpl.bytes();
            fxtTransactionImpl.getAppendages();
            fxtTransactionImpl.getChildTransactions().forEach(childTransactionImpl -> {
                childTransactionImpl.bytes();
                childTransactionImpl.getAppendages();
            });
        }
    }

    private void calculateBaseTarget(BlockImpl blockImpl) {
        long l = blockImpl.baseTarget;
        this.cumulativeDifficulty = blockImpl.cumulativeDifficulty.add(CUMULATIVE_DIFFICULTY_MULTIPLIER.divide(BigInteger.valueOf(l).multiply(BigInteger.valueOf(this.timestamp - blockImpl.timestamp))));
        int n = blockImpl.height;
        if (n > 2 && n % 2 == 0) {
            int n2 = Constants.isTestnet ? (this.height > Constants.MPG_BLOCK ? 6 : 1) : 1;
            int n3 = 60 / n2;
            BlockImpl blockImpl2 = BlockDb.findBlockAtHeight(n - 2);
            int n4 = (this.timestamp - blockImpl2.timestamp) / 3;
            this.baseTarget = n4 > n3 ? l * (long)Math.min(n4, n3 + 7) / (long)n3 : l - l * 64L * (long)(n3 - Math.max(n4, n3 - 7)) / (long)(100 * n3);
            if (this.baseTarget < 0L || this.baseTarget > Constants.MAX_BASE_TARGET * (long)n2) {
                this.baseTarget = Constants.MAX_BASE_TARGET * (long)n2;
            }
            if (this.baseTarget < Constants.MIN_BASE_TARGET * (long)n2) {
                this.baseTarget = Constants.MIN_BASE_TARGET * (long)n2;
            }
        } else {
            this.baseTarget = l;
        }
    }
}

