/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.ChildBlockAttachment;
import nxt.blockchain.ChildBlockFxtTransaction;
import nxt.blockchain.ChildBlockFxtTransactionImpl;
import nxt.blockchain.ChildBlockFxtTransactionType;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionProcessor;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.blockchain.TransactionType;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.crypto.Crypto;
import nxt.db.DbIterator;
import nxt.db.FilteringIterator;
import nxt.peer.BundlerRate;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;

public final class Bundler {
    private static final short defaultChildBlockDeadline = (short)Nxt.getIntProperty("nxt.defaultChildBlockDeadline");
    private static final Filter bundlingFilter;
    private static final Map<String, Filter> availableBundlingFilters;
    private static final Map<String, FeeCalculator> availableFeeCalculators;
    private static final Map<ChildChain, Map<Long, Bundler>> bundlers;
    private static final TransactionProcessorImpl transactionProcessor;
    private final ChildChain childChain;
    private final String secretPhrase;
    private final byte[] publicKey;
    private final long accountId;
    private final long totalFeesLimitFQT;
    private final List<Rule> bundlingRules;
    private volatile long currentTotalFeesFQT;

    public static Bundler getBundler(ChildChain childChain, long l) {
        Map<Long, Bundler> map;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        return (map = bundlers.get(childChain)) == null ? null : map.get(l);
    }

    public static Filter createBundlingFilter(String string, String string2) {
        Filter filter;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        if (bundlingFilter != null) {
            if (string != null && !string.equals(bundlingFilter.getName())) {
                throw new IllegalArgumentException("The enforced bundling filter is " + bundlingFilter.getName() + ". Either use this filter, or change the nxt.bundlingFilter property");
            }
            filter = bundlingFilter;
        } else {
            filter = availableBundlingFilters.get(string);
            if (filter == null) {
                throw new IllegalArgumentException("Unknown filter " + string);
            }
        }
        try {
            filter = (Filter)filter.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Logger.logErrorMessage(reflectiveOperationException.getMessage(), reflectiveOperationException);
            throw new RuntimeException(reflectiveOperationException);
        }
        filter.setParameter(string2);
        return filter;
    }

    public static Rule createBundlingRule(long l, long l2, String string, List<Filter> list) {
        FeeCalculator feeCalculator;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        if (string == null || string.isEmpty()) {
            string = "MIN_FEE";
        }
        if (bundlingFilter != null) {
            if (list.isEmpty()) {
                list = Collections.singletonList(bundlingFilter);
            } else if (list.size() != 1 || !list.get(0).getClass().equals(bundlingFilter.getClass())) {
                throw new IllegalArgumentException("The enforced bundling filter is " + bundlingFilter.getName() + ". Either use this filter, or change the nxt.bundlingFilter property");
            }
        }
        if ((feeCalculator = availableFeeCalculators.get(string)) == null) {
            throw new IllegalArgumentException("Unknown fee calculator " + string);
        }
        Rule rule = new Rule(l, l2, feeCalculator, list);
        feeCalculator.validateRule(rule);
        return rule;
    }

    public static synchronized Bundler addOrChangeBundler(ChildChain childChain, String string, long l, List<Rule> list) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        Bundler bundler = new Bundler(childChain, string, l, list);
        bundler.runBundling();
        return bundler;
    }

    public static synchronized Bundler addBundlingRule(ChildChain childChain, String string, Rule rule) {
        long l;
        Bundler bundler;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        if ((bundler = Bundler.getBundler(childChain, l = Account.getId(Crypto.getPublicKey(string)))) != null) {
            bundler.bundlingRules.add(rule);
            bundler.runBundling();
            return bundler;
        }
        return null;
    }

    public static List<Bundler> getAllBundlers() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        ArrayList<Bundler> arrayList = new ArrayList<Bundler>();
        bundlers.values().forEach(map -> arrayList.addAll(map.values()));
        return arrayList;
    }

    public static List<Bundler> getChildChainBundlers(ChildChain childChain) {
        Map<Long, Bundler> map;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        return (map = bundlers.get(childChain)) == null ? Collections.emptyList() : new ArrayList<Bundler>(map.values());
    }

    public static List<Bundler> getAccountBundlers(long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        ArrayList<Bundler> arrayList = new ArrayList<Bundler>();
        bundlers.values().forEach(map -> {
            Bundler bundler = (Bundler)map.get(l);
            if (bundler != null) {
                arrayList.add(bundler);
            }
        });
        return arrayList;
    }

    public static List<BundlerRate> getBundlerRates() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        if (bundlingFilter != null) {
            return Collections.emptyList();
        }
        ArrayList<BundlerRate> arrayList = new ArrayList<BundlerRate>();
        Bundler.getAllBundlers().forEach(bundler -> {
            BundlerRate bundlerRate = bundler.getBundlerRate();
            if (bundlerRate != null) {
                arrayList.add(bundlerRate);
            }
        });
        return arrayList;
    }

    public static Bundler stopBundler(ChildChain childChain, long l) {
        Map<Long, Bundler> map;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        return (map = bundlers.get(childChain)) == null ? null : map.remove(l);
    }

    public static void stopAccountBundlers(long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        bundlers.values().forEach(map -> {
            Bundler cfr_ignored_0 = (Bundler)map.remove(l);
        });
    }

    public static void stopChildChainBundlers(ChildChain childChain) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        bundlers.remove(childChain);
    }

    public static void stopAllBundlers() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        bundlers.clear();
    }

    public static Collection<Filter> getAvailableFilters() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        return Collections.unmodifiableCollection(availableBundlingFilters.values());
    }

    public static Collection<FeeCalculator> getAvailableFeeCalculators() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("bundling"));
        }
        return Collections.unmodifiableCollection(availableFeeCalculators.values());
    }

    public static void init() {
    }

    private Bundler(ChildChain childChain2, String string, long l, List<Rule> list) {
        this.childChain = childChain2;
        this.secretPhrase = string;
        this.publicKey = Crypto.getPublicKey(string);
        this.accountId = Account.getId(this.publicKey);
        this.totalFeesLimitFQT = l;
        this.bundlingRules = new ArrayList<Rule>(list);
        Map map = bundlers.computeIfAbsent(childChain2, childChain -> new ConcurrentHashMap());
        map.put(this.accountId, this);
    }

    public final ChildChain getChildChain() {
        return this.childChain;
    }

    public final byte[] getPublicKey() {
        return this.publicKey;
    }

    public final long getAccountId() {
        return this.accountId;
    }

    public final long getTotalFeesLimitFQT() {
        return this.totalFeesLimitFQT;
    }

    public final long getCurrentTotalFeesFQT() {
        return this.currentTotalFeesFQT;
    }

    public List<Rule> getBundlingRules() {
        return Collections.unmodifiableList(this.bundlingRules);
    }

    public final BundlerRate getBundlerRate() {
        long l = Long.MAX_VALUE;
        for (Rule rule : this.bundlingRules) {
            if (!rule.filters.isEmpty()) continue;
            l = Math.min(l, rule.minRateNQTPerFXT);
        }
        if (l != Long.MAX_VALUE) {
            return new BundlerRate(this.childChain, l, this.totalFeesLimitFQT != 0L ? this.totalFeesLimitFQT - this.currentTotalFeesFQT : Long.MAX_VALUE, this.secretPhrase);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBundling() {
        BlockchainImpl.getInstance().writeLock();
        try {
            int n = Nxt.getEpochTime();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            LinkedList<ChildTransactionImpl> linkedList = new LinkedList<ChildTransactionImpl>();
            FilteringIterator<UnconfirmedTransaction> filteringIterator = new FilteringIterator<UnconfirmedTransaction>(TransactionProcessorImpl.getInstance().getUnconfirmedChildTransactions(this.childChain), unconfirmedTransaction -> unconfirmedTransaction.getTransaction().hasAllReferencedTransactions(unconfirmedTransaction.getTimestamp(), 0));
            Serializable serializable = null;
            try {
                for (UnconfirmedTransaction unconfirmedTransaction2 : filteringIterator) {
                    ChildTransactionImpl childTransactionImpl = (ChildTransactionImpl)unconfirmedTransaction2.getTransaction();
                    if (childTransactionImpl.getExpiration() < n + 60 * defaultChildBlockDeadline || childTransactionImpl.getTimestamp() > n) continue;
                    linkedList.add(childTransactionImpl);
                }
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (filteringIterator != null) {
                    if (serializable != null) {
                        try {
                            filteringIterator.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        filteringIterator.close();
                    }
                }
            }
            boolean bl = true;
            while (bl && !linkedList.isEmpty()) {
                bl = false;
                serializable = new ArrayList();
                long l = 0L;
                int n2 = 0;
                HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
                block17: for (Rule rule : this.bundlingRules) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        ChildTransactionImpl childTransactionImpl = (ChildTransactionImpl)iterator.next();
                        int n3 = childTransactionImpl.getFullSize();
                        if (n2 + n3 > 131072 || !rule.isTransactionAccepted(this, childTransactionImpl)) continue;
                        long l2 = rule.calculateFeeFQT(childTransactionImpl);
                        if (Math.addExact(this.currentTotalFeesFQT, Math.addExact(l, l2)) > this.totalFeesLimitFQT && this.totalFeesLimitFQT > 0L) {
                            Logger.logDebugMessage("Bundler " + Long.toUnsignedString(this.accountId) + " will exceed total fees limit, not bundling");
                            continue;
                        }
                        if (childTransactionImpl.attachmentIsDuplicate(hashMap, true)) continue;
                        iterator.remove();
                        serializable.add(childTransactionImpl);
                        l = Math.addExact(l, l2);
                        if (serializable.size() < 100 && (n2 += n3) < 131072) continue;
                        bl = true;
                        break block17;
                    }
                }
                if (serializable.size() <= 0) continue;
                if (l > FxtChain.FXT.getBalanceHome().getBalance(this.accountId).getUnconfirmedBalance()) {
                    Logger.logInfoMessage("Bundler account " + Long.toUnsignedString(this.accountId) + " does not have sufficient balance to cover total Ardor fees " + l);
                    continue;
                }
                if (this.hasBetterChildBlockFxtTransaction((List<ChildTransaction>)((Object)serializable), l)) continue;
                try {
                    ChildBlockFxtTransaction childBlockFxtTransaction2 = this.bundle((List<ChildTransaction>)((Object)serializable), l, n);
                    this.currentTotalFeesFQT += l;
                    arrayList.add(childBlockFxtTransaction2);
                }
                catch (NxtException.NotCurrentlyValidException notCurrentlyValidException) {
                    Logger.logDebugMessage(notCurrentlyValidException.getMessage(), notCurrentlyValidException);
                }
                catch (NxtException.ValidationException validationException) {
                    Logger.logInfoMessage(validationException.getMessage(), validationException);
                }
            }
            arrayList.forEach(childBlockFxtTransaction -> {
                try {
                    transactionProcessor.broadcast((Transaction)childBlockFxtTransaction);
                }
                catch (NxtException.ValidationException validationException) {
                    Logger.logErrorMessage(validationException.getMessage(), validationException);
                }
            });
        }
        finally {
            BlockchainImpl.getInstance().writeUnlock();
        }
    }

    private ChildBlockFxtTransaction bundle(List<ChildTransaction> list, long l, int n) throws NxtException.ValidationException {
        FxtTransactionImpl.BuilderImpl builderImpl = FxtChain.FXT.newTransactionBuilder(this.publicKey, 0L, l, defaultChildBlockDeadline, new ChildBlockAttachment(list));
        builderImpl.timestamp(n);
        ChildBlockFxtTransaction childBlockFxtTransaction = (ChildBlockFxtTransaction)builderImpl.build(this.secretPhrase);
        childBlockFxtTransaction.validate();
        return childBlockFxtTransaction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasBetterChildBlockFxtTransaction(List<ChildTransaction> list, long l) {
        try (DbIterator<UnconfirmedTransaction> dbIterator = transactionProcessor.getUnconfirmedFxtTransactions();){
            block19: {
                while (dbIterator.hasNext()) {
                    FxtTransaction fxtTransaction = (FxtTransaction)((Object)dbIterator.next().getTransaction());
                    if (fxtTransaction.getType() != ChildBlockFxtTransactionType.INSTANCE || ((ChildBlockFxtTransaction)fxtTransaction).getChildChain() != this.childChain || fxtTransaction.getFee() < l) continue;
                    try {
                        fxtTransaction.validate();
                    }
                    catch (NxtException.ValidationException validationException) {
                        continue;
                    }
                    if (!((ChildBlockFxtTransactionImpl)fxtTransaction).containsAll(list)) {
                        continue;
                    }
                    break block19;
                }
                return false;
            }
            boolean bl = true;
            return bl;
        }
    }

    static {
        String string = Nxt.getStringProperty("nxt.bundlingFilter");
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (string != null) {
                bundlingFilter = Class.forName(string).asSubclass(Filter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                availableBundlingFilters = Collections.singletonMap(bundlingFilter.getName(), bundlingFilter);
                Logger.logInfoMessage("Enforced " + bundlingFilter.getName() + " bundling filter to all rules");
            } else {
                bundlingFilter = null;
                object5 = Nxt.getStringListProperty("nxt.availableBundlingFilters");
                object4 = new LinkedHashMap(object5.size());
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    object = Class.forName((String)object2).asSubclass(Filter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Filter filter = object4.put(object.getName(), object);
                    if (filter == null) continue;
                    RuntimeException runtimeException = new RuntimeException("Bundling filters " + filter.getClass() + " and " + object.getClass() + " have equal names");
                    Logger.logErrorMessage(runtimeException.getMessage());
                    throw runtimeException;
                }
                availableBundlingFilters = Collections.unmodifiableMap(object4);
            }
            object5 = new LinkedHashMap();
            object4 = new MinFeeCalculator();
            object5.put(object4.getName(), object4);
            object4 = new ProportionalFeeCalculator();
            object5.put(object4.getName(), object4);
            object3 = Nxt.getStringListProperty("nxt.customBundlingFeeCalculators");
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                object4 = Class.forName((String)object).asSubclass(FeeCalculator.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                object5.put(object4.getName(), object4);
            }
            availableFeeCalculators = Collections.unmodifiableMap(object5);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Logger.logErrorMessage(reflectiveOperationException.getMessage(), reflectiveOperationException);
            throw new RuntimeException(reflectiveOperationException);
        }
        bundlers = new ConcurrentHashMap<ChildChain, Map<Long, Bundler>>();
        transactionProcessor = TransactionProcessorImpl.getInstance();
        transactionProcessor.addListener(list -> bundlers.values().forEach(map -> map.values().forEach(bundler -> {
            boolean bl = false;
            for (Transaction transaction : list) {
                if (transaction.getChain() != bundler.childChain) continue;
                bl = true;
                break;
            }
            if (bl) {
                bundler.runBundling();
            }
        })), TransactionProcessor.Event.ADDED_UNCONFIRMED_TRANSACTIONS);
    }

    public static class Rule {
        protected final FeeCalculator feeCalculator;
        protected final List<Filter> filters;
        protected final long minRateNQTPerFXT;
        protected final BigInteger minRateNQTPerFXTBigInteger;
        protected final long overpayFQTPerFXT;
        protected final BigInteger overpayFQTPerFXTBigInteger;

        private Rule(long l, long l2, FeeCalculator feeCalculator, List<Filter> list) {
            this.minRateNQTPerFXT = l;
            this.minRateNQTPerFXTBigInteger = BigInteger.valueOf(this.minRateNQTPerFXT);
            this.overpayFQTPerFXT = l2;
            this.overpayFQTPerFXTBigInteger = BigInteger.valueOf(this.overpayFQTPerFXT);
            this.feeCalculator = feeCalculator;
            this.filters = list;
        }

        protected long calculateFeeFQT(ChildTransactionImpl childTransactionImpl) {
            return this.feeCalculator.calculateFeeFQT(childTransactionImpl, this);
        }

        public final long getMinRateNQTPerFXT() {
            return this.minRateNQTPerFXT;
        }

        public final long getOverpayFQTPerFXT() {
            return this.overpayFQTPerFXT;
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public FeeCalculator getFeeCalculator() {
            return this.feeCalculator;
        }

        protected boolean isTransactionAccepted(Bundler bundler, ChildTransactionImpl childTransactionImpl) {
            int n = Nxt.getBlockchain().getHeight();
            long l = childTransactionImpl.getMinimumFeeFQT(n);
            long l2 = childTransactionImpl.getFee();
            BigInteger bigInteger = this.minRateNQTPerFXTBigInteger.multiply(BigInteger.valueOf(l));
            if (BigInteger.valueOf(l2).multiply(Constants.ONE_FXT_BIG_INTEGER).compareTo(bigInteger) < 0) {
                Logger.logInfoMessage("Bundler not bundling child transaction %d:%s fee %d [FQT] lower than min required fee %d [FQT]", childTransactionImpl.getChain().getId(), Convert.toHexString(childTransactionImpl.getFullHash()), BigInteger.valueOf(l2), bigInteger.divide(Constants.ONE_FXT_BIG_INTEGER));
                return false;
            }
            return this.filters.stream().allMatch(filter -> filter.ok(bundler, childTransactionImpl));
        }

        public long overpay(long l) {
            return Math.addExact(l, Convert.longValueExact(this.overpayFQTPerFXTBigInteger.multiply(BigInteger.valueOf(l)).divide(Constants.ONE_FXT_BIG_INTEGER)));
        }
    }

    public static class ProportionalFeeCalculator
    implements FeeCalculator {
        @Override
        public long calculateFeeFQT(ChildTransactionImpl childTransactionImpl, Rule rule) {
            long l = childTransactionImpl.getFee();
            long l2 = Convert.longValueExact(BigInteger.valueOf(l).multiply(Constants.ONE_FXT_BIG_INTEGER).divide(rule.minRateNQTPerFXTBigInteger));
            int n = Nxt.getBlockchain().getHeight();
            long l3 = Math.max(l2, childTransactionImpl.getMinimumFeeFQT(n));
            return rule.overpay(l3);
        }

        @Override
        public String getName() {
            return "PROPORTIONAL_FEE";
        }

        @Override
        public void validateRule(Rule rule) {
            if (rule.minRateNQTPerFXT == 0L) {
                throw new IllegalArgumentException("Division by zero: proportional fee calculator cannot be used with 0 rate");
            }
        }
    }

    public static class MinFeeCalculator
    implements FeeCalculator {
        public static final String NAME = "MIN_FEE";

        @Override
        public long calculateFeeFQT(ChildTransactionImpl childTransactionImpl, Rule rule) {
            int n = Nxt.getBlockchain().getHeight();
            return rule.overpay(childTransactionImpl.getMinimumFeeFQT(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static interface FeeCalculator {
        public long calculateFeeFQT(ChildTransactionImpl var1, Rule var2);

        public String getName();

        default public void validateRule(Rule rule) {
        }
    }

    public static interface Filter {
        public boolean ok(Bundler var1, ChildTransaction var2);

        default public String getName() {
            return this.getClass().getSimpleName();
        }

        default public String getDescription() {
            return null;
        }

        default public String getParameter() {
            return null;
        }

        default public void setParameter(String string) {
            if (string != null && !string.isEmpty()) {
                throw new IllegalArgumentException("Bundler " + this.getClass() + " does not support parameters");
            }
        }
    }
}

