/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import java.util.Arrays;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Transaction;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class ChainTransactionId
implements Comparable<ChainTransactionId> {
    public static final int BYTE_SIZE = 36;
    private final int chainId;
    private final byte[] hash;
    private final long id;

    public ChainTransactionId(int n, byte[] byArray) {
        this.chainId = n;
        this.hash = byArray;
        this.id = Convert.fullHashToId(byArray);
    }

    public int getChainId() {
        return this.chainId;
    }

    public String getStringId() {
        return this.chainId + ":" + Convert.toHexString(this.hash);
    }

    public byte[] getFullHash() {
        return this.hash;
    }

    public long getTransactionId() {
        return this.id;
    }

    public Chain getChain() {
        return Chain.getChain(this.chainId);
    }

    public ChildChain getChildChain() {
        return ChildChain.getChildChain(this.chainId);
    }

    public Transaction getTransaction() {
        return Chain.getChain(this.chainId).getTransactionHome().findTransaction(this.hash);
    }

    public ChildTransaction getChildTransaction() {
        return (ChildTransaction)((Object)ChildChain.getChildChain(this.chainId).getTransactionHome().findTransaction(this.hash));
    }

    public static ChainTransactionId getChainTransactionId(Transaction transaction) {
        return new ChainTransactionId(transaction.getChain().getId(), transaction.getFullHash());
    }

    public static ChainTransactionId parse(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        byte[] byArray = new byte[32];
        byteBuffer.get(byArray);
        if (Convert.emptyToNull(byArray) == null) {
            return null;
        }
        return new ChainTransactionId(n, byArray);
    }

    public void put(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.chainId);
        byteBuffer.put(this.hash);
    }

    public static ChainTransactionId parse(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        int n = ((Long)jSONObject.get((Object)"chain")).intValue();
        byte[] byArray = Convert.parseHexString((String)jSONObject.get((Object)"transactionFullHash"));
        return new ChainTransactionId(n, byArray);
    }

    public JSONObject getJSON() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"chain", (Object)this.chainId);
        jSONObject.put((Object)"transactionFullHash", (Object)Convert.toHexString(this.hash));
        return jSONObject;
    }

    public static ChainTransactionId fromStringId(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            return null;
        }
        int n = Integer.parseInt(stringArray[0]);
        byte[] byArray = Convert.parseHexString(stringArray[1]);
        if (byArray == null || byArray.length != 32) {
            return null;
        }
        return new ChainTransactionId(n, byArray);
    }

    public boolean equals(Object object) {
        return object instanceof ChainTransactionId && this.chainId == ((ChainTransactionId)object).chainId && Arrays.equals(this.hash, ((ChainTransactionId)object).hash);
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "chain: " + Chain.getChain(this.chainId).getName() + ", full hash: " + Convert.toHexString(this.hash);
    }

    @Override
    public int compareTo(ChainTransactionId chainTransactionId) {
        int n = Integer.compare(this.chainId, chainTransactionId.chainId);
        if (n != 0) {
            return n;
        }
        n = Long.compare(this.id, chainTransactionId.id);
        if (n != 0) {
            return n;
        }
        return Convert.byteArrayComparator.compare(this.hash, chainTransactionId.hash);
    }
}

