/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildBlockAttachment;
import nxt.blockchain.ChildBlockFxtTransactionImpl;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.Fee;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.blockchain.TransactionType;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.dbschema.Db;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public final class ChildBlockFxtTransactionType
extends FxtTransactionType {
    public static final ChildBlockFxtTransactionType INSTANCE = new ChildBlockFxtTransactionType();
    private static final Fee CHILD_BLOCK_FEE = (transactionImpl, appendix) -> {
        long l = 0L;
        int n = Nxt.getBlockchain().getHeight();
        for (ChildTransactionImpl childTransactionImpl : ((FxtTransactionImpl)transactionImpl).getChildTransactions()) {
            l += childTransactionImpl.getMinimumFeeFQT(n);
        }
        return l;
    };

    @Override
    public byte getType() {
        return -1;
    }

    @Override
    public byte getSubtype() {
        return 0;
    }

    @Override
    public AccountLedger.LedgerEvent getLedgerEvent() {
        return AccountLedger.LedgerEvent.CHILD_BLOCK;
    }

    @Override
    public Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) {
        return new ChildBlockAttachment(byteBuffer);
    }

    @Override
    public Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) throws NxtException.NotValidException {
        return new ChildBlockAttachment(jSONObject);
    }

    @Override
    protected void validateAttachment(FxtTransactionImpl fxtTransactionImpl) throws NxtException.ValidationException {
        ChildBlockAttachment childBlockAttachment = (ChildBlockAttachment)fxtTransactionImpl.getAttachment();
        ChildChain childChain = ChildChain.getChildChain(childBlockAttachment.getChainId());
        if (childChain == null) {
            throw new NxtException.NotValidException("No such child chain id: " + childBlockAttachment.getChainId());
        }
        byte[][] byArray = childBlockAttachment.getChildTransactionFullHashes();
        if (byArray.length == 0) {
            throw new NxtException.NotValidException("Empty ChildBlock transaction");
        }
        if (byArray.length > 100) {
            throw new NxtException.NotValidException("Too many child transactions: " + byArray.length);
        }
        int n = Nxt.getBlockchain().getHeight();
        HashSet<Long> hashSet = new HashSet<Long>();
        byte[] byArray2 = Convert.EMPTY_BYTE;
        for (byte[] byArray3 : byArray) {
            if (Convert.byteArrayComparator.compare(byArray2, byArray3) >= 0) {
                throw new NxtException.NotValidException("Child transaction hashes are not sorted");
            }
            long l = Convert.fullHashToId(byArray3);
            if (!hashSet.add(l)) {
                throw new NxtException.NotValidException("Duplicate child transaction hash");
            }
            if (childChain.getTransactionHome().hasTransaction(byArray3, l, n)) {
                throw new NxtException.NotCurrentlyValidException("Child transaction already included at an earlier height");
            }
            byArray2 = byArray3;
        }
        int n2 = 0;
        for (ChildTransactionImpl childTransactionImpl : fxtTransactionImpl.getChildTransactions()) {
            try {
                childTransactionImpl.validate();
            }
            catch (NxtException.ValidationException validationException) {
                Logger.logDebugMessage("Validation failed for transaction " + JSON.toJSONString((JSONAware)childTransactionImpl.getJSONObject()), validationException);
                throw validationException;
            }
            if (fxtTransactionImpl.getTimestamp() < childTransactionImpl.getTimestamp()) {
                throw new NxtException.NotValidException("ChildBlock transaction timestamp " + fxtTransactionImpl.getTimestamp() + " is before child transaction " + childTransactionImpl.getStringId() + " timestamp " + childTransactionImpl.getTimestamp());
            }
            if (fxtTransactionImpl.getExpiration() > childTransactionImpl.getExpiration()) {
                throw new NxtException.NotValidException("ChildBlock transaction expiration " + fxtTransactionImpl.getExpiration() + " is after child transaction " + childTransactionImpl.getStringId() + " expiration " + childTransactionImpl.getExpiration());
            }
            if ((n2 += childTransactionImpl.getFullSize()) > 131072) {
                throw new NxtException.NotValidException("ChildBlock transaction payload exceeds maximum: " + n2);
            }
            if (childTransactionImpl.getChain().getId() == childChain.getId()) continue;
            throw new NxtException.NotValidException("Child transaction " + childTransactionImpl.getStringId() + " belongs to a different child chain");
        }
    }

    @Override
    protected boolean applyAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
        TransactionProcessorImpl transactionProcessorImpl = TransactionProcessorImpl.getInstance();
        int n = 0;
        for (byte[] byArray : ((ChildBlockFxtTransactionImpl)fxtTransactionImpl).getChildTransactionFullHashes()) {
            UnconfirmedTransaction unconfirmedTransaction = transactionProcessorImpl.getUnconfirmedTransaction(Convert.fullHashToId(byArray));
            if (unconfirmedTransaction == null) continue;
            unconfirmedTransaction.setBundled();
            if (++n % Constants.BATCH_COMMIT_SIZE != 0) continue;
            Db.db.commitTransaction();
        }
        return true;
    }

    @Override
    protected void applyAttachment(FxtTransactionImpl fxtTransactionImpl, Account account, Account account2) {
        ChildBlockAttachment childBlockAttachment = (ChildBlockAttachment)fxtTransactionImpl.getAttachment();
        long l = 0L;
        for (ChildTransactionImpl childTransactionImpl : fxtTransactionImpl.getSortedChildTransactions()) {
            childTransactionImpl.apply();
            l = Math.addExact(l, childTransactionImpl.getFee());
            if ((childTransactionImpl.getIndex() + 1) % Constants.BATCH_COMMIT_SIZE != 0) continue;
            Db.db.commitTransaction();
        }
        ChildChain childChain = ChildChain.getChildChain(childBlockAttachment.getChainId());
        account.addToBalanceAndUnconfirmedBalance(childChain, this.getLedgerEvent(), AccountLedger.newEventId(fxtTransactionImpl), l);
    }

    @Override
    protected void undoAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
    }

    @Override
    public boolean canHaveRecipient() {
        return false;
    }

    @Override
    public String getName() {
        return "ChildChainBlock";
    }

    @Override
    public Fee getBaselineFee(Transaction transaction) {
        return CHILD_BLOCK_FEE;
    }

    @Override
    public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        ChildBlockAttachment childBlockAttachment = (ChildBlockAttachment)transaction.getAttachment();
        return ChildBlockFxtTransactionType.isDuplicate((TransactionType)INSTANCE, String.valueOf(childBlockAttachment.getChainId()), map, true);
    }
}

