/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.AccountRestrictions;
import nxt.account.PublicKeyAnnouncementAppendix;
import nxt.ae.AssetControl;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildBlockFxtTransactionImpl;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.UnconfirmedChildTransaction;
import nxt.crypto.Crypto;
import nxt.db.DbUtils;
import nxt.dbschema.Db;
import nxt.messaging.EncryptToSelfMessageAppendix;
import nxt.messaging.EncryptedMessageAppendix;
import nxt.messaging.MessageAppendix;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Logger;
import nxt.voting.PhasingAppendix;
import nxt.voting.PhasingPollHome;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public final class ChildTransactionImpl
extends TransactionImpl
implements ChildTransaction {
    private final ChildChain childChain;
    private final long fee;
    private final byte[] signature;
    private final ChainTransactionId referencedTransactionId;
    private final MessageAppendix message;
    private final EncryptedMessageAppendix encryptedMessage;
    private final EncryptToSelfMessageAppendix encryptToSelfMessage;
    private final PublicKeyAnnouncementAppendix publicKeyAnnouncement;
    private final PhasingAppendix phasing;
    private volatile long fxtTransactionId;

    private ChildTransactionImpl(BuilderImpl builderImpl, String string, boolean bl) throws NxtException.NotValidException {
        super(builderImpl);
        this.childChain = ChildChain.getChildChain(builderImpl.chainId);
        this.referencedTransactionId = builderImpl.referencedTransactionId;
        this.fxtTransactionId = builderImpl.fxtTransactionId;
        MessageAppendix messageAppendix = null;
        EncryptedMessageAppendix encryptedMessageAppendix = null;
        PublicKeyAnnouncementAppendix publicKeyAnnouncementAppendix = null;
        EncryptToSelfMessageAppendix encryptToSelfMessageAppendix = null;
        PhasingAppendix phasingAppendix = null;
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages()) {
            switch (abstractAppendix.getAppendixType()) {
                case 1: {
                    messageAppendix = (MessageAppendix)abstractAppendix;
                    break;
                }
                case 2: {
                    encryptedMessageAppendix = (EncryptedMessageAppendix)abstractAppendix;
                    break;
                }
                case 32: {
                    publicKeyAnnouncementAppendix = (PublicKeyAnnouncementAppendix)abstractAppendix;
                    break;
                }
                case 4: {
                    encryptToSelfMessageAppendix = (EncryptToSelfMessageAppendix)abstractAppendix;
                    break;
                }
                case 64: {
                    phasingAppendix = (PhasingAppendix)abstractAppendix;
                }
            }
        }
        this.message = messageAppendix;
        this.encryptedMessage = encryptedMessageAppendix;
        this.publicKeyAnnouncement = publicKeyAnnouncementAppendix;
        this.encryptToSelfMessage = encryptToSelfMessageAppendix;
        this.phasing = phasingAppendix;
        if (builderImpl.fee < 0L) {
            long l = this.getMinimumFeeFQT(Nxt.getBlockchain().getHeight());
            if (builderImpl.feeRateNQTPerFXT < 0L) {
                throw new NxtException.NotValidException(String.format("Please include fee in %s equivalent to at least %f %s", this.childChain.getName(), (double)l / 1.0E8, FxtChain.FXT.getName()));
            }
            BigInteger[] bigIntegerArray = BigInteger.valueOf(l).multiply(BigInteger.valueOf(builderImpl.feeRateNQTPerFXT)).divideAndRemainder(Constants.ONE_FXT_BIG_INTEGER);
            this.fee = bigIntegerArray[1].equals(BigInteger.ZERO) ? Convert.longValueExact(bigIntegerArray[0]) : Convert.longValueExact(bigIntegerArray[0]) + 1L;
        } else {
            this.fee = builderImpl.fee;
        }
        if (builderImpl.signature != null && string != null) {
            throw new NxtException.NotValidException("Transaction is already signed");
        }
        if (builderImpl.signature != null) {
            this.signature = builderImpl.signature;
        } else if (string != null) {
            byte[] byArray;
            byte[] byArray2 = byArray = builderImpl.senderPublicKey != null ? builderImpl.senderPublicKey : Account.getPublicKey(builderImpl.senderId);
            if (byArray != null && !Arrays.equals(byArray, Crypto.getPublicKey(string)) && !bl) {
                throw new NxtException.NotValidException("Secret phrase doesn't match transaction sender public key");
            }
            this.signature = Crypto.sign(this.bytes(), string);
            this.bytes = null;
        } else {
            this.signature = null;
        }
    }

    @Override
    public ChildChain getChain() {
        return this.childChain;
    }

    @Override
    public long getFxtTransactionId() {
        return this.fxtTransactionId;
    }

    void setFxtTransaction(ChildBlockFxtTransactionImpl childBlockFxtTransactionImpl) {
        this.fxtTransactionId = childBlockFxtTransactionImpl.getId();
        this.setBlock(childBlockFxtTransactionImpl.getBlock());
    }

    void unsetFxtTransaction() {
        this.fxtTransactionId = 0L;
        this.unsetBlock();
        this.setIndex(-1);
    }

    @Override
    public ChainTransactionId getReferencedTransactionId() {
        return this.referencedTransactionId;
    }

    @Override
    public MessageAppendix getMessage() {
        return this.message;
    }

    @Override
    public EncryptedMessageAppendix getEncryptedMessage() {
        return this.encryptedMessage;
    }

    @Override
    public EncryptToSelfMessageAppendix getEncryptToSelfMessage() {
        return this.encryptToSelfMessage;
    }

    @Override
    public PhasingAppendix getPhasing() {
        return this.phasing;
    }

    @Override
    public boolean isPhased() {
        return this.phasing != null;
    }

    @Override
    public boolean attachmentIsPhased() {
        return this.attachment.isPhased(this);
    }

    @Override
    public long getFee() {
        return this.fee;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public JSONObject getJSONObject() {
        JSONObject jSONObject = super.getJSONObject();
        if (this.referencedTransactionId != null) {
            jSONObject.put((Object)"referencedTransaction", (Object)this.referencedTransactionId.getJSON());
        }
        return jSONObject;
    }

    @Override
    public long getMinimumFeeFQT(int n) {
        long l = super.getMinimumFeeFQT(n);
        if (this.referencedTransactionId != null) {
            l = Math.addExact(l, 1000000L);
        }
        return l;
    }

    @Override
    boolean hasAllReferencedTransactions(int n, int n2) {
        if (this.referencedTransactionId == null) {
            return n - this.getTimestamp() < 5184000 && n2 < 10;
        }
        TransactionImpl transactionImpl = (TransactionImpl)this.referencedTransactionId.getTransaction();
        return transactionImpl != null && transactionImpl.getHeight() < this.getHeight() && transactionImpl.hasAllReferencedTransactions(n, n2 + 1);
    }

    @Override
    ByteBuffer generateBytes(boolean bl) {
        ByteBuffer byteBuffer = super.generateBytes(bl);
        if (this.referencedTransactionId != null) {
            this.referencedTransactionId.put(byteBuffer);
        } else {
            byteBuffer.putInt(0);
            byteBuffer.put(new byte[32]);
        }
        return byteBuffer;
    }

    @Override
    protected int getSize() {
        return super.getSize() + 36;
    }

    public final boolean equals(Object object) {
        return object instanceof ChildTransactionImpl && this.getId() == ((Transaction)object).getId() && Arrays.equals(this.getFullHash(), ((Transaction)object).getFullHash());
    }

    public final int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    @Override
    public void validate() throws NxtException.ValidationException {
        try {
            super.validate();
            if (!this.childChain.isEnabled()) {
                throw new NxtException.NotYetEnabledException("Child chain " + this.childChain.getName() + " not yet enabled for accepting transactions");
            }
            if (ChildTransactionType.findTransactionType(this.getType().getType(), this.getType().getSubtype()) == null) {
                throw new NxtException.NotValidException("Invalid transaction type " + this.getType().getName() + " for ChildTransaction");
            }
            if (this.referencedTransactionId != null) {
                if (this.referencedTransactionId.getFullHash().length != 32) {
                    throw new NxtException.NotValidException("Invalid referenced transaction full hash " + Convert.toHexString(this.referencedTransactionId.getFullHash()));
                }
                if (this.referencedTransactionId.getChain() == null) {
                    throw new NxtException.NotValidException("Invalid referenced transaction chain " + this.referencedTransactionId.getChainId());
                }
            }
            boolean bl = this.phasing != null && this.getSignature() != null && this.childChain.getPhasingPollHome().getPoll(this) != null;
            int n = -1;
            for (Appendix.AbstractAppendix abstractAppendix : this.appendages()) {
                if (abstractAppendix.getAppendixType() <= n) {
                    throw new NxtException.NotValidException("Duplicate or not in order appendix " + abstractAppendix.getAppendixName());
                }
                n = abstractAppendix.getAppendixType();
                if (!abstractAppendix.isAllowed(this.childChain)) {
                    throw new NxtException.NotValidException("Appendix not allowed on child chain " + abstractAppendix.getAppendixName());
                }
                abstractAppendix.loadPrunable(this);
                if (!abstractAppendix.verifyVersion()) {
                    throw new NxtException.NotValidException("Invalid attachment version " + abstractAppendix.getVersion());
                }
                if (bl) {
                    abstractAppendix.validateAtFinish(this);
                    continue;
                }
                abstractAppendix.validate(this);
            }
            if (this.getFullSize() > 131072) {
                throw new NxtException.NotValidException("Transaction size " + this.getFullSize() + " exceeds maximum payload size");
            }
            if (!bl) {
                this.validateEcBlock();
                AccountRestrictions.checkTransaction(this);
                AssetControl.checkTransaction(this);
            }
        }
        catch (NxtException.NotValidException notValidException) {
            if (this.getSignature() != null) {
                Logger.logMessage("Invalid child transaction " + this.getStringId());
            }
            throw notValidException;
        }
    }

    @Override
    protected void validateId() throws NxtException.ValidationException {
        super.validateId();
        if (PhasingPollHome.hasUnfinishedPhasedTransaction(this.getId())) {
            throw new NxtException.NotCurrentlyValidException("Phased transaction currently exists with the same id");
        }
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages()) {
            abstractAppendix.validateId(this);
        }
    }

    @Override
    public void apply() {
        Account account = Account.getAccount(this.getSenderId());
        account.apply(this.getSenderPublicKey());
        Account account2 = null;
        if (this.getRecipientId() != 0L && (account2 = Account.getAccount(this.getRecipientId())) == null) {
            account2 = Account.addOrGetAccount(this.getRecipientId());
        }
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(this);
        if (this.referencedTransactionId != null) {
            account.addToUnconfirmedBalance(FxtChain.FXT, this.getType().getLedgerEvent(), ledgerEventId, 0L, 1000000000L);
        }
        if (this.attachmentIsPhased()) {
            this.childChain.getBalanceHome().getBalance(this.getSenderId()).addToBalance(this.getType().getLedgerEvent(), ledgerEventId, 0L, -this.fee);
        }
        for (Appendix.AbstractAppendix abstractAppendix : this.appendages()) {
            if (abstractAppendix.isPhased(this)) continue;
            abstractAppendix.loadPrunable(this);
            abstractAppendix.apply(this, account, account2);
        }
    }

    @Override
    void save(Connection connection, String string) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + string + " (id, deadline, recipient_id, amount, fee, referenced_transaction_chain_id, referenced_transaction_full_hash, referenced_transaction_id, height, block_id, signature, timestamp, type, subtype, sender_id, attachment_bytes, block_timestamp, full_hash, version, has_message, has_encrypted_message, has_public_key_announcement, has_encrypttoself_message, phased, has_prunable_message, has_prunable_encrypted_message, has_prunable_attachment, ec_block_height, ec_block_id, transaction_index, fxt_transaction_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.getId());
            preparedStatement.setShort(++n, this.getDeadline());
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.getRecipientId());
            preparedStatement.setLong(++n, this.getAmount());
            preparedStatement.setLong(++n, this.getFee());
            if (this.referencedTransactionId != null) {
                preparedStatement.setInt(++n, this.referencedTransactionId.getChainId());
                preparedStatement.setBytes(++n, this.referencedTransactionId.getFullHash());
                preparedStatement.setLong(++n, this.referencedTransactionId.getTransactionId());
            } else {
                preparedStatement.setNull(++n, 4);
                preparedStatement.setNull(++n, -2);
                preparedStatement.setNull(++n, -5);
            }
            preparedStatement.setInt(++n, this.getHeight());
            preparedStatement.setLong(++n, this.getBlockId());
            preparedStatement.setBytes(++n, this.getSignature());
            preparedStatement.setInt(++n, this.getTimestamp());
            preparedStatement.setByte(++n, this.getType().getType());
            preparedStatement.setByte(++n, this.getType().getSubtype());
            preparedStatement.setLong(++n, this.getSenderId());
            int n2 = 0;
            for (Appendix appendix : this.getAppendages()) {
                n2 += appendix.getSize();
            }
            if (n2 == 0) {
                preparedStatement.setNull(++n, -3);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n2 + 4);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.putAppendages(byteBuffer, false);
                preparedStatement.setBytes(++n, byteBuffer.array());
            }
            preparedStatement.setInt(++n, this.getBlockTimestamp());
            preparedStatement.setBytes(++n, this.getFullHash());
            preparedStatement.setByte(++n, this.getVersion());
            preparedStatement.setBoolean(++n, this.message != null);
            preparedStatement.setBoolean(++n, this.encryptedMessage != null);
            preparedStatement.setBoolean(++n, this.publicKeyAnnouncement != null);
            preparedStatement.setBoolean(++n, this.encryptToSelfMessage != null);
            preparedStatement.setBoolean(++n, this.phasing != null);
            preparedStatement.setBoolean(++n, this.hasPrunablePlainMessage());
            preparedStatement.setBoolean(++n, this.hasPrunableEncryptedMessage());
            preparedStatement.setBoolean(++n, this.getAttachment() instanceof Appendix.Prunable);
            preparedStatement.setInt(++n, this.getECBlockHeight());
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.getECBlockId());
            preparedStatement.setShort(++n, this.getIndex());
            preparedStatement.setLong(++n, this.getFxtTransactionId());
            preparedStatement.executeUpdate();
            if ((this.getIndex() + 1) % Constants.BATCH_COMMIT_SIZE == 0) {
                Db.db.commitTransaction();
            }
        }
    }

    @Override
    final UnconfirmedChildTransaction newUnconfirmedTransaction(long l, boolean bl) {
        return new UnconfirmedChildTransaction(this, l, bl);
    }

    static BuilderImpl newTransactionBuilder(int n, byte by, long l, long l2, short s, List<Appendix.AbstractAppendix> list, ResultSet resultSet) {
        try {
            BuilderImpl builderImpl = new BuilderImpl(n, by, null, l, l2, s, list);
            byte[] byArray = resultSet.getBytes("referenced_transaction_full_hash");
            if (byArray != null) {
                int n2 = resultSet.getInt("referenced_transaction_chain_id");
                builderImpl.referencedTransaction(new ChainTransactionId(n2, byArray));
            }
            long l3 = resultSet.getLong("fxt_transaction_id");
            builderImpl.fxtTransactionId(l3);
            return builderImpl;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    static BuilderImpl newTransactionBuilder(int n, byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list, ByteBuffer byteBuffer) {
        try {
            BuilderImpl builderImpl = new BuilderImpl(n, by, byArray, l, l2, s, list);
            ChainTransactionId chainTransactionId = ChainTransactionId.parse(byteBuffer);
            builderImpl.referencedTransaction(chainTransactionId);
            return builderImpl;
        }
        catch (RuntimeException runtimeException) {
            Logger.logDebugMessage("Failed to parse transaction bytes: " + Convert.toHexString(byteBuffer.array()));
            throw runtimeException;
        }
    }

    static BuilderImpl newTransactionBuilder(int n, byte by, byte[] byArray, long l, long l2, short s, Attachment.AbstractAttachment abstractAttachment) {
        return new BuilderImpl(n, by, byArray, l, l2, s, abstractAttachment);
    }

    static BuilderImpl newTransactionBuilder(int n, byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list, JSONObject jSONObject) {
        try {
            BuilderImpl builderImpl = new BuilderImpl(n, by, byArray, l, l2, s, list);
            ChainTransactionId chainTransactionId = ChainTransactionId.parse((JSONObject)jSONObject.get((Object)"referencedTransaction"));
            builderImpl.referencedTransaction(chainTransactionId);
            return builderImpl;
        }
        catch (RuntimeException runtimeException) {
            Logger.logDebugMessage("Failed to parse transaction: " + JSON.toJSONString((JSONAware)jSONObject));
            throw runtimeException;
        }
    }

    public static final class BuilderImpl
    extends TransactionImpl.BuilderImpl
    implements ChildTransaction.Builder {
        private ChainTransactionId referencedTransactionId;
        private long fxtTransactionId;
        private long feeRateNQTPerFXT;

        private BuilderImpl(int n, byte by, byte[] byArray, long l, long l2, short s, Attachment.AbstractAttachment abstractAttachment) {
            super(n, by, byArray, l, l2, s, abstractAttachment);
        }

        private BuilderImpl(int n, byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list) {
            super(n, by, byArray, l, l2, s, list);
        }

        @Override
        public ChildTransactionImpl build(String string, boolean bl) throws NxtException.NotValidException {
            this.preBuild(string, bl);
            return new ChildTransactionImpl(this, string, bl);
        }

        @Override
        public ChildTransactionImpl build(String string) throws NxtException.NotValidException {
            return this.build(string, false);
        }

        @Override
        public ChildTransactionImpl build() throws NxtException.NotValidException {
            return this.build(null);
        }

        @Override
        public BuilderImpl referencedTransaction(ChainTransactionId chainTransactionId) {
            this.referencedTransactionId = chainTransactionId;
            return this;
        }

        BuilderImpl fxtTransactionId(long l) {
            this.fxtTransactionId = l;
            return this;
        }

        @Override
        public BuilderImpl feeRateNQTPerFXT(long l) {
            this.feeRateNQTPerFXT = l;
            return this;
        }
    }
}

