/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.util.List;
import nxt.NxtException;
import nxt.account.AccountLedger;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.Block;
import nxt.blockchain.Chain;
import nxt.blockchain.TransactionType;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.util.Filter;
import org.json.simple.JSONObject;

public interface Transaction
extends AccountLedger.LedgerEventId {
    @Override
    public Chain getChain();

    @Override
    public long getId();

    public String getStringId();

    public long getSenderId();

    public byte[] getSenderPublicKey();

    public long getRecipientId();

    public int getHeight();

    public long getBlockId();

    public Block getBlock();

    public short getIndex();

    public int getTimestamp();

    public int getBlockTimestamp();

    public short getDeadline();

    public int getExpiration();

    public long getAmount();

    public long getFee();

    public long getMinimumFeeFQT();

    public byte[] getSignature();

    @Override
    public byte[] getFullHash();

    public TransactionType getType();

    public Attachment getAttachment();

    public boolean verifySignature();

    public void validate() throws NxtException.ValidationException;

    public byte[] getBytes();

    public byte[] getUnsignedBytes();

    public byte[] getPrunableBytes();

    public JSONObject getJSONObject();

    public JSONObject getPrunableAttachmentJSON();

    public byte getVersion();

    public int getFullSize();

    public List<? extends Appendix> getAppendages();

    public List<? extends Appendix> getAppendages(boolean var1);

    public List<? extends Appendix> getAppendages(Filter<Appendix> var1, boolean var2);

    public int getECBlockHeight();

    public long getECBlockId();

    public boolean isPhased();

    public PrunablePlainMessageAppendix getPrunablePlainMessage();

    public PrunableEncryptedMessageAppendix getPrunableEncryptedMessage();

    public static interface Builder {
        public Builder recipientId(long var1);

        public Builder timestamp(int var1);

        public Builder ecBlockHeight(int var1);

        public Builder ecBlockId(long var1);

        public Builder appendix(Appendix var1);

        public Transaction build() throws NxtException.NotValidException;

        public Transaction build(String var1) throws NxtException.NotValidException;

        public Transaction build(String var1, boolean var2) throws NxtException.NotValidException;
    }
}

