/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.Transaction;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.db.DbIterator;
import nxt.util.Observable;

public interface TransactionProcessor
extends Observable<List<? extends Transaction>, Event> {
    public List<Long> getAllUnconfirmedTransactionIds();

    public DbIterator<? extends Transaction> getAllUnconfirmedTransactions();

    public DbIterator<? extends Transaction> getAllUnconfirmedTransactions(int var1, int var2);

    public DbIterator<? extends Transaction> getAllUnconfirmedTransactions(String var1);

    public DbIterator<? extends Transaction> getAllUnconfirmedTransactions(int var1, int var2, String var3);

    public DbIterator<? extends Transaction> getUnconfirmedFxtTransactions();

    public DbIterator<? extends Transaction> getUnconfirmedChildTransactions(ChildChain var1);

    public UnconfirmedTransaction getUnconfirmedTransaction(long var1);

    public UnconfirmedTransaction[] getAllWaitingTransactions();

    public Transaction[] getAllBroadcastedTransactions();

    public void clearUnconfirmedTransactions();

    public void requeueAllUnconfirmedTransactions();

    public void rebroadcastAllUnconfirmedTransactions();

    public void broadcast(Transaction var1) throws NxtException.ValidationException;

    public void broadcastLater(Transaction var1);

    public List<? extends Transaction> processPeerTransactions(List<Transaction> var1) throws NxtException.NotValidException;

    public void processLater(Collection<? extends FxtTransaction> var1);

    public SortedSet<? extends Transaction> getCachedUnconfirmedTransactions(List<Long> var1);

    public List<Transaction> restorePrunableData(List<Transaction> var1);

    public static enum Event {
        REMOVED_UNCONFIRMED_TRANSACTIONS,
        ADDED_UNCONFIRMED_TRANSACTIONS,
        ADDED_CONFIRMED_TRANSACTIONS,
        RELEASE_PHASED_TRANSACTION,
        REJECT_PHASED_TRANSACTION;

    }
}

