/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.Block;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.blockchain.TransactionType;
import nxt.db.DbKey;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.util.Filter;
import org.json.simple.JSONObject;

public abstract class UnconfirmedTransaction
implements Transaction {
    private final TransactionImpl transaction;
    private final DbKey dbKey;
    private final long arrivalTimestamp;
    private final long feePerByte;
    private volatile boolean isBundled;

    static UnconfirmedTransaction load(ResultSet resultSet) throws SQLException {
        Chain chain = Chain.getChain(resultSet.getInt("chain_id"));
        try {
            return chain.newUnconfirmedTransaction(resultSet);
        }
        catch (NxtException.NotValidException notValidException) {
            throw new RuntimeException(notValidException.getMessage(), notValidException);
        }
    }

    UnconfirmedTransaction(TransactionImpl transactionImpl, long l, boolean bl) {
        this.transaction = transactionImpl;
        this.arrivalTimestamp = l;
        this.feePerByte = transactionImpl.getFee() / (long)transactionImpl.getFullSize();
        this.isBundled = bl;
        this.dbKey = TransactionProcessorImpl.getInstance().unconfirmedTransactionDbKeyFactory.newKey(transactionImpl.getId());
    }

    UnconfirmedTransaction(TransactionImpl.BuilderImpl builderImpl, ResultSet resultSet) throws SQLException {
        try {
            this.transaction = builderImpl.build();
            this.transaction.setHeight(resultSet.getInt("transaction_height"));
            this.arrivalTimestamp = resultSet.getLong("arrival_timestamp");
            this.feePerByte = resultSet.getLong("fee_per_byte");
            this.isBundled = resultSet.getBoolean("is_bundled");
            this.dbKey = TransactionProcessorImpl.getInstance().unconfirmedTransactionDbKeyFactory.newKey(this.transaction.getId());
        }
        catch (NxtException.ValidationException validationException) {
            throw new RuntimeException(validationException.toString(), validationException);
        }
    }

    void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO unconfirmed_transaction (id, transaction_height, fee, fee_per_byte, is_bundled, expiration, transaction_bytes, arrival_timestamp, chain_id, height) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.transaction.getId());
            preparedStatement.setInt(++n, this.transaction.getHeight());
            preparedStatement.setLong(++n, this.transaction.getFee());
            preparedStatement.setLong(++n, this.feePerByte);
            preparedStatement.setBoolean(++n, this.isBundled);
            preparedStatement.setInt(++n, this.transaction.getExpiration());
            preparedStatement.setBytes(++n, this.transaction.prunableBytes());
            preparedStatement.setLong(++n, this.arrivalTimestamp);
            preparedStatement.setInt(++n, this.transaction.getChain().getId());
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public TransactionImpl getTransaction() {
        return this.transaction;
    }

    long getArrivalTimestamp() {
        return this.arrivalTimestamp;
    }

    void setBundled() {
        this.isBundled = true;
        TransactionProcessorImpl.getInstance().unconfirmedTransactionTable.insert(this);
    }

    public boolean isBundled() {
        return this.isBundled;
    }

    public final boolean equals(Object object) {
        return object instanceof UnconfirmedTransaction && this.transaction.equals(((UnconfirmedTransaction)object).getTransaction());
    }

    public final int hashCode() {
        return this.transaction.hashCode();
    }

    @Override
    public Chain getChain() {
        return this.transaction.getChain();
    }

    @Override
    public long getId() {
        return this.transaction.getId();
    }

    DbKey getDbKey() {
        return this.dbKey;
    }

    @Override
    public String getStringId() {
        return this.transaction.getStringId();
    }

    @Override
    public long getSenderId() {
        return this.transaction.getSenderId();
    }

    @Override
    public byte[] getSenderPublicKey() {
        return this.transaction.getSenderPublicKey();
    }

    @Override
    public long getRecipientId() {
        return this.transaction.getRecipientId();
    }

    @Override
    public int getHeight() {
        return this.transaction.getHeight();
    }

    @Override
    public long getBlockId() {
        return this.transaction.getBlockId();
    }

    @Override
    public Block getBlock() {
        return this.transaction.getBlock();
    }

    @Override
    public int getTimestamp() {
        return this.transaction.getTimestamp();
    }

    @Override
    public int getBlockTimestamp() {
        return this.transaction.getBlockTimestamp();
    }

    @Override
    public short getDeadline() {
        return this.transaction.getDeadline();
    }

    @Override
    public int getExpiration() {
        return this.transaction.getExpiration();
    }

    @Override
    public long getAmount() {
        return this.transaction.getAmount();
    }

    @Override
    public long getFee() {
        return this.transaction.getFee();
    }

    @Override
    public long getMinimumFeeFQT() {
        return this.transaction.getMinimumFeeFQT();
    }

    @Override
    public byte[] getSignature() {
        return this.transaction.getSignature();
    }

    @Override
    public TransactionType getType() {
        return this.transaction.getType();
    }

    @Override
    public Attachment getAttachment() {
        return this.transaction.getAttachment();
    }

    @Override
    public boolean verifySignature() {
        return this.transaction.verifySignature();
    }

    @Override
    public void validate() throws NxtException.ValidationException {
        if (TransactionProcessorImpl.getInstance().getUnconfirmedTransaction(this.transaction.getId()) != null || this.getChain().getTransactionHome().hasTransaction(this.transaction)) {
            throw new NxtException.ExistingTransactionException("Transaction already processed");
        }
        this.transaction.validate();
    }

    @Override
    public byte[] getBytes() {
        return this.transaction.getBytes();
    }

    @Override
    public byte[] getUnsignedBytes() {
        return this.transaction.getUnsignedBytes();
    }

    @Override
    public byte[] getPrunableBytes() {
        return this.transaction.getPrunableBytes();
    }

    @Override
    public JSONObject getJSONObject() {
        return this.transaction.getJSONObject();
    }

    @Override
    public JSONObject getPrunableAttachmentJSON() {
        return this.transaction.getPrunableAttachmentJSON();
    }

    @Override
    public byte getVersion() {
        return this.transaction.getVersion();
    }

    @Override
    public int getFullSize() {
        return this.transaction.getFullSize();
    }

    @Override
    public List<? extends Appendix> getAppendages() {
        return this.transaction.getAppendages();
    }

    @Override
    public List<? extends Appendix> getAppendages(boolean bl) {
        return this.transaction.getAppendages(bl);
    }

    @Override
    public List<? extends Appendix> getAppendages(Filter<Appendix> filter, boolean bl) {
        return this.transaction.getAppendages(filter, bl);
    }

    @Override
    public int getECBlockHeight() {
        return this.transaction.getECBlockHeight();
    }

    @Override
    public long getECBlockId() {
        return this.transaction.getECBlockId();
    }

    @Override
    public short getIndex() {
        return this.transaction.getIndex();
    }

    @Override
    public boolean isPhased() {
        return this.transaction.isPhased();
    }

    @Override
    public byte[] getFullHash() {
        return this.transaction.getFullHash();
    }

    public ChainTransactionId getReferencedTransactionId() {
        return null;
    }

    @Override
    public PrunablePlainMessageAppendix getPrunablePlainMessage() {
        return this.getTransaction().getPrunablePlainMessage();
    }

    @Override
    public PrunableEncryptedMessageAppendix getPrunableEncryptedMessage() {
        return this.getTransaction().getPrunableEncryptedMessage();
    }
}

