/*
 * Decompiled with CFR 0.152.
 */
package nxt.ce;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import nxt.Nxt;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.blockchain.Block;
import nxt.blockchain.Chain;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.ce.OrderIssueAttachment;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class CoinExchange {
    private static final BigDecimal ONE_HALF = BigDecimal.valueOf(5L, 1);
    private static final Listeners<Trade, Event> listeners = new Listeners();
    private static final DbKey.LongKeyFactory<Order> orderDbKeyFactory = new DbKey.LongKeyFactory<Order>("id"){

        @Override
        public DbKey newKey(Order order) {
            return order.dbKey;
        }
    };
    private static final VersionedEntityDbTable<Order> orderTable = new VersionedEntityDbTable<Order>("PUBLIC.coin_order_fxt", orderDbKeyFactory){

        @Override
        protected Order load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Order(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Order order) throws SQLException {
            order.save(connection, this.schemaTable);
        }

        @Override
        protected String defaultSort() {
            return " ORDER BY creation_height DESC ";
        }
    };
    private static final DbKey.HashHashKeyFactory<Trade> tradeDbKeyFactory = new DbKey.HashHashKeyFactory<Trade>("order_full_hash", "order_id", "match_full_hash", "match_id"){

        @Override
        public DbKey newKey(Trade trade) {
            return trade.dbKey;
        }
    };
    private static final EntityDbTable<Trade> tradeTable = new EntityDbTable<Trade>("PUBLIC.coin_trade_fxt", tradeDbKeyFactory){

        @Override
        protected Trade load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Trade(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Trade trade) throws SQLException {
            trade.save(connection, this.schemaTable);
        }
    };

    public static boolean addListener(Listener<Trade> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Trade> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    private CoinExchange() {
    }

    public static void init() {
    }

    /*
     * Exception decompiling
     */
    private static Order getNextBidOrder(int var0, int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static Order getNextAskOrder(int var0, int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void addOrder(Transaction transaction, OrderIssueAttachment orderIssueAttachment) {
        Order order = new Order(transaction, orderIssueAttachment);
        orderTable.insert(order);
        CoinExchange.matchOrders(orderIssueAttachment);
    }

    static void removeOrder(long l) {
        orderTable.delete(CoinExchange.getOrder(l));
    }

    public static int getOrderCount() {
        return orderTable.getCount();
    }

    public static Order getOrder(long l) {
        return (Order)orderTable.get(orderDbKeyFactory.newKey(l));
    }

    public static DbIterator<Order> getOrders(long l, int n, int n2, int n3, int n4) {
        ArrayList<DbClause> arrayList = new ArrayList<DbClause>();
        if (l != 0L) {
            arrayList.add(new DbClause.LongClause("account_id", l));
        }
        if (n != 0) {
            arrayList.add(new DbClause.IntClause("chain_id", n));
        }
        if (n2 != 0) {
            arrayList.add(new DbClause.IntClause("exchange_id", n2));
        }
        DbClause dbClause = null;
        if (arrayList.isEmpty()) {
            dbClause = DbClause.EMPTY_CLAUSE;
        } else {
            for (DbClause dbClause2 : arrayList) {
                if (dbClause == null) {
                    dbClause = dbClause2;
                    continue;
                }
                dbClause = dbClause.and(dbClause2);
            }
        }
        return orderTable.getManyBy(dbClause, n3, n4, "ORDER BY bid_price DESC, creation_height ASC, transaction_height ASC, transaction_index ASC");
    }

    private static Trade addTrade(long l, BigDecimal bigDecimal, Order order, Order order2) {
        Trade trade = new Trade(l, bigDecimal, order, order2);
        tradeTable.insert(trade);
        listeners.notify(trade, Event.TRADE);
        return trade;
    }

    public static Trade getTrade(byte[] byArray, byte[] byArray2) {
        return tradeTable.get(tradeDbKeyFactory.newKey(byArray, byArray2));
    }

    public static int getTradeCount() {
        return tradeTable.getCount();
    }

    public static DbIterator<Trade> getTrades(long l, int n, int n2, byte[] byArray, int n3, int n4) {
        ArrayList<DbClause> arrayList = new ArrayList<DbClause>();
        if (l != 0L) {
            arrayList.add(new DbClause.LongClause("account_id", l));
        }
        if (n != 0) {
            arrayList.add(new DbClause.IntClause("chain_id", n));
        }
        if (n2 != 0) {
            arrayList.add(new DbClause.IntClause("exchange_id", n2));
        }
        if (byArray != null && byArray.length != 0) {
            arrayList.add(new DbClause.HashClause("order_full_hash", "order_id", byArray));
        }
        DbClause dbClause = null;
        if (arrayList.isEmpty()) {
            dbClause = DbClause.EMPTY_CLAUSE;
        } else {
            for (DbClause dbClause2 : arrayList) {
                if (dbClause == null) {
                    dbClause = dbClause2;
                    continue;
                }
                dbClause = dbClause.and(dbClause2);
            }
        }
        return tradeTable.getManyBy(dbClause, n3, n4, "ORDER BY height DESC, db_id DESC");
    }

    private static void matchOrders(OrderIssueAttachment orderIssueAttachment) {
        Order order;
        Order order2;
        Chain chain = orderIssueAttachment.getChain();
        int n = chain.getDecimals();
        Chain chain2 = orderIssueAttachment.getExchangeChain();
        int n2 = chain2.getDecimals();
        while ((order2 = CoinExchange.getNextAskOrder(chain2.getId(), chain.getId())) != null && (order = CoinExchange.getNextBidOrder(chain.getId(), chain2.getId())) != null && order2.getAskPriceNQT() <= order.getBidPriceNQT()) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2;
            boolean bl;
            boolean bl2 = bl = order2.getHeight() < order.getHeight() || order2.getHeight() == order.getHeight() && (order2.getTransactionHeight() < order.getTransactionHeight() || order2.getTransactionHeight() == order.getTransactionHeight() && order2.getTransactionIndex() < order.getTransactionIndex());
            if (bl) {
                bigDecimal2 = order2.getAskPrice();
                bigDecimal = order2.getBidPrice();
            } else {
                bigDecimal2 = order.getBidPrice();
                bigDecimal = order.getAskPrice();
            }
            BigDecimal[] bigDecimalArray = BigDecimal.valueOf(order2.getQuantityQNT(), n).multiply(bigDecimal).movePointRight(n2).divideAndRemainder(BigDecimal.ONE, MathContext.DECIMAL128);
            long l = bigDecimalArray[0].longValue();
            if (bigDecimalArray[1].compareTo(ONE_HALF) >= 0) {
                ++l;
            }
            long l2 = Math.min(order2.getAmountNQT(), Math.min(order.getQuantityQNT(), l));
            bigDecimalArray = BigDecimal.valueOf(order.getQuantityQNT(), n2).multiply(bigDecimal2).movePointRight(n).divideAndRemainder(BigDecimal.ONE, MathContext.DECIMAL128);
            long l3 = bigDecimalArray[0].longValue();
            if (bigDecimalArray[1].compareTo(ONE_HALF) >= 0) {
                ++l3;
            }
            long l4 = Math.min(order.getAmountNQT(), Math.min(order2.getQuantityQNT(), l3));
            CoinExchange.addTrade(l2, bigDecimal2, order, order2);
            CoinExchange.addTrade(l4, bigDecimal, order2, order);
            order.updateQuantity(order.getQuantityQNT() - l2, order.getAmountNQT() - l4);
            BalanceHome.Balance balance = chain.getBalanceHome().getBalance(order.getAccountId());
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(order.getId(), order.getFullHash(), chain2 != FxtChain.FXT ? chain : FxtChain.FXT);
            balance.addToBalance(AccountLedger.LedgerEvent.COIN_EXCHANGE_TRADE, ledgerEventId, -l4);
            if (order.getQuantityQNT() == 0L && order.getAmountNQT() != 0L) {
                balance.addToUnconfirmedBalance(AccountLedger.LedgerEvent.COIN_EXCHANGE_TRADE, ledgerEventId, order.getAmountNQT());
            }
            balance = chain2.getBalanceHome().getBalance(order.getAccountId());
            balance.addToBalanceAndUnconfirmedBalance(AccountLedger.LedgerEvent.COIN_EXCHANGE_TRADE, ledgerEventId, l2);
            order2.updateQuantity(order2.getQuantityQNT() - l4, order2.getAmountNQT() - l2);
            BalanceHome.Balance balance2 = chain2.getBalanceHome().getBalance(order2.getAccountId());
            AccountLedger.LedgerEventId ledgerEventId2 = AccountLedger.newEventId(order2.getId(), order2.getFullHash(), chain != FxtChain.FXT ? chain2 : FxtChain.FXT);
            balance2.addToBalance(AccountLedger.LedgerEvent.COIN_EXCHANGE_TRADE, ledgerEventId2, -l2);
            if (order2.getQuantityQNT() == 0L && order2.getAmountNQT() != 0L) {
                balance2.addToUnconfirmedBalance(AccountLedger.LedgerEvent.COIN_EXCHANGE_TRADE, ledgerEventId2, order2.getAmountNQT());
            }
            balance2 = chain.getBalanceHome().getBalance(order2.getAccountId());
            balance2.addToBalanceAndUnconfirmedBalance(AccountLedger.LedgerEvent.COIN_EXCHANGE_TRADE, ledgerEventId2, l4);
        }
    }

    public static final class Trade {
        private final DbKey dbKey;
        private final int chainId;
        private final int exchangeId;
        private final long blockId;
        private final int height;
        private final int timestamp;
        private final long exchangeQuantityQNT;
        private final BigDecimal exchangePrice;
        private final long accountId;
        private final long orderId;
        private final byte[] orderFullHash;
        private final long matchId;
        private final byte[] matchFullHash;

        private Trade(long l, BigDecimal bigDecimal, Order order, Order order2) {
            Block block = Nxt.getBlockchain().getLastBlock();
            this.blockId = block.getId();
            this.height = block.getHeight();
            this.timestamp = block.getTimestamp();
            this.chainId = order.getChainId();
            this.exchangeId = order.getExchangeId();
            this.accountId = order.getAccountId();
            this.orderId = order.getId();
            this.orderFullHash = order.getFullHash();
            this.exchangeQuantityQNT = l;
            this.exchangePrice = bigDecimal;
            this.matchId = order2.getId();
            this.matchFullHash = order2.getFullHash();
            this.dbKey = tradeDbKeyFactory.newKey(this.orderFullHash, this.orderId, this.matchFullHash, this.matchId);
        }

        private Trade(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.dbKey = dbKey;
            this.blockId = resultSet.getLong("block_id");
            this.height = resultSet.getInt("height");
            this.timestamp = resultSet.getInt("timestamp");
            this.chainId = resultSet.getInt("chain_id");
            this.exchangeId = resultSet.getInt("exchange_id");
            this.accountId = resultSet.getLong("account_id");
            this.orderId = resultSet.getLong("order_id");
            this.orderFullHash = resultSet.getBytes("order_full_hash");
            this.exchangeQuantityQNT = resultSet.getLong("exchange_quantity");
            this.exchangePrice = BigDecimal.valueOf(resultSet.getLong("exchange_price"), 8);
            this.matchId = resultSet.getLong("match_id");
            this.matchFullHash = resultSet.getBytes("match_full_hash");
        }

        private void save(Connection connection, String string) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + string + "(chain_id, exchange_id, block_id, height, timestamp, exchange_quantity, exchange_price, account_id, order_id, order_full_hash, match_id, match_full_hash) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setInt(++n, this.chainId);
                preparedStatement.setInt(++n, this.exchangeId);
                preparedStatement.setLong(++n, this.blockId);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.setInt(++n, this.timestamp);
                preparedStatement.setLong(++n, this.exchangeQuantityQNT);
                preparedStatement.setLong(++n, this.exchangePrice.movePointRight(8).longValue());
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setLong(++n, this.orderId);
                preparedStatement.setBytes(++n, this.orderFullHash);
                preparedStatement.setLong(++n, this.matchId);
                preparedStatement.setBytes(++n, this.matchFullHash);
                preparedStatement.executeUpdate();
            }
        }

        public int getChainId() {
            return this.chainId;
        }

        public int getExchangeId() {
            return this.exchangeId;
        }

        public long getBlockId() {
            return this.blockId;
        }

        public int getHeight() {
            return this.height;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public long getExchangeQuantityQNT() {
            return this.exchangeQuantityQNT;
        }

        public long getExchangePriceNQT() {
            return this.exchangePrice.movePointRight(Chain.getChain(this.chainId).getDecimals()).longValue();
        }

        public BigDecimal getExchangePrice() {
            return this.exchangePrice;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getOrderId() {
            return this.orderId;
        }

        public byte[] getOrderFullHash() {
            return this.orderFullHash;
        }

        public long getMatchId() {
            return this.matchId;
        }

        public byte[] getMatchFullHash() {
            return this.matchFullHash;
        }

        public String toString() {
            return "Coin exchange trade: " + Chain.getChain(this.exchangeId).getName() + " chain: " + Chain.getChain(this.chainId).getName() + " order: " + Long.toUnsignedString(this.orderId) + " match: " + Long.toUnsignedString(this.matchId) + " account: " + Long.toUnsignedString(this.accountId) + " exchangePriceNQT: " + this.getExchangePriceNQT() + " exchangeQuantityQNT: " + this.exchangeQuantityQNT + " height: " + this.height;
        }
    }

    public static final class Order {
        private final DbKey dbKey;
        private final long id;
        private final byte[] fullHash;
        private final short transactionIndex;
        private final int transactionHeight;
        private final int creationHeight;
        private final long accountId;
        private final int chainId;
        private final int exchangeId;
        private long quantityQNT;
        private final long bidPriceNQT;
        private final BigDecimal askPrice;
        private long amountNQT;

        private Order(Transaction transaction, OrderIssueAttachment orderIssueAttachment) {
            this.id = transaction.getId();
            this.fullHash = transaction.getFullHash();
            this.transactionIndex = transaction.getIndex();
            this.transactionHeight = transaction.getHeight();
            this.creationHeight = Nxt.getBlockchain().getHeight();
            this.accountId = transaction.getSenderId();
            Chain chain = orderIssueAttachment.getChain();
            this.chainId = chain.getId();
            Chain chain2 = orderIssueAttachment.getExchangeChain();
            this.exchangeId = chain2.getId();
            this.quantityQNT = orderIssueAttachment.getQuantityQNT();
            this.bidPriceNQT = orderIssueAttachment.getPriceNQT();
            this.askPrice = BigDecimal.ONE.divide(BigDecimal.valueOf(this.bidPriceNQT, chain.getDecimals()), MathContext.DECIMAL128).movePointRight(8).divideToIntegralValue(BigDecimal.ONE, MathContext.DECIMAL128).movePointLeft(8);
            this.amountNQT = Convert.unitRateToAmount(this.quantityQNT, chain2.getDecimals(), orderIssueAttachment.getPriceNQT(), chain.getDecimals()) + 1L;
            this.dbKey = orderDbKeyFactory.newKey(this.id);
        }

        private Order(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.dbKey = dbKey;
            this.id = resultSet.getLong("id");
            this.fullHash = resultSet.getBytes("full_hash");
            this.transactionIndex = resultSet.getShort("transaction_index");
            this.transactionHeight = resultSet.getInt("transaction_height");
            this.creationHeight = resultSet.getInt("transaction_height");
            this.accountId = resultSet.getLong("account_id");
            this.chainId = resultSet.getInt("chain_id");
            this.exchangeId = resultSet.getInt("exchange_id");
            this.quantityQNT = resultSet.getLong("quantity");
            this.bidPriceNQT = resultSet.getLong("bid_price");
            this.askPrice = BigDecimal.valueOf(resultSet.getLong("ask_price"), 8);
            this.amountNQT = resultSet.getLong("amount");
        }

        private void save(Connection connection, String string) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO " + string + " (id, account_id, chain_id, exchange_id, quantity, bid_price, ask_price, amount, full_hash, creation_height, height, transaction_height, transaction_index, latest) KEY(id, height, full_hash) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setInt(++n, this.chainId);
                preparedStatement.setInt(++n, this.exchangeId);
                preparedStatement.setLong(++n, this.quantityQNT);
                preparedStatement.setLong(++n, this.bidPriceNQT);
                preparedStatement.setLong(++n, this.askPrice.movePointRight(8).longValue());
                preparedStatement.setLong(++n, this.amountNQT);
                preparedStatement.setBytes(++n, this.fullHash);
                preparedStatement.setInt(++n, this.creationHeight);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.setInt(++n, this.transactionHeight);
                preparedStatement.setShort(++n, this.transactionIndex);
                preparedStatement.executeUpdate();
            }
        }

        private void updateQuantity(long l, long l2) {
            this.quantityQNT = l2 != 0L ? l : 0L;
            this.amountNQT = l2;
            if (this.quantityQNT > 0L) {
                orderTable.insert(this);
            } else if (this.quantityQNT == 0L) {
                orderTable.delete(this);
            } else {
                throw new IllegalArgumentException("Negative quantity: " + this.quantityQNT + " for order: " + Long.toUnsignedString(this.getId()));
            }
        }

        public final long getId() {
            return this.id;
        }

        public final byte[] getFullHash() {
            return this.fullHash;
        }

        public final long getAccountId() {
            return this.accountId;
        }

        public final int getChainId() {
            return this.chainId;
        }

        public final int getExchangeId() {
            return this.exchangeId;
        }

        public final long getBidPriceNQT() {
            return this.bidPriceNQT;
        }

        public final BigDecimal getBidPrice() {
            return BigDecimal.valueOf(this.bidPriceNQT, Chain.getChain(this.chainId).getDecimals());
        }

        public final long getAskPriceNQT() {
            BigDecimal[] bigDecimalArray = this.askPrice.movePointRight(Chain.getChain(this.exchangeId).getDecimals()).divideAndRemainder(BigDecimal.ONE, MathContext.DECIMAL128);
            return bigDecimalArray[0].longValue() + (long)(bigDecimalArray[1].signum() != 0 ? 1 : 0);
        }

        public final BigDecimal getAskPrice() {
            return this.askPrice;
        }

        public final long getQuantityQNT() {
            return this.quantityQNT;
        }

        public final long getAmountNQT() {
            return this.amountNQT;
        }

        public final int getHeight() {
            return this.creationHeight;
        }

        public final int getTransactionIndex() {
            return this.transactionIndex;
        }

        public final int getTransactionHeight() {
            return this.transactionHeight;
        }

        public String toString() {
            return "Coin exchange order: " + Long.toUnsignedString(this.id) + " account: " + Long.toUnsignedString(this.accountId) + " chain: " + Chain.getChain(this.chainId).getName() + " exchange: " + Chain.getChain(this.exchangeId).getName() + " quantityQNT: " + this.quantityQNT + " bidNQTPerCoin: " + this.bidPriceNQT + " askNQTPerCoin: " + this.getAskPriceNQT() + " height: " + this.creationHeight + " transactionIndex: " + this.transactionIndex + " transactionHeight: " + this.transactionHeight;
        }
    }

    public static enum Event {
        TRADE;

    }
}

