/*
 * Decompiled with CFR 0.152.
 */
package nxt.ce;

import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.Map;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.blockchain.Chain;
import nxt.blockchain.Fee;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.ce.CoinExchange;
import nxt.ce.CoinExchangeTransactionType;
import nxt.ce.OrderCancelAttachment;
import nxt.ce.OrderCancelFxtAttachment;
import nxt.ce.OrderIssueAttachment;
import nxt.ce.OrderIssueFxtAttachment;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class CoinExchangeFxtTransactionType
extends FxtTransactionType {
    private static final byte SUBTYPE_COIN_EXCHANGE_ORDER_ISSUE = 0;
    private static final byte SUBTYPE_COIN_EXCHANGE_ORDER_CANCEL = 1;
    private static final Fee exchangeFee = new Fee.ConstantFee(50000000L);
    public static final TransactionType ORDER_ISSUE = new CoinExchangeFxtTransactionType(){

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.COIN_EXCHANGE_ORDER_ISSUE;
        }

        @Override
        public String getName() {
            return "FxtCoinExchangeOrderIssue";
        }

        @Override
        public OrderIssueFxtAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new OrderIssueFxtAttachment(byteBuffer);
        }

        @Override
        public OrderIssueFxtAttachment parseAttachment(JSONObject jSONObject) throws NxtException.NotValidException {
            return new OrderIssueFxtAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
            OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)fxtTransactionImpl.getAttachment();
            BalanceHome.Balance balance = orderIssueAttachment.getChain().getBalanceHome().getBalance(account.getId());
            long l = Convert.unitRateToAmount(orderIssueAttachment.getQuantityQNT(), orderIssueAttachment.getExchangeChain().getDecimals(), orderIssueAttachment.getPriceNQT(), orderIssueAttachment.getChain().getDecimals()) + 1L;
            if (balance.getUnconfirmedBalance() >= l) {
                balance.addToUnconfirmedBalance(this.getLedgerEvent(), AccountLedger.newEventId(fxtTransactionImpl), -l);
                return true;
            }
            return false;
        }

        @Override
        public void undoAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
            OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)fxtTransactionImpl.getAttachment();
            BalanceHome.Balance balance = orderIssueAttachment.getChain().getBalanceHome().getBalance(account.getId());
            long l = Convert.unitRateToAmount(orderIssueAttachment.getQuantityQNT(), orderIssueAttachment.getExchangeChain().getDecimals(), orderIssueAttachment.getPriceNQT(), orderIssueAttachment.getChain().getDecimals()) + 1L;
            balance.addToUnconfirmedBalance(this.getLedgerEvent(), AccountLedger.newEventId(fxtTransactionImpl), l);
        }

        @Override
        public void applyAttachment(FxtTransactionImpl fxtTransactionImpl, Account account, Account account2) {
            OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)fxtTransactionImpl.getAttachment();
            CoinExchange.addOrder(fxtTransactionImpl, orderIssueAttachment);
        }

        @Override
        public final void validateAttachment(FxtTransactionImpl fxtTransactionImpl) throws NxtException.ValidationException {
            OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)fxtTransactionImpl.getAttachment();
            long l = orderIssueAttachment.getQuantityQNT();
            long l2 = orderIssueAttachment.getPriceNQT();
            Chain chain = orderIssueAttachment.getChain();
            Chain chain2 = orderIssueAttachment.getExchangeChain();
            if (l <= 0L || l > 100000000000000000L || l2 <= 0L || l2 > 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid coin exchange order: " + orderIssueAttachment.getJSONObject());
            }
            if (chain != FxtChain.FXT && chain2 != FxtChain.FXT) {
                throw new NxtException.NotValidException("Only exchange orders to/from Ardor may be submitted on the Fxt chain");
            }
            if (chain == chain2) {
                throw new NxtException.NotValidException("Coin exchange order chain and exchange chain must be different: " + orderIssueAttachment.getJSONObject());
            }
            long l3 = Convert.unitRateToAmount(l, chain2.getDecimals(), l2, chain.getDecimals());
            if (l3 == 0L) {
                throw new NxtException.NotValidException("Coin exchange order has no value: " + orderIssueAttachment.getJSONObject());
            }
            long l4 = BigDecimal.ONE.divide(new BigDecimal(l2).movePointLeft(chain.getDecimals()), MathContext.DECIMAL128).movePointRight(chain2.getDecimals()).longValue();
            if (l4 == 0L) {
                throw new NxtException.NotValidException("Coin exchange order has no value: " + orderIssueAttachment.getJSONObject());
            }
        }

        @Override
        protected void validateId(FxtTransactionImpl fxtTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (CoinExchange.getOrder(fxtTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate coin exchange order id " + fxtTransactionImpl.getStringId());
            }
        }

        @Override
        public final boolean canHaveRecipient() {
            return false;
        }
    };
    public static final TransactionType ORDER_CANCEL = new CoinExchangeFxtTransactionType(){

        @Override
        public final byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.COIN_EXCHANGE_ORDER_CANCEL;
        }

        @Override
        public String getName() {
            return "FxtCoinExchangeOrderCancel";
        }

        @Override
        public OrderCancelFxtAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new OrderCancelFxtAttachment(byteBuffer);
        }

        @Override
        public OrderCancelFxtAttachment parseAttachment(JSONObject jSONObject) {
            return new OrderCancelFxtAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void undoAttachmentUnconfirmed(FxtTransactionImpl fxtTransactionImpl, Account account) {
        }

        @Override
        public boolean isUnconfirmedDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            OrderCancelAttachment orderCancelAttachment = (OrderCancelAttachment)transaction.getAttachment();
            return TransactionType.isDuplicate(CoinExchangeTransactionType.ORDER_CANCEL, Long.toUnsignedString(orderCancelAttachment.getOrderId()), map, true);
        }

        @Override
        public void applyAttachment(FxtTransactionImpl fxtTransactionImpl, Account account, Account account2) {
            OrderCancelAttachment orderCancelAttachment = (OrderCancelAttachment)fxtTransactionImpl.getAttachment();
            CoinExchange.Order order = CoinExchange.getOrder(orderCancelAttachment.getOrderId());
            if (order != null) {
                CoinExchange.removeOrder(orderCancelAttachment.getOrderId());
                BalanceHome.Balance balance = Chain.getChain(order.getChainId()).getBalanceHome().getBalance(account.getId());
                balance.addToUnconfirmedBalance(AccountLedger.LedgerEvent.COIN_EXCHANGE_ORDER_CANCEL, AccountLedger.newEventId(fxtTransactionImpl), order.getAmountNQT());
            }
        }

        @Override
        public final void validateAttachment(FxtTransactionImpl fxtTransactionImpl) throws NxtException.ValidationException {
            OrderCancelAttachment orderCancelAttachment = (OrderCancelAttachment)fxtTransactionImpl.getAttachment();
            CoinExchange.Order order = CoinExchange.getOrder(orderCancelAttachment.getOrderId());
            if (order == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid coin exchange order: " + Long.toUnsignedString(orderCancelAttachment.getOrderId()));
            }
            if (order.getAccountId() != fxtTransactionImpl.getSenderId()) {
                throw new NxtException.NotValidException("Order " + Long.toUnsignedString(order.getId()) + " was created by account " + Convert.rsAccount(order.getAccountId()));
            }
            if (order.getChainId() != FxtChain.FXT.getId() && order.getExchangeId() != FxtChain.FXT.getId()) {
                throw new NxtException.NotValidException("Only cancellations of orders to/from Ardor may be submitted on the Fxt chain");
            }
        }

        @Override
        public final boolean canHaveRecipient() {
            return false;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return ORDER_ISSUE;
            }
            case 1: {
                return ORDER_CANCEL;
            }
        }
        return null;
    }

    private CoinExchangeFxtTransactionType() {
    }

    @Override
    public final byte getType() {
        return -4;
    }

    @Override
    public Fee getBaselineFee(Transaction transaction) {
        return exchangeFee;
    }
}

