/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import nxt.NxtException;
import nxt.crypto.Crypto;
import nxt.util.Convert;

public final class AnonymouslyEncryptedData {
    private final byte[] data;
    private final byte[] publicKey;

    public static AnonymouslyEncryptedData encrypt(byte[] byArray, String string, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = Crypto.getKeySeed(string, byArray2, byArray3);
        byte[] byArray5 = Crypto.getPrivateKey(byArray4);
        byte[] byArray6 = Crypto.getPublicKey(byArray4);
        byte[] byArray7 = Crypto.getSharedKey(byArray5, byArray2);
        byte[] byArray8 = Crypto.aesGCMEncrypt(byArray, byArray7);
        return new AnonymouslyEncryptedData(byArray8, byArray6);
    }

    public static AnonymouslyEncryptedData readEncryptedData(ByteBuffer byteBuffer, int n, int n2) throws NxtException.NotValidException {
        if (n > n2) {
            throw new NxtException.NotValidException("Max encrypted data length exceeded: " + n);
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        byte[] byArray2 = new byte[32];
        byteBuffer.get(byArray2);
        return new AnonymouslyEncryptedData(byArray, byArray2);
    }

    public static AnonymouslyEncryptedData readEncryptedData(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            return AnonymouslyEncryptedData.readEncryptedData(byteBuffer, byArray.length - 32, Integer.MAX_VALUE);
        }
        catch (NxtException.NotValidException notValidException) {
            throw new RuntimeException(notValidException.toString(), notValidException);
        }
    }

    public AnonymouslyEncryptedData(byte[] byArray, byte[] byArray2) {
        this.data = byArray;
        this.publicKey = byArray2;
    }

    public byte[] decrypt(String string) {
        byte[] byArray = Crypto.getSharedKey(Crypto.getPrivateKey(string), this.publicKey);
        return Crypto.aesGCMDecrypt(this.data, byArray);
    }

    public byte[] decrypt(byte[] byArray, byte[] byArray2) {
        if (!Arrays.equals(Crypto.getPublicKey(byArray), this.publicKey)) {
            throw new RuntimeException("Data was not encrypted using this keySeed");
        }
        byte[] byArray3 = Crypto.getSharedKey(Crypto.getPrivateKey(byArray), byArray2);
        return Crypto.aesGCMDecrypt(this.data, byArray3);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public int getSize() {
        return this.data.length + 32;
    }

    public byte[] getBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.data.length + 32);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(this.data);
        byteBuffer.put(this.publicKey);
        return byteBuffer.array();
    }

    public String toString() {
        return "data: " + Convert.toHexString(this.data) + " publicKey: " + Convert.toHexString(this.publicKey);
    }
}

