/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.math.BigInteger;
import java.util.Random;
import nxt.crypto.SecretShare;
import nxt.crypto.SecretSharing;

public final class SimpleShamirSecretSharing
implements SecretSharing {
    SimpleShamirSecretSharing() {
    }

    @Override
    public SecretShare[] split(BigInteger bigInteger, int n, int n2, BigInteger bigInteger2, Random random) {
        BigInteger[] bigIntegerArray = new BigInteger[n];
        bigIntegerArray[0] = bigInteger;
        for (int i = 1; i < n; ++i) {
            BigInteger bigInteger3;
            while ((bigInteger3 = new BigInteger(bigInteger2.bitLength(), random)).compareTo(BigInteger.ZERO) <= 0 || bigInteger3.compareTo(bigInteger2) >= 0) {
            }
            bigIntegerArray[i] = bigInteger3.mod(bigInteger);
        }
        SecretShare[] secretShareArray = new SecretShare[n2];
        for (int i = 1; i <= n2; ++i) {
            BigInteger bigInteger4 = bigInteger;
            for (int j = 1; j < n; ++j) {
                bigInteger4 = bigInteger4.add(bigIntegerArray[j].multiply(BigInteger.valueOf(i).pow(j).mod(bigInteger2))).mod(bigInteger2);
            }
            secretShareArray[i - 1] = new SecretShare(i, bigInteger4);
        }
        return secretShareArray;
    }

    @Override
    public BigInteger combine(SecretShare[] secretShareArray, BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ZERO;
        for (int i = 0; i < secretShareArray.length; ++i) {
            BigInteger bigInteger3 = BigInteger.ONE;
            BigInteger bigInteger4 = BigInteger.ONE;
            for (int j = 0; j < secretShareArray.length; ++j) {
                if (i == j) continue;
                int n = secretShareArray[i].getX();
                int n2 = secretShareArray[j].getX();
                bigInteger3 = bigInteger3.multiply(BigInteger.valueOf(n2).negate()).mod(bigInteger);
                bigInteger4 = bigInteger4.multiply(BigInteger.valueOf(n - n2)).mod(bigInteger);
            }
            BigInteger bigInteger5 = secretShareArray[i].getShare();
            BigInteger bigInteger6 = bigInteger5.multiply(bigInteger3).multiply(bigInteger4.modInverse(bigInteger));
            bigInteger2 = bigInteger.add(bigInteger2).add(bigInteger6).mod(bigInteger);
        }
        return bigInteger2;
    }
}

