/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import nxt.util.Logger;

public final class DbUtils {
    public static void close(AutoCloseable ... autoCloseableArray) {
        for (AutoCloseable autoCloseable : autoCloseableArray) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void rollback(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            Logger.logErrorMessage(sQLException.toString(), sQLException);
        }
    }

    public static void setBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        if (byArray != null) {
            preparedStatement.setBytes(n, byArray);
        } else {
            preparedStatement.setNull(n, -2);
        }
    }

    public static void setString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (string != null) {
            preparedStatement.setString(n, string);
        } else {
            preparedStatement.setNull(n, 12);
        }
    }

    public static void setLong(PreparedStatement preparedStatement, int n, Long l) throws SQLException {
        if (l != null) {
            preparedStatement.setLong(n, l);
        } else {
            preparedStatement.setNull(n, -5);
        }
    }

    public static void setShortZeroToNull(PreparedStatement preparedStatement, int n, short s) throws SQLException {
        if (s != 0) {
            preparedStatement.setShort(n, s);
        } else {
            preparedStatement.setNull(n, 5);
        }
    }

    public static void setIntZeroToNull(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        if (n2 != 0) {
            preparedStatement.setInt(n, n2);
        } else {
            preparedStatement.setNull(n, 4);
        }
    }

    public static void setLongZeroToNull(PreparedStatement preparedStatement, int n, long l) throws SQLException {
        if (l != 0L) {
            preparedStatement.setLong(n, l);
        } else {
            preparedStatement.setNull(n, -5);
        }
    }

    public static <T> T[] getArray(ResultSet resultSet, String string, Class<? extends T[]> clazz) throws SQLException {
        return DbUtils.getArray(resultSet, string, clazz, null);
    }

    public static <T> T[] getArray(ResultSet resultSet, String string, Class<? extends T[]> clazz, T[] TArray) throws SQLException {
        Array array = resultSet.getArray(string);
        if (array != null) {
            Object[] objectArray = (Object[])array.getArray();
            if (Long[].class.equals(clazz)) {
                Long[] longArray = (Long[])Arrays.stream(objectArray).map(object -> ((Number)object).longValue()).toArray(Long[]::new);
                return longArray;
            }
            return Arrays.copyOf(objectArray, objectArray.length, clazz);
        }
        return TArray;
    }

    public static <T> void setArray(PreparedStatement preparedStatement, int n, T[] TArray) throws SQLException {
        if (TArray != null) {
            preparedStatement.setObject(n, TArray);
        } else {
            preparedStatement.setNull(n, 2003);
        }
    }

    public static <T> void setArrayEmptyToNull(PreparedStatement preparedStatement, int n, T[] TArray) throws SQLException {
        if (TArray != null && TArray.length > 0) {
            preparedStatement.setObject(n, TArray);
        } else {
            preparedStatement.setNull(n, 2003);
        }
    }

    public static String limitsClause(int n, int n2) {
        int n3;
        int n4 = n3 = n2 >= 0 && n2 >= n && n2 < Integer.MAX_VALUE ? n2 - n + 1 : 0;
        if (n3 > 0 && n > 0) {
            return " LIMIT ? OFFSET ? ";
        }
        if (n3 > 0) {
            return " LIMIT ? ";
        }
        if (n > 0) {
            return " LIMIT NULL OFFSET ? ";
        }
        return "";
    }

    public static int setLimits(int n, PreparedStatement preparedStatement, int n2, int n3) throws SQLException {
        int n4;
        int n5 = n4 = n3 >= 0 && n3 >= n2 && n3 < Integer.MAX_VALUE ? n3 - n2 + 1 : 0;
        if (n4 > 0) {
            preparedStatement.setInt(n++, n4);
        }
        if (n2 > 0) {
            preparedStatement.setInt(n++, n2);
        }
        return n;
    }

    private DbUtils() {
    }
}

