/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class DelistingAttachment
extends Attachment.AbstractAttachment {
    private final long goodsId;

    DelistingAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.goodsId = byteBuffer.getLong();
    }

    DelistingAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.goodsId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"goods"));
    }

    public DelistingAttachment(long l) {
        this.goodsId = l;
    }

    @Override
    protected int getMySize() {
        return 8;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.goodsId);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"goods", (Object)Long.toUnsignedString(this.goodsId));
    }

    @Override
    public TransactionType getTransactionType() {
        return DigitalGoodsTransactionType.DELISTING;
    }

    public long getGoodsId() {
        return this.goodsId;
    }
}

