/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class ListingAttachment
extends Attachment.AbstractAttachment {
    private final String name;
    private final String description;
    private final String tags;
    private final int quantity;
    private final long priceNQT;

    ListingAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.name = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
        this.description = Convert.readString(byteBuffer, byteBuffer.getShort(), 1000);
        this.tags = Convert.readString(byteBuffer, byteBuffer.getShort(), 100);
        this.quantity = byteBuffer.getInt();
        this.priceNQT = byteBuffer.getLong();
    }

    ListingAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.name = (String)jSONObject.get((Object)"name");
        this.description = (String)jSONObject.get((Object)"description");
        this.tags = (String)jSONObject.get((Object)"tags");
        this.quantity = ((Long)jSONObject.get((Object)"quantity")).intValue();
        this.priceNQT = Convert.parseLong(jSONObject.get((Object)"priceNQT"));
    }

    public ListingAttachment(String string, String string2, String string3, int n, long l) {
        this.name = string;
        this.description = string2;
        this.tags = string3;
        this.quantity = n;
        this.priceNQT = l;
    }

    @Override
    protected int getMySize() {
        return 2 + Convert.toBytes(this.name).length + 2 + Convert.toBytes(this.description).length + 2 + Convert.toBytes(this.tags).length + 4 + 8;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byte[] byArray = Convert.toBytes(this.name);
        byteBuffer.putShort((short)byArray.length);
        byteBuffer.put(byArray);
        byte[] byArray2 = Convert.toBytes(this.description);
        byteBuffer.putShort((short)byArray2.length);
        byteBuffer.put(byArray2);
        byte[] byArray3 = Convert.toBytes(this.tags);
        byteBuffer.putShort((short)byArray3.length);
        byteBuffer.put(byArray3);
        byteBuffer.putInt(this.quantity);
        byteBuffer.putLong(this.priceNQT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"name", (Object)this.name);
        jSONObject.put((Object)"description", (Object)this.description);
        jSONObject.put((Object)"tags", (Object)this.tags);
        jSONObject.put((Object)"quantity", (Object)this.quantity);
        jSONObject.put((Object)"priceNQT", (Object)this.priceNQT);
    }

    @Override
    public TransactionType getTransactionType() {
        return DigitalGoodsTransactionType.LISTING;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTags() {
        return this.tags;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public long getPriceNQT() {
        return this.priceNQT;
    }
}

