/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class PriceChangeAttachment
extends Attachment.AbstractAttachment {
    private final long goodsId;
    private final long priceNQT;

    PriceChangeAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.goodsId = byteBuffer.getLong();
        this.priceNQT = byteBuffer.getLong();
    }

    PriceChangeAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.goodsId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"goods"));
        this.priceNQT = Convert.parseLong(jSONObject.get((Object)"priceNQT"));
    }

    public PriceChangeAttachment(long l, long l2) {
        this.goodsId = l;
        this.priceNQT = l2;
    }

    @Override
    protected int getMySize() {
        return 16;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.goodsId);
        byteBuffer.putLong(this.priceNQT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"goods", (Object)Long.toUnsignedString(this.goodsId));
        jSONObject.put((Object)"priceNQT", (Object)this.priceNQT);
    }

    @Override
    public TransactionType getTransactionType() {
        return DigitalGoodsTransactionType.PRICE_CHANGE;
    }

    public long getGoodsId() {
        return this.goodsId;
    }

    public long getPriceNQT() {
        return this.priceNQT;
    }
}

