/*
 * Decompiled with CFR 0.152.
 */
package nxt.env;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import nxt.env.DirProvider;

abstract class DesktopUserDirProvider
implements DirProvider {
    public static final String LOG_FILE_PATTERN = "java.util.logging.FileHandler.pattern";
    private File logFileDir;

    DesktopUserDirProvider() {
    }

    @Override
    public boolean isLoadPropertyFileFromUserDir() {
        return true;
    }

    @Override
    public void updateLogFileHandler(Properties properties) {
        if (properties.getProperty(LOG_FILE_PATTERN) == null) {
            this.logFileDir = new File(this.getUserHomeDir(), "logs");
            return;
        }
        Path path = Paths.get(this.getUserHomeDir(), new String[0]).resolve(Paths.get(properties.getProperty(LOG_FILE_PATTERN), new String[0]));
        properties.setProperty(LOG_FILE_PATTERN, path.toString());
        Path path2 = path.getParent();
        System.out.printf("Logs dir %s\n", path2.toString());
        this.logFileDir = new File(path2.toString());
        if (!Files.isReadable(path2)) {
            System.out.printf("Creating dir %s\n", path2);
            try {
                Files.createDirectory(path2, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Cannot create " + path2, iOException);
            }
        }
    }

    @Override
    public File getLogFileDir() {
        return this.logFileDir;
    }

    @Override
    public String getDbDir(String string) {
        return Paths.get(this.getUserHomeDir(), new String[0]).resolve(Paths.get(string, new String[0])).toString();
    }

    @Override
    public File getConfDir() {
        return new File(this.getUserHomeDir(), "conf");
    }

    @Override
    public abstract String getUserHomeDir();
}

