/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.ChainTransactionId;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.voting.PhasingVoteCastingAttachment;
import org.json.simple.JSONStreamAware;

public class ApproveTransaction
extends CreateTransaction {
    static final ApproveTransaction instance = new ApproveTransaction();

    private ApproveTransaction() {
        super(new APITag[]{APITag.CREATE_TRANSACTION, APITag.PHASING}, "phasedTransaction", "phasedTransaction", "phasedTransaction", "revealedSecret", "revealedSecret", "revealedSecret", "revealedSecretIsText", "revealedSecretText");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        List<ChainTransactionId> list = ParameterParser.getChainTransactionIds(httpServletRequest, "phasedTransaction");
        if (list.size() > 10) {
            return JSONResponses.TOO_MANY_PHASING_VOTES;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(10);
        String[] stringArray = httpServletRequest.getParameterValues("revealedSecret");
        if (stringArray != null) {
            boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("revealedSecretIsText"));
            for (String string : stringArray) {
                if ((string = Convert.emptyToNull(string)) == null) continue;
                arrayList.add(bl ? Convert.toBytes(string) : Convert.parseHexString(string));
            }
        } else {
            stringArray = httpServletRequest.getParameterValues("revealedSecretText");
            if (stringArray != null) {
                for (String string : stringArray) {
                    if ((string = Convert.emptyToNull(string)) == null) continue;
                    arrayList.add(Convert.toBytes(string));
                }
            }
        }
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        PhasingVoteCastingAttachment phasingVoteCastingAttachment = new PhasingVoteCastingAttachment(list, arrayList);
        return this.createTransaction(httpServletRequest, account, phasingVoteCastingAttachment);
    }
}

