/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.security.MessageDigest;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class CalculateFullHash
extends APIServlet.APIRequestHandler {
    static final CalculateFullHash instance = new CalculateFullHash();

    private CalculateFullHash() {
        super(new APITag[]{APITag.TRANSACTIONS}, "unsignedTransactionBytes", "unsignedTransactionJSON", "signatureHash");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("unsignedTransactionBytes"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("signatureHash"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("unsignedTransactionJSON"));
        if (string2 == null) {
            return JSONResponses.MISSING_SIGNATURE_HASH;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            Transaction transaction = ParameterParser.parseTransaction(string3, string, null).build();
            MessageDigest messageDigest = Crypto.sha256();
            messageDigest.update(transaction.getUnsignedBytes());
            byte[] byArray = messageDigest.digest(Convert.parseHexString(string2));
            jSONObject.put((Object)"fullHash", (Object)Convert.toHexString(byArray));
        }
        catch (NxtException.NotValidException notValidException) {
            JSONData.putException(jSONObject, notValidException, "Incorrect unsigned transaction json or bytes");
        }
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

