/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.ae.BidOrderCancellationAttachment;
import nxt.ae.OrderHome;
import nxt.blockchain.ChildChain;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class CancelBidOrder
extends CreateTransaction {
    static final CancelBidOrder instance = new CancelBidOrder();

    private CancelBidOrder() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "order");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "order", true);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        OrderHome.Bid bid = childChain.getOrderHome().getBidOrder(l);
        if (bid == null || bid.getAccountId() != account.getId()) {
            return JSONResponses.UNKNOWN_ORDER;
        }
        BidOrderCancellationAttachment bidOrderCancellationAttachment = new BidOrderCancellationAttachment(bid.getFullHash());
        return this.createTransaction(httpServletRequest, account, bidOrderCancellationAttachment);
    }
}

