/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Chain;
import nxt.blockchain.FxtChain;
import nxt.ce.CoinExchange;
import nxt.ce.OrderCancelAttachment;
import nxt.ce.OrderCancelFxtAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class CancelCoinExchange
extends CreateTransaction {
    static final CancelCoinExchange instance = new CancelCoinExchange();

    private CancelCoinExchange() {
        super(new APITag[]{APITag.CE, APITag.CREATE_TRANSACTION}, "order");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "order", true);
        Chain chain = ParameterParser.getChain(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        CoinExchange.Order order = CoinExchange.getOrder(l);
        if (order == null) {
            return JSONResponses.UNKNOWN_ORDER;
        }
        if (order.getChainId() != chain.getId()) {
            return JSONResponses.INCORRECT_CHAIN;
        }
        byte[] byArray = order.getFullHash();
        Chain chain2 = Chain.getChain(order.getExchangeId());
        Chain chain3 = chain2.getId() == FxtChain.FXT.getId() ? chain2 : chain;
        OrderCancelAttachment orderCancelAttachment = chain3.getId() == FxtChain.FXT.getId() ? new OrderCancelFxtAttachment(byArray) : new OrderCancelAttachment(byArray);
        try {
            return this.transactionParameters(httpServletRequest, account, orderCancelAttachment).setTxChain(chain3).createTransaction();
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }
}

