/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.PublicKeyAnnouncementAppendix;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.messaging.EncryptedMessageAppendix;
import nxt.messaging.MessageAppendix;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Logger;
import nxt.voting.PhasingAppendix;
import nxt.voting.PhasingParams;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public abstract class CreateTransaction
extends APIServlet.APIRequestHandler {
    private static final String[] commonParameters = new String[]{"secretPhrase", "publicKey", "feeNQT", "feeRateNQTPerFXT", "minBundlerBalanceFXT", "minBundlerFeeLimitFQT", "deadline", "referencedTransaction", "broadcast", "timestamp", "message", "messageIsText", "messageIsPrunable", "messageToEncrypt", "messageToEncryptIsText", "encryptedMessageData", "encryptedMessageNonce", "encryptedMessageIsPrunable", "compressMessageToEncrypt", "messageToEncryptToSelf", "messageToEncryptToSelfIsText", "encryptToSelfMessageData", "encryptToSelfMessageNonce", "compressMessageToEncryptToSelf", "phased", "phasingFinishHeight", "phasingVotingModel", "phasingQuorum", "phasingMinBalance", "phasingHolding", "phasingMinBalanceModel", "phasingWhitelisted", "phasingWhitelisted", "phasingWhitelisted", "phasingLinkedTransaction", "phasingLinkedTransaction", "phasingLinkedTransaction", "phasingHashedSecret", "phasingHashedSecretAlgorithm", "phasingParams", "phasingSubPolls", "phasingSenderPropertySetter", "phasingSenderPropertyName", "phasingSenderPropertyValue", "phasingRecipientPropertySetter", "phasingRecipientPropertyName", "phasingRecipientPropertyValue", "phasingExpression", "recipientPublicKey", "ecBlockId", "ecBlockHeight", "voucher", "sharedPiece", "sharedPiece", "sharedPiece", "sharedPieceAccount"};

    private static String[] addCommonParameters(String[] stringArray) {
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length + commonParameters.length);
        System.arraycopy(commonParameters, 0, stringArray2, stringArray.length, commonParameters.length);
        return stringArray2;
    }

    public static List<String> getCommonParameters() {
        return Collections.unmodifiableList(Arrays.asList(commonParameters));
    }

    CreateTransaction(APITag[] aPITagArray, String ... stringArray) {
        super(aPITagArray, CreateTransaction.addCommonParameters(stringArray));
        if (!this.getAPITags().contains((Object)APITag.CREATE_TRANSACTION)) {
            throw new RuntimeException("CreateTransaction API " + this.getClass().getName() + " is missing APITag.CREATE_TRANSACTION tag");
        }
    }

    protected CreateTransaction(String string, APITag[] aPITagArray, String ... stringArray) {
        super(string, aPITagArray, CreateTransaction.addCommonParameters(stringArray));
        if (!this.getAPITags().contains((Object)APITag.CREATE_TRANSACTION)) {
            throw new RuntimeException("CreateTransaction API " + this.getClass().getName() + " is missing APITag.CREATE_TRANSACTION tag");
        }
    }

    protected final JSONStreamAware createTransaction(HttpServletRequest httpServletRequest, Account account, Attachment attachment) throws NxtException {
        return this.transactionParameters(httpServletRequest, account, attachment).createTransaction();
    }

    protected final CreateTransactionParameters transactionParameters(HttpServletRequest httpServletRequest, Account account, Attachment attachment) {
        return new CreateTransactionParameters(httpServletRequest).setSenderAccount(account).setAttachment(attachment);
    }

    private PhasingAppendix parsePhasing(HttpServletRequest httpServletRequest) throws ParameterException {
        int n = ParameterParser.getInt(httpServletRequest, "phasingFinishHeight", Nxt.getBlockchain().getHeight() + 1, Nxt.getBlockchain().getHeight() + 20160 + 1, true);
        JSONObject jSONObject = ParameterParser.getJson(httpServletRequest, "phasingParams");
        PhasingParams phasingParams = jSONObject != null ? new PhasingParams(jSONObject) : ParameterParser.parsePhasingParams(httpServletRequest, "phasing");
        return new PhasingAppendix(n, phasingParams);
    }

    private JSONStreamAware createTransactionFromParameters(CreateTransactionParameters createTransactionParameters) throws NxtException {
        long l;
        Object object;
        HttpServletRequest httpServletRequest = createTransactionParameters.getReq();
        ChainTransactionId chainTransactionId = createTransactionParameters.getReferencedTransactionId();
        Attachment attachment = createTransactionParameters.getAttachment();
        long l2 = createTransactionParameters.getAmountNQT();
        long l3 = createTransactionParameters.getRecipientId();
        long l4 = createTransactionParameters.getSenderId() == 0L ? createTransactionParameters.getSenderAccount().getId() : createTransactionParameters.getSenderId();
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("voucher"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("publicKey"));
        boolean bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("broadcast")) && string != null && !bl;
        EncryptedMessageAppendix encryptedMessageAppendix = null;
        PrunableEncryptedMessageAppendix prunableEncryptedMessageAppendix = null;
        if (attachment.getTransactionType().canHaveRecipient() && l3 != 0L) {
            object = Account.getAccount(l3);
            if ("true".equalsIgnoreCase(httpServletRequest.getParameter("encryptedMessageIsPrunable"))) {
                prunableEncryptedMessageAppendix = (PrunableEncryptedMessageAppendix)ParameterParser.getEncryptedMessage(httpServletRequest, (Account)object, true);
            } else {
                encryptedMessageAppendix = (EncryptedMessageAppendix)ParameterParser.getEncryptedMessage(httpServletRequest, (Account)object, false);
            }
        }
        object = ParameterParser.getEncryptToSelfMessage(httpServletRequest);
        MessageAppendix messageAppendix = null;
        PrunablePlainMessageAppendix prunablePlainMessageAppendix = null;
        if ("true".equalsIgnoreCase(httpServletRequest.getParameter("messageIsPrunable"))) {
            prunablePlainMessageAppendix = (PrunablePlainMessageAppendix)ParameterParser.getPlainMessage(httpServletRequest, true);
        } else {
            messageAppendix = (MessageAppendix)ParameterParser.getPlainMessage(httpServletRequest, false);
        }
        PublicKeyAnnouncementAppendix publicKeyAnnouncementAppendix = null;
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("recipientPublicKey"));
        if (string3 != null) {
            publicKeyAnnouncementAppendix = new PublicKeyAnnouncementAppendix(Convert.parseHexString(string3));
        }
        PhasingAppendix phasingAppendix = null;
        boolean bl3 = "true".equalsIgnoreCase(httpServletRequest.getParameter("phased"));
        if (bl3) {
            phasingAppendix = this.parsePhasing(httpServletRequest);
        }
        if (string == null && string2 == null) {
            return JSONResponses.MISSING_SECRET_PHRASE;
        }
        short s = (short)ParameterParser.getInt(httpServletRequest, "deadline", 1, Short.MAX_VALUE, 15);
        long l5 = ParameterParser.getLong(httpServletRequest, "feeNQT", -1L, 100000000000000000L, -1L);
        int n = ParameterParser.getInt(httpServletRequest, "ecBlockHeight", 0, Integer.MAX_VALUE, false);
        long l6 = Convert.parseUnsignedLong(httpServletRequest.getParameter("ecBlockId"));
        if (l6 != 0L && l6 != Nxt.getBlockchain().getBlockIdAtHeight(n)) {
            return JSONResponses.INCORRECT_EC_BLOCK;
        }
        if (l6 == 0L && n > 0) {
            l6 = Nxt.getBlockchain().getBlockIdAtHeight(n);
        }
        int n2 = ParameterParser.getTimestamp(httpServletRequest);
        long l7 = ParameterParser.getLong(httpServletRequest, "feeRateNQTPerFXT", -1L, 100000000000000000L, -1L);
        JSONObject jSONObject = new JSONObject();
        byte[] byArray = string != null && !bl ? Crypto.getPublicKey(string) : Convert.parseHexString(string2);
        Chain chain = createTransactionParameters.getChain();
        if (l5 < 0L && l7 < 0L && chain != FxtChain.FXT) {
            long l8 = ParameterParser.getLong(httpServletRequest, "minBundlerBalanceFXT", 0L, 1000000000L, Constants.minBundlerBalanceFXT);
            l = ParameterParser.getLong(httpServletRequest, "minBundlerFeeLimitFQT", 0L, 100000000000000000L, (long)Constants.minBundlerFeeLimitFXT * 100000000L);
            l7 = Peers.getBestBundlerRate(chain, l8, l, Peers.getBestBundlerRateWhitelist());
            bl2 = false;
            if (!bl) {
                jSONObject.put((Object)"bundlerRateNQTPerFXT", (Object)String.valueOf(l7));
            }
        }
        try {
            Transaction.Builder builder = chain.newTransactionBuilder(byArray, l2, l5, s, attachment);
            if (chain instanceof ChildChain) {
                if (!(attachment.getTransactionType() instanceof ChildTransactionType)) {
                    throw new ParameterException(JSONResponses.incorrect("chain", attachment.getTransactionType().getName() + " attachment not allowed for " + chain.getName() + " chain"));
                }
                builder = ((ChildTransaction.Builder)builder).referencedTransaction(chainTransactionId).feeRateNQTPerFXT(l7).appendix(encryptedMessageAppendix).appendix(messageAppendix).appendix(publicKeyAnnouncementAppendix).appendix((Appendix)object).appendix(phasingAppendix);
            } else {
                if (!(attachment.getTransactionType() instanceof FxtTransactionType)) {
                    throw new ParameterException(JSONResponses.incorrect("chain", attachment.getTransactionType().getName() + " attachment not allowed for " + chain.getName() + " chain"));
                }
                if (chainTransactionId != null) {
                    return JSONResponses.error("Referenced transactions not allowed for Ardor transactions");
                }
                if (encryptedMessageAppendix != null) {
                    return JSONResponses.error("Permanent encrypted message attachments not allowed for Ardor transactions");
                }
                if (messageAppendix != null) {
                    return JSONResponses.error("Permanent message attachments not allowed for Ardor transactions");
                }
                if (publicKeyAnnouncementAppendix != null) {
                    return JSONResponses.error("Public key announcement attachments not allowed for Ardor transactions");
                }
                if (object != null) {
                    return JSONResponses.error("Encrypted to self message attachments not allowed for Ardor transactions");
                }
                if (phasingAppendix != null) {
                    return JSONResponses.error("Phasing attachments not allowed for Ardor transactions");
                }
            }
            builder.appendix(prunablePlainMessageAppendix).appendix(prunableEncryptedMessageAppendix);
            if (attachment.getTransactionType().canHaveRecipient()) {
                builder.recipientId(l3);
            }
            if (l6 != 0L) {
                builder.ecBlockId(l6);
                builder.ecBlockHeight(n);
            }
            if (n2 > 0) {
                builder.timestamp(n2);
            }
            Transaction transaction = builder.build(string, bl);
            try {
                l = chain.getBalanceHome().getBalance(l4).getUnconfirmedBalance();
                if (Math.addExact(l2, transaction.getFee()) > l) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put((Object)"errorCode", (Object)6);
                    jSONObject2.put((Object)"errorDescription", (Object)"Not enough funds");
                    jSONObject2.put((Object)"amount", (Object)String.valueOf(l2));
                    jSONObject2.put((Object)"fee", (Object)String.valueOf(transaction.getFee()));
                    jSONObject2.put((Object)"balance", (Object)String.valueOf(l));
                    jSONObject2.put((Object)"diff", (Object)String.valueOf(Math.subtractExact(Math.addExact(l2, transaction.getFee()), l)));
                    jSONObject2.put((Object)"chain", (Object)chain.getId());
                    return JSON.prepare(jSONObject2);
                }
            }
            catch (ArithmeticException arithmeticException) {
                Logger.logErrorMessage(String.format("amount %d fee %d", l2, transaction.getFee()), arithmeticException);
                return JSONResponses.NOT_ENOUGH_FUNDS;
            }
            JSONObject jSONObject3 = JSONData.unconfirmedTransaction(transaction);
            if (bl) {
                jSONObject3.remove((Object)"fullHash");
                jSONObject3.put((Object)"signature", null);
            }
            jSONObject.put((Object)"transactionJSON", (Object)jSONObject3);
            try {
                jSONObject.put((Object)"unsignedTransactionBytes", (Object)Convert.toHexString(transaction.getUnsignedBytes()));
            }
            catch (NxtException.NotYetEncryptedException notYetEncryptedException) {
                // empty catch block
            }
            if (string != null) {
                if (bl) {
                    jSONObject.put((Object)"signature", (Object)Convert.toHexString(transaction.getSignature()));
                    jSONObject.put((Object)"publicKey", (Object)Convert.toHexString(Crypto.getPublicKey(string)));
                    jSONObject.put((Object)"requestType", (Object)httpServletRequest.getParameter("requestType"));
                    ParameterParser.parseVoucher(jSONObject);
                } else {
                    jSONObject.put((Object)"fullHash", jSONObject3.get((Object)"fullHash"));
                    jSONObject.put((Object)"transactionBytes", (Object)Convert.toHexString(transaction.getBytes()));
                    jSONObject.put((Object)"signatureHash", jSONObject3.get((Object)"signatureHash"));
                }
            }
            if (!bl) {
                jSONObject.put((Object)"minimumFeeFQT", (Object)String.valueOf(transaction.getMinimumFeeFQT()));
            }
            if (bl2) {
                Nxt.getTransactionProcessor().broadcast(transaction);
                jSONObject.put((Object)"broadcasted", (Object)true);
            } else {
                transaction.validate();
                if (!bl) {
                    jSONObject.put((Object)"broadcasted", (Object)false);
                }
            }
        }
        catch (NxtException.NotYetEnabledException notYetEnabledException) {
            return JSONResponses.FEATURE_NOT_AVAILABLE;
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            throw insufficientBalanceException;
        }
        catch (NxtException.ValidationException validationException) {
            if (bl2) {
                jSONObject.clear();
            }
            jSONObject.put((Object)"broadcasted", (Object)false);
            JSONData.putException(jSONObject, validationException);
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected final boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected final boolean isChainSpecific() {
        return true;
    }

    protected class CreateTransactionParameters {
        private final HttpServletRequest req;
        private Account senderAccount;
        private long senderId;
        private long recipientId;
        private long amountNQT;
        private Attachment attachment;
        private Chain txChain;
        private ChainTransactionId referencedTransactionId;

        protected CreateTransactionParameters(HttpServletRequest httpServletRequest) {
            this.req = httpServletRequest;
        }

        public CreateTransactionParameters setSenderAccount(Account account) {
            this.senderAccount = account;
            return this;
        }

        public CreateTransactionParameters setSenderId(long l) {
            this.senderId = l;
            return this;
        }

        public CreateTransactionParameters setRecipientId(long l) {
            this.recipientId = l;
            return this;
        }

        public CreateTransactionParameters setAmountNQT(long l) {
            this.amountNQT = l;
            return this;
        }

        public CreateTransactionParameters setAttachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public CreateTransactionParameters setTxChain(Chain chain) {
            this.txChain = chain;
            return this;
        }

        public CreateTransactionParameters setReferencedTransactionId(ChainTransactionId chainTransactionId) {
            this.referencedTransactionId = chainTransactionId;
            return this;
        }

        public HttpServletRequest getReq() {
            return this.req;
        }

        public Chain getChain() throws ParameterException {
            if (this.txChain != null) {
                return this.txChain;
            }
            return ParameterParser.getChain(this.req);
        }

        public ChainTransactionId getReferencedTransactionId() throws ParameterException {
            if (this.referencedTransactionId != null) {
                return this.referencedTransactionId;
            }
            return ParameterParser.getChainTransactionId(this.req, "referencedTransaction");
        }

        public Account getSenderAccount() throws ParameterException {
            if (this.senderAccount != null) {
                return this.senderAccount;
            }
            return ParameterParser.getSenderAccount(this.req);
        }

        public long getSenderId() {
            return this.senderId;
        }

        public Attachment getAttachment() {
            return this.attachment;
        }

        public long getAmountNQT() {
            return this.amountNQT;
        }

        public long getRecipientId() {
            return this.recipientId;
        }

        protected final JSONStreamAware createTransaction() throws NxtException {
            return CreateTransaction.this.createTransactionFromParameters(this);
        }
    }
}

