/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Attachment;
import nxt.crypto.EncryptedData;
import nxt.dgs.DeliveryAttachment;
import nxt.dgs.DigitalGoodsHome;
import nxt.dgs.UnencryptedDeliveryAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class DGSDelivery
extends CreateTransaction {
    static final DGSDelivery instance = new DGSDelivery();

    private DGSDelivery() {
        super(new APITag[]{APITag.DGS, APITag.CREATE_TRANSACTION}, "purchase", "discountNQT", "goodsToEncrypt", "goodsIsText", "goodsData", "goodsNonce");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        boolean bl;
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        DigitalGoodsHome.Purchase purchase = ParameterParser.getPurchase(httpServletRequest);
        if (account.getId() != purchase.getSellerId()) {
            return JSONResponses.INCORRECT_PURCHASE;
        }
        if (!purchase.isPending()) {
            return JSONResponses.ALREADY_DELIVERED;
        }
        String string = Convert.emptyToNull(httpServletRequest.getParameter("discountNQT"));
        long l = 0L;
        try {
            if (string != null) {
                l = Long.parseLong(string);
            }
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_DGS_DISCOUNT;
        }
        if (l < 0L || l > 100000000000000000L || l > Math.multiplyExact(purchase.getPriceNQT(), (long)purchase.getQuantity())) {
            return JSONResponses.INCORRECT_DGS_DISCOUNT;
        }
        Account account2 = Account.getAccount(purchase.getBuyerId());
        boolean bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("goodsIsText"));
        EncryptedData encryptedData = ParameterParser.getEncryptedData(httpServletRequest, "goods");
        byte[] byArray = null;
        boolean bl3 = bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("broadcast"));
        if (encryptedData == null) {
            try {
                object = Convert.nullToEmpty(httpServletRequest.getParameter("goodsToEncrypt"));
                if (((String)object).length() == 0) {
                    return JSONResponses.INCORRECT_DGS_GOODS;
                }
                byArray = bl2 ? Convert.toBytes((String)object) : Convert.parseHexString((String)object);
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.INCORRECT_DGS_GOODS;
            }
            object = ParameterParser.getSecretPhrase(httpServletRequest, bl);
            if (object != null) {
                encryptedData = account2.encryptTo(byArray, (String)object, true);
            }
        }
        object = encryptedData == null ? new UnencryptedDeliveryAttachment(purchase.getId(), byArray, bl2, l, Account.getPublicKey(account2.getId())) : new DeliveryAttachment(purchase.getId(), encryptedData, bl2, l);
        return this.transactionParameters(httpServletRequest, account, (Attachment)object).setRecipientId(account2.getId()).createTransaction();
    }
}

